/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.setting.dialect;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.resource.NoResourceException;
import cn.hutool.core.util.StrUtil;
import cn.hutool.setting.dialect.Props;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PropsUtil {
    private static final Map<String, Props> propsMap = new ConcurrentHashMap<String, Props>();

    public static Props get(String name2) {
        return propsMap.computeIfAbsent(name2, filePath -> {
            String extName = FileUtil.extName(filePath);
            if (StrUtil.isEmpty(extName)) {
                filePath = filePath + "." + "properties";
            }
            return new Props((String)filePath);
        });
    }

    public static Props getFirstFound(String ... names) {
        for (String name2 : names) {
            try {
                return PropsUtil.get(name2);
            }
            catch (NoResourceException noResourceException) {
            }
        }
        return null;
    }

    public static Props getSystemProps() {
        return new Props(System.getProperties());
    }
}

