/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.io.impl;

import com.mchange.io.FileEnumeration;
import com.mchange.io.IOEnumeration;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Stack;

public class DirectoryDescendingFileFinderImpl
implements IOEnumeration,
FileEnumeration {
    private static final Object dummy = new Object();
    Hashtable markedDirex = new Hashtable();
    Stack direx = new Stack();
    Stack files = new Stack();
    FilenameFilter filter;
    boolean canonical;

    public DirectoryDescendingFileFinderImpl(File file2, FilenameFilter filenameFilter, boolean bl) throws IOException {
        if (!file2.isDirectory()) {
            throw new IllegalArgumentException(file2.getName() + " is not a directory.");
        }
        this.filter = filenameFilter;
        this.canonical = bl;
        this.blossomDirectory(file2);
        while (this.files.empty() && !this.direx.empty()) {
            this.blossomDirectory((File)this.direx.pop());
        }
    }

    public DirectoryDescendingFileFinderImpl(File file2) throws IOException {
        this(file2, null, false);
    }

    @Override
    public boolean hasMoreFiles() {
        return !this.files.empty();
    }

    @Override
    public File nextFile() throws IOException {
        if (this.files.empty()) {
            throw new NoSuchElementException();
        }
        File file2 = (File)this.files.pop();
        while (this.files.empty() && !this.direx.empty()) {
            this.blossomDirectory((File)this.direx.pop());
        }
        return file2;
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMoreFiles();
    }

    @Override
    public Object nextElement() throws IOException {
        return this.nextFile();
    }

    private void blossomDirectory(File file2) throws IOException {
        String string2 = file2.getCanonicalPath();
        String[] stringArray = this.filter == null ? file2.list() : file2.list(this.filter);
        int n = stringArray.length;
        while (--n >= 0) {
            if (this.filter != null && !this.filter.accept(file2, stringArray[n])) continue;
            String string3 = (this.canonical ? string2 : file2.getPath()) + File.separator + stringArray[n];
            File file3 = new File(string3);
            if (file3.isFile()) {
                this.files.push(file3);
                continue;
            }
            if (this.markedDirex.containsKey(file3.getCanonicalPath())) continue;
            this.direx.push(file3);
        }
        this.markedDirex.put(string2, dummy);
    }

    public static void main(String[] stringArray) {
        try {
            File file2 = new File(stringArray[0]);
            DirectoryDescendingFileFinderImpl directoryDescendingFileFinderImpl = new DirectoryDescendingFileFinderImpl(file2);
            while (directoryDescendingFileFinderImpl.hasMoreFiles()) {
                System.out.println(directoryDescendingFileFinderImpl.nextFile().getAbsolutePath());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

