/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.util;

import com.mchange.v1.util.IteratorUtils;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class SetUtils {
    public static Set oneElementUnmodifiableSet(final Object object) {
        return new AbstractSet(){

            @Override
            public Iterator iterator() {
                return IteratorUtils.oneElementUnmodifiableIterator(object);
            }

            @Override
            public int size() {
                return 1;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public boolean contains(Object object2) {
                return object2 == object;
            }
        };
    }

    public static Set setFromArray(Object[] objectArray) {
        HashSet<Object> hashSet = new HashSet<Object>();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            hashSet.add(objectArray[i]);
        }
        return hashSet;
    }

    public static boolean equivalentDisregardingSort(Set set2, Set set3) {
        return set2.containsAll(set3) && set3.containsAll(set2);
    }

    public static int hashContentsDisregardingSort(Set set2) {
        int n = 0;
        for (Object e2 : set2) {
            if (e2 == null) continue;
            n ^= e2.hashCode();
        }
        return n;
    }
}

