/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.io;

import com.mchange.v2.io.DirectoryDescentUtils;
import com.mchange.v2.io.FileIterator;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class FileUtils {
    public static File findRelativeToParent(File file2, File file3) throws IOException {
        String string2 = file2.getPath();
        String string3 = file3.getPath();
        if (!string3.startsWith(string2)) {
            throw new IllegalArgumentException(string3 + " is not a child of " + string2 + " [no transformations or canonicalizations tried]");
        }
        String string4 = string3.substring(string2.length());
        File file4 = new File(string4);
        if (file4.isAbsolute()) {
            file4 = new File(file4.getPath().substring(1));
        }
        return file4;
    }

    public static long diskSpaceUsed(File file2) throws IOException {
        long l = 0L;
        FileIterator fileIterator = DirectoryDescentUtils.depthFirstEagerDescent(file2);
        while (fileIterator.hasNext()) {
            File file3 = fileIterator.nextFile();
            if (!file3.isFile()) continue;
            l += file3.length();
        }
        return l;
    }

    public static void touchExisting(File file2) throws IOException {
        if (file2.exists()) {
            FileUtils.unguardedTouch(file2);
        }
    }

    public static void touch(File file2) throws IOException {
        if (!file2.exists()) {
            FileUtils.createEmpty(file2);
        }
        FileUtils.unguardedTouch(file2);
    }

    public static void createEmpty(File file2) throws IOException {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file2, "rws");
            randomAccessFile.setLength(0L);
        }
        finally {
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static void unguardedTouch(File file2) throws IOException {
        file2.setLastModified(System.currentTimeMillis());
    }

    private FileUtils() {
    }
}

