/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.lang;

import java.io.UnsupportedEncodingException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class StringUtils {
    static final Pattern COMMA_SEP_TRIM_REGEX;
    static final Pattern COMMA_SEP_NO_TRIM_REGEX;
    public static final String[] EMPTY_STRING_ARRAY;

    public static String normalString(String string2) {
        return StringUtils.nonEmptyTrimmedOrNull(string2);
    }

    public static boolean nonEmptyString(String string2) {
        return string2 != null && string2.length() > 0;
    }

    public static boolean nonWhitespaceString(String string2) {
        return string2 != null && string2.trim().length() > 0;
    }

    public static String nonEmptyOrNull(String string2) {
        return StringUtils.nonEmptyString(string2) ? string2 : null;
    }

    public static String nonNullOrBlank(String string2) {
        return string2 != null ? string2 : "";
    }

    public static String nonEmptyTrimmedOrNull(String string2) {
        String string3 = string2;
        if (string3 != null) {
            string3 = (string3 = string3.trim()).length() > 0 ? string3 : null;
        }
        return string3;
    }

    public static byte[] getUTF8Bytes(String string2) {
        try {
            return string2.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            throw new InternalError("UTF8 is an unsupported encoding?!?");
        }
    }

    public static String[] splitCommaSeparated(String string2, boolean bl) {
        Pattern pattern = bl ? COMMA_SEP_TRIM_REGEX : COMMA_SEP_NO_TRIM_REGEX;
        return pattern.split(string2);
    }

    static {
        try {
            COMMA_SEP_TRIM_REGEX = Pattern.compile("\\s*\\,\\s*");
            COMMA_SEP_NO_TRIM_REGEX = Pattern.compile("\\,");
        }
        catch (PatternSyntaxException patternSyntaxException) {
            patternSyntaxException.printStackTrace();
            throw new InternalError(patternSyntaxException.toString());
        }
        EMPTY_STRING_ARRAY = new String[0];
    }
}

