/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v3.filecache;

import com.mchange.v3.filecache.FileCacheKey;
import java.net.MalformedURLException;
import java.net.URL;

public class RelativePathFileCacheKey
implements FileCacheKey {
    final URL url;
    final String relPath;

    public RelativePathFileCacheKey(URL uRL, String string2) throws MalformedURLException, IllegalArgumentException {
        String string3 = string2.trim();
        if (uRL == null || string2 == null) {
            throw new IllegalArgumentException("parentURL [" + uRL + "] and relative path [" + string2 + "] must be non-null");
        }
        if (string3.length() == 0) {
            throw new IllegalArgumentException("relative path [" + string2 + "] must not be a blank string");
        }
        if (!string3.equals(string2)) {
            throw new IllegalArgumentException("relative path [" + string2 + "] must not begin or end with whitespace.");
        }
        if (string2.startsWith("/")) {
            throw new IllegalArgumentException("Path must be relative, '" + string2 + "' begins with '/'.");
        }
        this.url = new URL(uRL, string2);
        this.relPath = string2;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public String getCacheFilePath() {
        return this.relPath;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof RelativePathFileCacheKey) {
            RelativePathFileCacheKey relativePathFileCacheKey = (RelativePathFileCacheKey)object;
            return this.url.equals(relativePathFileCacheKey.url) && this.relPath.equals(relativePathFileCacheKey.relPath);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.url.hashCode() ^ this.relPath.hashCode();
    }
}

