/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v3.hocon;

import com.mchange.v2.cfg.DelayedLogItem;
import com.mchange.v2.cfg.PropertiesConfigSource;
import com.mchange.v3.hocon.HoconUtils;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public final class HoconPropertiesConfigSource
implements PropertiesConfigSource {
    private static Config extractConfig(ClassLoader classLoader, String string2, List<DelayedLogItem> list) throws FileNotFoundException, Exception {
        int n = string2.indexOf(58);
        ArrayList<Config> arrayList = new ArrayList<Config>();
        if (n >= 0 && "hocon".equals(string2.substring(0, n).toLowerCase())) {
            Config config;
            String string3 = string2.substring(n + 1).trim();
            for (String string4 : config = string3.split("\\s*,\\s*")) {
                String string5;
                String string6;
                int n2 = string4.lastIndexOf(35);
                if (n2 > 0) {
                    string6 = string4.substring(0, n2);
                    string5 = string4.substring(n2 + 1).replace('/', '.').trim();
                } else {
                    string6 = string4;
                    string5 = null;
                }
                Config config2 = null;
                if ("/".equals(string6)) {
                    config2 = ConfigFactory.systemProperties();
                } else {
                    Config config3 = null;
                    if ("application".equals(string6) || "/application".equals(string6)) {
                        String string7 = System.getProperty("config.resource");
                        if (string7 != null) {
                            string6 = string7;
                        } else {
                            string7 = System.getProperty("config.file");
                            if (string7 != null) {
                                File file2 = new File(string7);
                                if (file2.exists()) {
                                    if (file2.canRead()) {
                                        config3 = ConfigFactory.parseFile((File)file2);
                                    } else {
                                        list.add(new DelayedLogItem(DelayedLogItem.Level.WARNING, String.format("Specified config.file '%s' is not readable. Falling back to standard application.(conf|json|properties).}", file2.getAbsolutePath())));
                                    }
                                } else {
                                    list.add(new DelayedLogItem(DelayedLogItem.Level.WARNING, String.format("Specified config.file '%s' does not exist. Falling back to standard application.(conf|json|properties).}", file2.getAbsolutePath())));
                                }
                            } else {
                                string7 = System.getProperty("config.url");
                                if (string7 != null) {
                                    config3 = ConfigFactory.parseURL((URL)new URL(string7));
                                }
                            }
                        }
                    }
                    if (config3 == null) {
                        if (string6.charAt(0) == '/') {
                            string6 = string6.substring(1);
                        }
                        boolean bl = string6.indexOf(46) >= 0;
                        config3 = bl ? ConfigFactory.parseResources((ClassLoader)classLoader, (String)string6) : ConfigFactory.parseResourcesAnySyntax((ClassLoader)classLoader, (String)string6);
                    }
                    if (config3.isEmpty()) {
                        list.add(new DelayedLogItem(DelayedLogItem.Level.FINE, String.format("Missing or empty HOCON configuration for resource path '%s'.", string6)));
                    } else {
                        config2 = config3;
                    }
                }
                if (config2 == null) continue;
                if (string5 != null) {
                    config2 = config2.getConfig(string5);
                }
                arrayList.add(config2);
            }
            if (arrayList.size() == 0) {
                throw new FileNotFoundException(String.format("Could not find HOCON configuration at any of the listed resources in '%s'", string2));
            }
            Config config4 = ConfigFactory.empty();
            int n3 = arrayList.size();
            while (--n3 >= 0) {
                config4 = config4.withFallback((ConfigMergeable)arrayList.get(n3));
            }
            return config4.resolve();
        }
        throw new IllegalArgumentException(String.format("Invalid resource identifier for hocon config file: '%s'", string2));
    }

    public PropertiesConfigSource.Parse propertiesFromSource(ClassLoader classLoader, String string2) throws FileNotFoundException, Exception {
        LinkedList<DelayedLogItem> linkedList = new LinkedList<DelayedLogItem>();
        Config config = HoconPropertiesConfigSource.extractConfig(classLoader, string2, linkedList);
        HoconUtils.PropertiesConversion propertiesConversion = HoconUtils.configToProperties(config);
        for (String string3 : propertiesConversion.unrenderable) {
            linkedList.add(new DelayedLogItem(DelayedLogItem.Level.FINE, String.format("Value at path '%s' could not be converted to a String. Skipping.", string3)));
        }
        return new PropertiesConfigSource.Parse(propertiesConversion.properties, linkedList);
    }

    @Override
    public PropertiesConfigSource.Parse propertiesFromSource(String string2) throws FileNotFoundException, Exception {
        return this.propertiesFromSource(HoconPropertiesConfigSource.class.getClassLoader(), string2);
    }
}

