/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v3.hocon;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class HoconUtils {
    private static final String APPLICATION = "application";

    public static PropertiesConversion configToProperties(Config config) {
        Set set2 = config.entrySet();
        Properties properties = new Properties();
        HashSet<String> hashSet = new HashSet<String>();
        for (Map.Entry entry : set2) {
            String string2 = (String)entry.getKey();
            String string3 = null;
            try {
                string3 = config.getString(string2);
            }
            catch (ConfigException.WrongType wrongType) {
                hashSet.add(string2);
            }
            if (string3 == null) continue;
            properties.setProperty(string2, string3);
        }
        PropertiesConversion propertiesConversion = new PropertiesConversion();
        propertiesConversion.properties = properties;
        propertiesConversion.unrenderable = hashSet;
        return propertiesConversion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Config applicationOrStandardSubstitute(ClassLoader classLoader) throws SubstituteNotAvailableException {
        String string2 = APPLICATION;
        Config config = null;
        String string3 = System.getProperty("config.resource");
        if (string3 != null) {
            string2 = string3;
        } else {
            string3 = System.getProperty("config.file");
            if (string3 != null) {
                File file2 = new File(string3);
                if (!file2.exists()) throw new SubstituteNotAvailableException(String.format("Specified config.file '%s' (specified as a System property) does not exist.", file2.getAbsolutePath()));
                if (!file2.canRead()) throw new SubstituteNotAvailableException(String.format("config.file '%s' (specified as a System property) is not readable.", file2.getAbsolutePath()));
                config = ConfigFactory.parseFile((File)file2);
            } else {
                string3 = System.getProperty("config.url");
                if (string3 != null) {
                    try {
                        config = ConfigFactory.parseURL((URL)new URL(string3));
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new SubstituteNotAvailableException(String.format("Specified config.url '%s' (specified as a System property) could not be parsed.", string3));
                    }
                }
            }
        }
        if (config != null) return config;
        return ConfigFactory.parseResourcesAnySyntax((ClassLoader)classLoader, (String)string2);
    }

    public static ConfigWithFallbackMessage applicationOrStandardSubstituteFallbackWithMessage(ClassLoader classLoader) throws SubstituteNotAvailableException {
        try {
            return new ConfigWithFallbackMessage(HoconUtils.applicationOrStandardSubstitute(classLoader), null);
        }
        catch (SubstituteNotAvailableException substituteNotAvailableException) {
            return new ConfigWithFallbackMessage(ConfigFactory.parseResourcesAnySyntax((ClassLoader)classLoader, (String)APPLICATION), substituteNotAvailableException.getMessage() + " Falling back to standard application.(conf|json|properties).");
        }
    }

    private HoconUtils() {
    }

    public static class ConfigWithFallbackMessage {
        private Config _config;
        private String _message;

        public Config config() {
            return this._config;
        }

        public String message() {
            return this._message;
        }

        private ConfigWithFallbackMessage(Config config, String string2) {
            this._config = config;
            this._message = string2;
        }
    }

    public static class SubstituteNotAvailableException
    extends Exception {
        SubstituteNotAvailableException(String string2) {
            super(string2);
        }
    }

    public static class PropertiesConversion {
        Properties properties;
        Set<String> unrenderable;
    }
}

