/*
 * Decompiled with CFR 0.152.
 */
package com.summersec.attack.Encrypt;

import com.summersec.attack.Encrypt.EncryptInterface;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.shiro.codec.Base64;

public class GcmEncrypt
implements EncryptInterface {
    private static SecureRandom secureRandom;
    private static int initializationVectorSize;

    @Override
    public String getName() {
        return "gcm";
    }

    @Override
    public byte[] getBytes(Object obj) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        byteArrayOutputStream = new ByteArrayOutputStream();
        objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(obj);
        objectOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public String encrypt(String key2, byte[] payload) {
        try {
            byte[] raw = Base64.decode(key2);
            byte[] ivs = GcmEncrypt.generateInitializationVector();
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance("AES/GCM/PKCS5Padding");
            GCMParameterSpec iv = new GCMParameterSpec(128, ivs);
            cipher.init(1, (Key)skeySpec, iv);
            byte[] encrypted = cipher.doFinal(GcmEncrypt.pad(payload));
            return new String(Base64.encode(GcmEncrypt.byteMerger(ivs, encrypted)));
        }
        catch (Exception exception) {
            return "0";
        }
    }

    private static byte[] pad(byte[] s) {
        s = GcmEncrypt.byteMerger(s, GcmEncrypt.charToByte((char)(16 - s.length % 16)));
        return s;
    }

    private static byte[] charToByte(char c) {
        byte[] b = new byte[]{(byte)((c & 0xFF00) >> 8), (byte)(c & 0xFF)};
        return b;
    }

    private static byte[] byteMerger(byte[] bt1, byte[] bt2) {
        byte[] bt3 = new byte[bt1.length + bt2.length];
        System.arraycopy(bt1, 0, bt3, 0, bt1.length);
        System.arraycopy(bt2, 0, bt3, bt1.length, bt2.length);
        return bt3;
    }

    private static byte[] generateInitializationVector() {
        int size = GcmEncrypt.getInitializationVectorSize();
        int sizeInBytes = size / 8;
        byte[] ivBytes = new byte[sizeInBytes];
        SecureRandom random = GcmEncrypt.ensureSecureRandom();
        random.nextBytes(ivBytes);
        return ivBytes;
    }

    private static SecureRandom ensureSecureRandom() {
        SecureRandom random = GcmEncrypt.getSecureRandom();
        if (random == null) {
            random = GcmEncrypt.getDefaultSecureRandom();
        }
        return random;
    }

    private static SecureRandom getSecureRandom() {
        return secureRandom;
    }

    private static SecureRandom getDefaultSecureRandom() {
        try {
            return SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e2) {
            return new SecureRandom();
        }
    }

    private static int getInitializationVectorSize() {
        return initializationVectorSize;
    }

    static {
        initializationVectorSize = 128;
    }
}

