/*
 * Decompiled with CFR 0.152.
 */
package com.summersec.attack.deser.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;

public class SuidClassLoader
extends ClassLoader {
    private Map<String, byte[]> classByteMap = new HashMap<String, byte[]>();
    private Map<String, Class> cacheClass = new HashMap<String, Class>();

    public void addClass(String className, byte[] classByte) {
        this.classByteMap.put(className, classByte);
    }

    public void addJar(byte[] jarByte) throws Exception {
        File tempFile = null;
        JarFile jarFile = null;
        tempFile = File.createTempFile("tempJarFile", "jar");
        FileUtils.writeByteArrayToFile(tempFile, jarByte);
        jarFile = new JarFile(tempFile);
        this.readJar(jarFile);
    }

    private void readJar(JarFile jar) throws IOException, IOException {
        Enumeration<JarEntry> en = jar.entries();
        while (en.hasMoreElements()) {
            String clss;
            JarEntry je = en.nextElement();
            String name2 = je.getName();
            if (!name2.endsWith(".class") || this.findLoadedClass(clss = name2.replace(".class", "").replaceAll("/", ".")) != null) continue;
            InputStream input = jar.getInputStream(je);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int bufferSize = 4096;
            byte[] buffer = new byte[bufferSize];
            int bytesNumRead = 0;
            while ((bytesNumRead = input.read(buffer)) != -1) {
                baos.write(buffer, 0, bytesNumRead);
            }
            byte[] cc = baos.toByteArray();
            input.close();
            this.classByteMap.put(clss, cc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name2, boolean resolve2) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name2);
        synchronized (object) {
            Class<?> clazz = this.cacheClass.get(name2);
            if (clazz != null) {
                return clazz;
            }
            try {
                clazz = this.findClass(name2);
                if (null != clazz) {
                    this.cacheClass.put(name2, clazz);
                } else {
                    clazz = super.loadClass(name2, resolve2);
                }
            }
            catch (ClassNotFoundException e2) {
                clazz = super.loadClass(name2, resolve2);
            }
            if (resolve2) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
    }

    @Override
    protected Class<?> findClass(String name2) throws ClassNotFoundException {
        byte[] result = this.classByteMap.get(name2);
        if (result == null) {
            throw new ClassNotFoundException();
        }
        return super.defineClass(name2, result, 0, result.length);
    }

    public void cleanLoader() {
        if (this.classByteMap != null) {
            this.classByteMap.clear();
        }
        if (this.cacheClass != null) {
            this.cacheClass.clear();
        }
    }
}

