/*
 * Decompiled with CFR 0.152.
 */
package io.undertow;

import io.undertow.UndertowMessages;
import io.undertow.attribute.ExchangeAttribute;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateParser;
import io.undertow.predicate.PredicatesHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.JvmRouteHandler;
import io.undertow.server.RoutingHandler;
import io.undertow.server.handlers.AccessControlListHandler;
import io.undertow.server.handlers.DateHandler;
import io.undertow.server.handlers.DisableCacheHandler;
import io.undertow.server.handlers.ExceptionHandler;
import io.undertow.server.handlers.GracefulShutdownHandler;
import io.undertow.server.handlers.HttpContinueAcceptingHandler;
import io.undertow.server.handlers.HttpContinueReadHandler;
import io.undertow.server.handlers.HttpTraceHandler;
import io.undertow.server.handlers.IPAddressAccessControlHandler;
import io.undertow.server.handlers.LearningPushHandler;
import io.undertow.server.handlers.NameVirtualHostHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.PathTemplateHandler;
import io.undertow.server.handlers.PredicateContextHandler;
import io.undertow.server.handlers.PredicateHandler;
import io.undertow.server.handlers.ProxyPeerAddressHandler;
import io.undertow.server.handlers.RedirectHandler;
import io.undertow.server.handlers.RequestDumpingHandler;
import io.undertow.server.handlers.RequestLimit;
import io.undertow.server.handlers.RequestLimitingHandler;
import io.undertow.server.handlers.ResponseRateLimitingHandler;
import io.undertow.server.handlers.SetAttributeHandler;
import io.undertow.server.handlers.SetHeaderHandler;
import io.undertow.server.handlers.URLDecodingHandler;
import io.undertow.server.handlers.builder.PredicatedHandler;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyHandler;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.handlers.sse.ServerSentEventConnectionCallback;
import io.undertow.server.handlers.sse.ServerSentEventHandler;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.WebSocketProtocolHandshakeHandler;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Handlers {
    public static PathHandler path(HttpHandler defaultHandler) {
        return new PathHandler(defaultHandler);
    }

    public static PathHandler path() {
        return new PathHandler();
    }

    public static PathTemplateHandler pathTemplate() {
        return new PathTemplateHandler();
    }

    public static RoutingHandler routing(boolean rewriteQueryParams) {
        return new RoutingHandler(rewriteQueryParams);
    }

    public static RoutingHandler routing() {
        return new RoutingHandler();
    }

    public static PathTemplateHandler pathTemplate(boolean rewriteQueryParams) {
        return new PathTemplateHandler(rewriteQueryParams);
    }

    public static NameVirtualHostHandler virtualHost() {
        return new NameVirtualHostHandler();
    }

    public static NameVirtualHostHandler virtualHost(HttpHandler defaultHandler) {
        return new NameVirtualHostHandler().setDefaultHandler(defaultHandler);
    }

    public static NameVirtualHostHandler virtualHost(HttpHandler hostHandler, String ... hostnames) {
        NameVirtualHostHandler handler = new NameVirtualHostHandler();
        for (String host : hostnames) {
            handler.addHost(host, hostHandler);
        }
        return handler;
    }

    public static NameVirtualHostHandler virtualHost(HttpHandler defaultHandler, HttpHandler hostHandler, String ... hostnames) {
        return Handlers.virtualHost(hostHandler, hostnames).setDefaultHandler(defaultHandler);
    }

    public static WebSocketProtocolHandshakeHandler websocket(WebSocketConnectionCallback sessionHandler) {
        return new WebSocketProtocolHandshakeHandler(sessionHandler);
    }

    public static WebSocketProtocolHandshakeHandler websocket(WebSocketConnectionCallback sessionHandler, HttpHandler next2) {
        return new WebSocketProtocolHandshakeHandler(sessionHandler, next2);
    }

    public static ServerSentEventHandler serverSentEvents(ServerSentEventConnectionCallback callback) {
        return new ServerSentEventHandler(callback);
    }

    public static ServerSentEventHandler serverSentEvents() {
        return new ServerSentEventHandler();
    }

    public static ResourceHandler resource(ResourceManager resourceManager) {
        return new ResourceHandler(resourceManager).setDirectoryListingEnabled(false);
    }

    public static RedirectHandler redirect(String location) {
        return new RedirectHandler(location);
    }

    public static HttpTraceHandler trace(HttpHandler next2) {
        return new HttpTraceHandler(next2);
    }

    @Deprecated
    public static DateHandler date(HttpHandler next2) {
        return new DateHandler(next2);
    }

    public static PredicateHandler predicate(Predicate predicate, HttpHandler trueHandler, HttpHandler falseHandler) {
        return new PredicateHandler(predicate, trueHandler, falseHandler);
    }

    public static HttpHandler predicateContext(HttpHandler next2) {
        return new PredicateContextHandler(next2);
    }

    public static PredicatesHandler predicates(List<PredicatedHandler> handlers, HttpHandler next2) {
        PredicatesHandler predicatesHandler = new PredicatesHandler(next2);
        for (PredicatedHandler handler : handlers) {
            predicatesHandler.addPredicatedHandler(handler);
        }
        return predicatesHandler;
    }

    public static SetHeaderHandler header(HttpHandler next2, String headerName, String headerValue) {
        return new SetHeaderHandler(next2, headerName, headerValue);
    }

    public static SetHeaderHandler header(HttpHandler next2, String headerName, ExchangeAttribute headerValue) {
        return new SetHeaderHandler(next2, headerName, headerValue);
    }

    public static final IPAddressAccessControlHandler ipAccessControl(HttpHandler next2, boolean defaultAllow) {
        return new IPAddressAccessControlHandler(next2).setDefaultAllow(defaultAllow);
    }

    public static final AccessControlListHandler acl(HttpHandler next2, boolean defaultAllow, ExchangeAttribute attribute) {
        return new AccessControlListHandler(next2, attribute).setDefaultAllow(defaultAllow);
    }

    public static final HttpContinueReadHandler httpContinueRead(HttpHandler next2) {
        return new HttpContinueReadHandler(next2);
    }

    public static final HttpContinueAcceptingHandler httpContinueAccepting(HttpHandler next2, Predicate accept) {
        return new HttpContinueAcceptingHandler(next2, accept);
    }

    public static final HttpContinueAcceptingHandler httpContinueAccepting(HttpHandler next2) {
        return new HttpContinueAcceptingHandler(next2);
    }

    public static final URLDecodingHandler urlDecoding(HttpHandler next2, String charset) {
        return new URLDecodingHandler(next2, charset);
    }

    public static SetAttributeHandler setAttribute(HttpHandler next2, String attribute, String value, ClassLoader classLoader) {
        return new SetAttributeHandler(next2, attribute, value, classLoader);
    }

    public static HttpHandler rewrite(String condition, String target, ClassLoader classLoader, HttpHandler next2) {
        return Handlers.predicateContext(Handlers.predicate(PredicateParser.parse(condition, classLoader), Handlers.setAttribute(next2, "%R", target, classLoader), next2));
    }

    public static HttpHandler urlDecodingHandler(String charset, HttpHandler next2) {
        return new URLDecodingHandler(next2, charset);
    }

    public static GracefulShutdownHandler gracefulShutdown(HttpHandler next2) {
        return new GracefulShutdownHandler(next2);
    }

    public static ProxyPeerAddressHandler proxyPeerAddress(HttpHandler next2) {
        return new ProxyPeerAddressHandler(next2);
    }

    public static JvmRouteHandler jvmRoute(String sessionCookieName, String jvmRoute, HttpHandler next2) {
        return new JvmRouteHandler(next2, sessionCookieName, jvmRoute);
    }

    public static RequestLimitingHandler requestLimitingHandler(int maxRequest, int queueSize, HttpHandler next2) {
        return new RequestLimitingHandler(maxRequest, queueSize, next2);
    }

    public static RequestLimitingHandler requestLimitingHandler(RequestLimit requestLimit, HttpHandler next2) {
        return new RequestLimitingHandler(requestLimit, next2);
    }

    public static ProxyHandler proxyHandler(ProxyClient proxyClient, int maxRequestTime, HttpHandler next2) {
        return ProxyHandler.builder().setProxyClient(proxyClient).setNext(next2).setMaxRequestTime(maxRequestTime).build();
    }

    public static ProxyHandler proxyHandler(ProxyClient proxyClient, HttpHandler next2) {
        return ProxyHandler.builder().setProxyClient(proxyClient).setNext(next2).build();
    }

    public static ProxyHandler proxyHandler(ProxyClient proxyClient) {
        return ProxyHandler.builder().setProxyClient(proxyClient).build();
    }

    public static HttpHandler disableCache(HttpHandler next2) {
        return new DisableCacheHandler(next2);
    }

    public static HttpHandler requestDump(HttpHandler next2) {
        return new RequestDumpingHandler(next2);
    }

    public static ExceptionHandler exceptionHandler(HttpHandler next2) {
        return new ExceptionHandler(next2);
    }

    public static ResponseRateLimitingHandler responseRateLimitingHandler(HttpHandler next2, int bytes2, long time2, TimeUnit timeUnit) {
        return new ResponseRateLimitingHandler(next2, bytes2, time2, timeUnit);
    }

    public static LearningPushHandler learningPushHandler(int maxEntries, int maxAge, HttpHandler next2) {
        return new LearningPushHandler(maxEntries, maxAge, next2);
    }

    public static LearningPushHandler learningPushHandler(int maxEntries, HttpHandler next2) {
        return new LearningPushHandler(maxEntries, -1, next2);
    }

    private Handlers() {
    }

    public static void handlerNotNull(HttpHandler handler) {
        if (handler == null) {
            throw UndertowMessages.MESSAGES.handlerCannotBeNull();
        }
    }
}

