/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;

public class CompositeExchangeAttribute
implements ExchangeAttribute {
    private final ExchangeAttribute[] attributes;

    public CompositeExchangeAttribute(ExchangeAttribute[] attributes) {
        ExchangeAttribute[] copy2 = new ExchangeAttribute[attributes.length];
        System.arraycopy(attributes, 0, copy2, 0, attributes.length);
        this.attributes = copy2;
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.attributes.length; ++i) {
            String val2 = this.attributes[i].readAttribute(exchange);
            if (val2 == null) continue;
            sb.append(val2);
        }
        return sb.toString();
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("combined", newValue);
    }
}

