/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.predicate.Predicate;
import io.undertow.server.HttpServerExchange;
import java.util.Map;

public class PredicateContextAttribute
implements ExchangeAttribute {
    private final String name;

    public PredicateContextAttribute(String name2) {
        this.name = name2;
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        Map<String, Object> context = exchange.getAttachment(Predicate.PREDICATE_CONTEXT);
        if (context != null) {
            Object object = context.get(this.name);
            return object == null ? null : object.toString();
        }
        return null;
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        Map<String, Object> context = exchange.getAttachment(Predicate.PREDICATE_CONTEXT);
        if (context != null) {
            context.put(this.name, newValue);
        }
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Predicate context variable";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.startsWith("${") && token.endsWith("}") && token.length() > 3) {
                return new PredicateContextAttribute(token.substring(2, token.length() - 1));
            }
            if (token.startsWith("$")) {
                return new PredicateContextAttribute(token.substring(1, token.length()));
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

