/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.predicate;

import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateBuilder;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.PathMatcher;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class PathPrefixPredicate
implements Predicate {
    private final PathMatcher<Boolean> pathMatcher;

    PathPrefixPredicate(String ... paths) {
        PathMatcher<Boolean> matcher = new PathMatcher<Boolean>();
        for (String path2 : paths) {
            if (!path2.startsWith("/")) {
                matcher.addPrefixPath("/" + path2, Boolean.TRUE);
                continue;
            }
            matcher.addPrefixPath(path2, Boolean.TRUE);
        }
        this.pathMatcher = matcher;
    }

    @Override
    public boolean resolve(HttpServerExchange value) {
        String relativePath = value.getRelativePath();
        PathMatcher.PathMatch<Boolean> result = this.pathMatcher.match(relativePath);
        boolean matches = Boolean.TRUE.equals(result.getValue());
        if (matches) {
            TreeMap<String, String> context = (TreeMap<String, String>)value.getAttachment(PREDICATE_CONTEXT);
            if (context == null) {
                context = new TreeMap<String, String>();
                value.putAttachment(PREDICATE_CONTEXT, context);
            }
            context.put("remaining", result.getRemaining());
        }
        return matches;
    }

    public static class Builder
    implements PredicateBuilder {
        @Override
        public String name() {
            return "path-prefix";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.singletonMap("path", String[].class);
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("path");
        }

        @Override
        public String defaultParameter() {
            return "path";
        }

        @Override
        public Predicate build(Map<String, Object> config) {
            String[] path2 = (String[])config.get("path");
            return new PathPrefixPredicate(path2);
        }
    }
}

