/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.alpn;

import io.undertow.UndertowLogger;
import io.undertow.protocols.alpn.ALPNProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public class JDK9AlpnProvider
implements ALPNProvider {
    public static final JDK9ALPNMethods JDK_9_ALPN_METHODS;
    private static final String JDK8_SUPPORT_PROPERTY = "io.undertow.protocols.alpn.jdk8";

    @Override
    public boolean isEnabled(SSLEngine sslEngine) {
        return JDK_9_ALPN_METHODS != null;
    }

    @Override
    public SSLEngine setProtocols(SSLEngine engine, String[] protocols2) {
        SSLParameters sslParameters = engine.getSSLParameters();
        try {
            JDK_9_ALPN_METHODS.setApplicationProtocols().invoke((Object)sslParameters, new Object[]{protocols2});
        }
        catch (IllegalAccessException | InvocationTargetException e2) {
            throw new RuntimeException(e2);
        }
        engine.setSSLParameters(sslParameters);
        return engine;
    }

    @Override
    public String getSelectedProtocol(SSLEngine engine) {
        try {
            return (String)JDK_9_ALPN_METHODS.getApplicationProtocol().invoke((Object)engine, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public int getPriority() {
        return 300;
    }

    public String toString() {
        return "JDK9AlpnProvider";
    }

    static {
        final boolean addSupportIfExists = Boolean.getBoolean(JDK8_SUPPORT_PROPERTY);
        JDK_9_ALPN_METHODS = AccessController.doPrivileged(new PrivilegedAction<JDK9ALPNMethods>(){

            @Override
            public JDK9ALPNMethods run() {
                try {
                    String javaVersion = System.getProperty("java.specification.version");
                    int vmVersion = 8;
                    try {
                        Matcher matcher = Pattern.compile("^(?:1\\.)?(\\d+)$").matcher(javaVersion);
                        if (matcher.find()) {
                            vmVersion = Integer.parseInt(matcher.group(1));
                        }
                    }
                    catch (Exception matcher) {
                        // empty catch block
                    }
                    if (vmVersion > 8 || addSupportIfExists) {
                        Method setApplicationProtocols = SSLParameters.class.getMethod("setApplicationProtocols", String[].class);
                        Method getApplicationProtocol = SSLEngine.class.getMethod("getApplicationProtocol", new Class[0]);
                        UndertowLogger.ROOT_LOGGER.debug("Using JDK9 ALPN");
                        return new JDK9ALPNMethods(setApplicationProtocols, getApplicationProtocol);
                    }
                    UndertowLogger.ROOT_LOGGER.debugf("It's not certain ALPN support was found. Provider %s will be disabled.", (Object)JDK9AlpnProvider.class.getName());
                    return null;
                }
                catch (Exception e2) {
                    UndertowLogger.ROOT_LOGGER.debug("JDK9 ALPN not supported");
                    return null;
                }
            }
        });
    }

    public static class JDK9ALPNMethods {
        private final Method setApplicationProtocols;
        private final Method getApplicationProtocol;

        JDK9ALPNMethods(Method setApplicationProtocols, Method getApplicationProtocol) {
            this.setApplicationProtocols = setApplicationProtocols;
            this.getApplicationProtocol = getApplicationProtocol;
        }

        public Method getApplicationProtocol() {
            return this.getApplicationProtocol;
        }

        public Method setApplicationProtocols() {
            return this.setApplicationProtocols;
        }
    }
}

