/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.protocols.http2.HPackHuffman;
import io.undertow.protocols.http2.Hpack;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HpackEncoder {
    private static final Set<HttpString> SKIP;
    public static final HpackHeaderFunction DEFAULT_HEADER_FUNCTION;
    private long headersIterator = -1L;
    private boolean firstPass = true;
    private HeaderMap currentHeaders;
    private int entryPositionCounter;
    private int newMaxHeaderSize = -1;
    private int minNewMaxHeaderSize = -1;
    private static final Map<HttpString, TableEntry[]> ENCODING_STATIC_TABLE;
    private final Deque<TableEntry> evictionQueue = new ArrayDeque<TableEntry>();
    private final Map<HttpString, List<TableEntry>> dynamicTable = new HashMap<HttpString, List<TableEntry>>();
    private byte[] overflowData;
    private int overflowPos;
    private int overflowLength;
    private int maxTableSize;
    private int currentTableSize;
    private final HpackHeaderFunction hpackHeaderFunction;

    public HpackEncoder(int maxTableSize, HpackHeaderFunction headerFunction) {
        this.maxTableSize = maxTableSize;
        this.hpackHeaderFunction = headerFunction;
    }

    public HpackEncoder(int maxTableSize) {
        this(maxTableSize, DEFAULT_HEADER_FUNCTION);
    }

    public State encode(HeaderMap headers, ByteBuffer target) {
        if (this.overflowData != null) {
            for (int i = this.overflowPos; i < this.overflowLength; ++i) {
                if (!target.hasRemaining()) {
                    this.overflowPos = i;
                    return State.OVERFLOW;
                }
                target.put(this.overflowData[i]);
            }
            this.overflowData = null;
        }
        long it = this.headersIterator;
        if (this.headersIterator == -1L) {
            this.handleTableSizeChange(target);
            it = headers.fastIterate();
            this.currentHeaders = headers;
        } else if (headers != this.currentHeaders) {
            throw new IllegalStateException();
        }
        while (it != -1L) {
            HeaderValues values = headers.fiCurrent(it);
            boolean skip = false;
            if (this.firstPass) {
                if (values.getHeaderName().byteAt(0) != 58) {
                    skip = true;
                }
            } else if (values.getHeaderName().byteAt(0) == 58) {
                skip = true;
            }
            if (SKIP.contains(values.getHeaderName())) {
                skip = true;
            }
            if (!skip) {
                for (int i = 0; i < values.size(); ++i) {
                    boolean canIndex;
                    HttpString headerName = values.getHeaderName();
                    int required2 = 11 + headerName.length();
                    String val2 = values.get(i);
                    for (int v = 0; v < val2.length(); ++v) {
                        char c = val2.charAt(v);
                        if (c != '\r' && c != '\n') continue;
                        val2 = val2.replace('\r', ' ').replace('\n', ' ');
                        break;
                    }
                    TableEntry tableEntry = this.findInTable(headerName, val2);
                    boolean overflowing = false;
                    ByteBuffer current = target;
                    if (current.remaining() < (required2 += 1 + val2.length())) {
                        overflowing = true;
                        this.overflowData = new byte[required2];
                        current = ByteBuffer.wrap(this.overflowData);
                        this.overflowPos = 0;
                    }
                    boolean bl = canIndex = this.hpackHeaderFunction.shouldUseIndexing(headerName, val2) && headerName.length() + val2.length() + 32 < this.maxTableSize;
                    if (tableEntry == null && canIndex) {
                        current.put((byte)64);
                        this.writeHuffmanEncodableName(current, headerName);
                        this.writeHuffmanEncodableValue(current, headerName, val2);
                        this.addToDynamicTable(headerName, val2);
                    } else if (tableEntry == null) {
                        current.put((byte)16);
                        this.writeHuffmanEncodableName(current, headerName);
                        this.writeHuffmanEncodableValue(current, headerName, val2);
                    } else if (val2.equals(tableEntry.value)) {
                        current.put((byte)-128);
                        Hpack.encodeInteger(current, tableEntry.getPosition(), 7);
                    } else if (canIndex) {
                        current.put((byte)64);
                        Hpack.encodeInteger(current, tableEntry.getPosition(), 6);
                        this.writeHuffmanEncodableValue(current, headerName, val2);
                        this.addToDynamicTable(headerName, val2);
                    } else {
                        current.put((byte)16);
                        Hpack.encodeInteger(current, tableEntry.getPosition(), 4);
                        this.writeHuffmanEncodableValue(current, headerName, val2);
                    }
                    if (!overflowing) continue;
                    this.headersIterator = it = headers.fiNext(it);
                    this.overflowLength = current.position();
                    return State.OVERFLOW;
                }
            }
            if ((it = headers.fiNext(it)) != -1L || !this.firstPass) continue;
            this.firstPass = false;
            it = headers.fastIterate();
        }
        this.headersIterator = -1L;
        this.firstPass = true;
        return State.COMPLETE;
    }

    private void writeHuffmanEncodableName(ByteBuffer target, HttpString headerName) {
        if (this.hpackHeaderFunction.shouldUseHuffman(headerName) && HPackHuffman.encode(target, headerName.toString(), true)) {
            return;
        }
        target.put((byte)0);
        Hpack.encodeInteger(target, headerName.length(), 7);
        for (int j = 0; j < headerName.length(); ++j) {
            target.put(Hpack.toLower(headerName.byteAt(j)));
        }
    }

    private void writeHuffmanEncodableValue(ByteBuffer target, HttpString headerName, String val2) {
        if (this.hpackHeaderFunction.shouldUseHuffman(headerName, val2)) {
            if (!HPackHuffman.encode(target, val2, false)) {
                this.writeValueString(target, val2);
            }
        } else {
            this.writeValueString(target, val2);
        }
    }

    private void writeValueString(ByteBuffer target, String val2) {
        target.put((byte)0);
        Hpack.encodeInteger(target, val2.length(), 7);
        for (int j = 0; j < val2.length(); ++j) {
            target.put((byte)val2.charAt(j));
        }
    }

    private void addToDynamicTable(HttpString headerName, String val2) {
        int pos = this.entryPositionCounter++;
        DynamicTableEntry d = new DynamicTableEntry(headerName, val2, -pos);
        List<TableEntry> existing = this.dynamicTable.get(headerName);
        if (existing == null) {
            existing = new ArrayList<TableEntry>(1);
            this.dynamicTable.put(headerName, existing);
        }
        existing.add(d);
        this.evictionQueue.add(d);
        this.currentTableSize += d.size;
        this.runEvictionIfRequired();
        if (this.entryPositionCounter == Integer.MAX_VALUE) {
            this.preventPositionRollover();
        }
    }

    private void preventPositionRollover() {
        for (Map.Entry<HttpString, List<TableEntry>> entry : this.dynamicTable.entrySet()) {
            for (TableEntry t : entry.getValue()) {
                t.position = t.getPosition();
            }
        }
        this.entryPositionCounter = 0;
    }

    private void runEvictionIfRequired() {
        while (this.currentTableSize > this.maxTableSize) {
            TableEntry next2 = this.evictionQueue.poll();
            if (next2 == null) {
                return;
            }
            this.currentTableSize -= next2.size;
            List<TableEntry> list = this.dynamicTable.get(next2.name);
            list.remove(next2);
            if (!list.isEmpty()) continue;
            this.dynamicTable.remove(next2.name);
        }
    }

    private TableEntry findInTable(HttpString headerName, String value) {
        List<TableEntry> dynamic;
        TableEntry[] staticTable = ENCODING_STATIC_TABLE.get(headerName);
        if (staticTable != null) {
            for (TableEntry st : staticTable) {
                if (st.value == null || !st.value.equals(value)) continue;
                return st;
            }
        }
        if ((dynamic = this.dynamicTable.get(headerName)) != null) {
            for (int i = 0; i < dynamic.size(); ++i) {
                TableEntry st = dynamic.get(i);
                if (!st.value.equals(value)) continue;
                return st;
            }
        }
        if (staticTable != null) {
            return staticTable[0];
        }
        return null;
    }

    public void setMaxTableSize(int newSize) {
        this.newMaxHeaderSize = newSize;
        this.minNewMaxHeaderSize = this.minNewMaxHeaderSize == -1 ? newSize : Math.min(newSize, this.minNewMaxHeaderSize);
    }

    private void handleTableSizeChange(ByteBuffer target) {
        if (this.newMaxHeaderSize == -1) {
            return;
        }
        if (this.minNewMaxHeaderSize != this.newMaxHeaderSize) {
            target.put((byte)32);
            Hpack.encodeInteger(target, this.minNewMaxHeaderSize, 5);
        }
        target.put((byte)32);
        Hpack.encodeInteger(target, this.newMaxHeaderSize, 5);
        this.maxTableSize = this.newMaxHeaderSize;
        this.runEvictionIfRequired();
        this.newMaxHeaderSize = -1;
        this.minNewMaxHeaderSize = -1;
    }

    static {
        HashSet<HttpString> set2 = new HashSet<HttpString>();
        set2.add(Headers.CONNECTION);
        set2.add(Headers.TRANSFER_ENCODING);
        set2.add(Headers.KEEP_ALIVE);
        set2.add(Headers.UPGRADE);
        SKIP = Collections.unmodifiableSet(set2);
        DEFAULT_HEADER_FUNCTION = new HpackHeaderFunction(){

            @Override
            public boolean shouldUseIndexing(HttpString headerName, String value) {
                return !headerName.equals(Headers.CONTENT_LENGTH) && !headerName.equals(Headers.DATE);
            }

            @Override
            public boolean shouldUseHuffman(HttpString header, String value) {
                return value.length() > 10;
            }

            @Override
            public boolean shouldUseHuffman(HttpString header) {
                return header.length() > 10;
            }
        };
        HashMap<HttpString, TableEntry[]> map2 = new HashMap<HttpString, TableEntry[]>();
        for (int i = 1; i < Hpack.STATIC_TABLE.length; ++i) {
            Hpack.HeaderField m = Hpack.STATIC_TABLE[i];
            TableEntry[] existing = (TableEntry[])map2.get(m.name);
            if (existing == null) {
                map2.put(m.name, new TableEntry[]{new TableEntry(m.name, m.value, i)});
                continue;
            }
            TableEntry[] newEntry = new TableEntry[existing.length + 1];
            System.arraycopy(existing, 0, newEntry, 0, existing.length);
            newEntry[existing.length] = new TableEntry(m.name, m.value, i);
            map2.put(m.name, newEntry);
        }
        ENCODING_STATIC_TABLE = Collections.unmodifiableMap(map2);
    }

    public static interface HpackHeaderFunction {
        public boolean shouldUseIndexing(HttpString var1, String var2);

        public boolean shouldUseHuffman(HttpString var1, String var2);

        public boolean shouldUseHuffman(HttpString var1);
    }

    class DynamicTableEntry
    extends TableEntry {
        DynamicTableEntry(HttpString name2, String value, int position) {
            super(name2, value, position);
        }

        @Override
        public int getPosition() {
            return super.getPosition() + HpackEncoder.this.entryPositionCounter + Hpack.STATIC_TABLE_LENGTH;
        }
    }

    static class TableEntry {
        final HttpString name;
        final String value;
        final int size;
        int position;

        TableEntry(HttpString name2, String value, int position) {
            this.name = name2;
            this.value = value;
            this.position = position;
            this.size = value != null ? 32 + name2.length() + value.length() : -1;
        }

        public int getPosition() {
            return this.position;
        }
    }

    public static enum State {
        COMPLETE,
        OVERFLOW;

    }
}

