/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.protocols.http2.Http2FrameHeaderParser;
import io.undertow.protocols.http2.Http2ProtocolUtils;
import io.undertow.protocols.http2.Http2PushBackParser;
import java.nio.ByteBuffer;
import org.xnio.Bits;

class Http2PriorityParser
extends Http2PushBackParser {
    private int streamDependency;
    private int weight;
    private boolean exclusive;

    Http2PriorityParser(int frameLength) {
        super(frameLength);
    }

    @Override
    protected void handleData(ByteBuffer resource2, Http2FrameHeaderParser frameHeaderParser) {
        if (resource2.remaining() < 5) {
            return;
        }
        int read2 = Http2ProtocolUtils.readInt(resource2);
        if (Bits.anyAreSet(read2, Integer.MIN_VALUE)) {
            this.exclusive = true;
            this.streamDependency = read2 & Integer.MAX_VALUE;
        } else {
            this.exclusive = false;
            this.streamDependency = read2;
        }
        this.weight = resource2.get();
    }

    public int getWeight() {
        return this.weight;
    }

    public int getStreamDependency() {
        return this.streamDependency;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }
}

