/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.UndertowMessages;
import io.undertow.protocols.http2.Http2FrameHeaderParser;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class Http2PushBackParser {
    private byte[] pushedBackData;
    private boolean finished;
    private int remainingData;
    private final int frameLength;
    int cnt;

    public Http2PushBackParser(int frameLength) {
        this.remainingData = frameLength;
        this.frameLength = frameLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(ByteBuffer data2, Http2FrameHeaderParser headerParser) throws IOException {
        int used = 0;
        ByteBuffer dataToParse = data2;
        int oldLimit = data2.limit();
        try {
            if (this.pushedBackData != null) {
                int toCopy = Math.min(this.remainingData - this.pushedBackData.length, data2.remaining());
                dataToParse = ByteBuffer.wrap(new byte[this.pushedBackData.length + toCopy]);
                dataToParse.put(this.pushedBackData);
                data2.limit(data2.position() + toCopy);
                dataToParse.put(data2);
                dataToParse.flip();
            }
            if (dataToParse.remaining() > this.remainingData) {
                dataToParse.limit(dataToParse.position() + this.remainingData);
            }
            int rem2 = dataToParse.remaining();
            this.handleData(dataToParse, headerParser);
            used = rem2 - dataToParse.remaining();
            if (!this.isFinished() && this.remainingData > 0 && used == 0 && dataToParse.remaining() >= this.remainingData && this.cnt++ == 100) {
                throw UndertowMessages.MESSAGES.parserDidNotMakeProgress();
            }
        }
        finally {
            if (this.finished) {
                data2.limit(oldLimit);
                return;
            }
            int leftOver = dataToParse.remaining();
            if (leftOver > 0) {
                this.pushedBackData = new byte[leftOver];
                dataToParse.get(this.pushedBackData);
            } else {
                this.pushedBackData = null;
            }
            data2.limit(oldLimit);
            this.remainingData -= used;
            if (this.remainingData == 0) {
                this.finished = true;
            }
        }
    }

    protected abstract void handleData(ByteBuffer var1, Http2FrameHeaderParser var2) throws IOException;

    public boolean isFinished() {
        if (this.pushedBackData != null && this.remainingData == this.pushedBackData.length) {
            return true;
        }
        return this.finished;
    }

    protected void finish() {
        this.finished = true;
    }

    protected void moreData(int data2) {
        this.finished = false;
        this.remainingData += data2;
    }

    public int getFrameLength() {
        return this.frameLength;
    }
}

