/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.protocols.http2.Http2Channel;
import io.undertow.protocols.http2.Http2DataStreamSinkChannel;
import io.undertow.util.HeaderMap;
import java.nio.ByteBuffer;

public class Http2PushPromiseStreamSinkChannel
extends Http2DataStreamSinkChannel {
    private final int pushedStreamId;

    Http2PushPromiseStreamSinkChannel(Http2Channel channel, HeaderMap requestHeaders, int associatedStreamId, int pushedStreamId) {
        super(channel, associatedStreamId, requestHeaders, 5);
        this.pushedStreamId = pushedStreamId;
    }

    @Override
    protected void writeBeforeHeaderBlock(ByteBuffer buffer) {
        buffer.put((byte)(this.pushedStreamId >> 24 & 0xFF));
        buffer.put((byte)(this.pushedStreamId >> 16 & 0xFF));
        buffer.put((byte)(this.pushedStreamId >> 8 & 0xFF));
        buffer.put((byte)(this.pushedStreamId & 0xFF));
    }

    @Override
    protected int grabFlowControlBytes(int bytes2) {
        return bytes2;
    }
}

