/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.protocols.http2.Http2FrameHeaderParser;
import io.undertow.protocols.http2.Http2PushBackParser;
import io.undertow.protocols.http2.Http2Setting;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

class Http2SettingsParser
extends Http2PushBackParser {
    private int count = 0;
    private final List<Http2Setting> settings = new ArrayList<Http2Setting>();

    Http2SettingsParser(int frameLength) {
        super(frameLength);
    }

    @Override
    protected void handleData(ByteBuffer resource2, Http2FrameHeaderParser parser) {
        while (this.count < parser.length) {
            if (resource2.remaining() < 6) {
                return;
            }
            int id = (resource2.get() & 0xFF) << 8;
            long value = ((long)resource2.get() & 0xFFL) << 24;
            value += ((long)resource2.get() & 0xFFL) << 16;
            value += ((long)resource2.get() & 0xFFL) << 8;
            this.settings.add(new Http2Setting(id += resource2.get() & 0xFF, value += (long)resource2.get() & 0xFFL));
            this.count += 6;
        }
    }

    public List<Http2Setting> getSettings() {
        return this.settings;
    }
}

