/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.ssl;

import io.undertow.protocols.ssl.ALPNHackSSLEngine;
import io.undertow.protocols.ssl.ALPNHackServerHelloExplorer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;

class ALPNHackServerByteArrayOutputStream
extends ByteArrayOutputStream {
    private final SSLEngine sslEngine;
    private byte[] serverHello;
    private final String alpnProtocol;
    private boolean ready = false;

    ALPNHackServerByteArrayOutputStream(SSLEngine sslEngine, byte[] bytes2, String alpnProtocol) {
        this.sslEngine = sslEngine;
        this.alpnProtocol = alpnProtocol;
        try {
            this.write(bytes2);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        this.ready = true;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (this.ready && b[off] == 2) {
            this.ready = false;
            this.serverHello = new byte[len];
            System.arraycopy(b, off, this.serverHello, 0, len);
            try {
                this.serverHello = ALPNHackServerHelloExplorer.addAlpnExtensionsToServerHello(this.serverHello, this.alpnProtocol);
            }
            catch (SSLException e2) {
                throw new RuntimeException(e2);
            }
            ALPNHackSSLEngine.regenerateHashes(this.sslEngine, this, this.toByteArray(), this.serverHello);
            return;
        }
        super.write(b, off, len);
    }

    byte[] getServerHello() {
        return this.serverHello;
    }
}

