/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.ssl;

import io.undertow.UndertowMessages;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;

public class SNIContextMatcher {
    private final SSLContext defaultContext;
    private final Map<SNIMatcher, SSLContext> wildcards;
    private final Map<SNIMatcher, SSLContext> exacts;

    SNIContextMatcher(SSLContext defaultContext, Map<SNIMatcher, SSLContext> wildcards, Map<SNIMatcher, SSLContext> exacts) {
        this.defaultContext = defaultContext;
        this.wildcards = wildcards;
        this.exacts = exacts;
    }

    public SSLContext getContext(List<SNIServerName> servers) {
        for (Map.Entry<SNIMatcher, SSLContext> entry : this.exacts.entrySet()) {
            for (SNIServerName server2 : servers) {
                if (!entry.getKey().matches(server2)) continue;
                return entry.getValue();
            }
        }
        for (Map.Entry<SNIMatcher, SSLContext> entry : this.wildcards.entrySet()) {
            for (SNIServerName server2 : servers) {
                if (!entry.getKey().matches(server2)) continue;
                return entry.getValue();
            }
        }
        return this.defaultContext;
    }

    public SSLContext getDefaultContext() {
        return this.defaultContext;
    }

    public static class Builder {
        private SSLContext defaultContext;
        private final Map<SNIMatcher, SSLContext> wildcards = new LinkedHashMap<SNIMatcher, SSLContext>();
        private final Map<SNIMatcher, SSLContext> exacts = new LinkedHashMap<SNIMatcher, SSLContext>();

        public SNIContextMatcher build() {
            if (this.defaultContext == null) {
                throw UndertowMessages.MESSAGES.defaultContextCannotBeNull();
            }
            return new SNIContextMatcher(this.defaultContext, this.wildcards, this.exacts);
        }

        public SSLContext getDefaultContext() {
            return this.defaultContext;
        }

        public Builder setDefaultContext(SSLContext defaultContext) {
            this.defaultContext = defaultContext;
            return this;
        }

        public Builder addMatch(String name2, SSLContext context) {
            if (name2.contains("*")) {
                this.wildcards.put(SNIHostName.createSNIMatcher(name2), context);
            } else {
                this.exacts.put(SNIHostName.createSNIMatcher(name2), context);
            }
            return this;
        }
    }
}

