/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.ssl;

import io.undertow.UndertowOptions;
import io.undertow.connector.ByteBufferPool;
import io.undertow.protocols.ssl.SslConduit;
import io.undertow.protocols.ssl.UndertowAcceptingSslChannel;
import io.undertow.protocols.ssl.UndertowSslConnection;
import io.undertow.server.DefaultByteBufferPool;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Sequence;
import org.xnio.SslClientAuthMode;
import org.xnio.StreamConnection;
import org.xnio.Xnio;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.AssembledConnectedSslStreamChannel;
import org.xnio.channels.BoundChannel;
import org.xnio.channels.ConnectedSslStreamChannel;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.ssl.JsseSslUtils;
import org.xnio.ssl.JsseXnioSsl;
import org.xnio.ssl.SslConnection;
import org.xnio.ssl.XnioSsl;

public class UndertowXnioSsl
extends XnioSsl {
    private static final ByteBufferPool DEFAULT_BUFFER_POOL = new DefaultByteBufferPool(true, 17408, -1, 12);
    private final ByteBufferPool bufferPool;
    private volatile SSLContext sslContext;

    public UndertowXnioSsl(Xnio xnio, OptionMap optionMap) throws NoSuchProviderException, NoSuchAlgorithmException, KeyManagementException {
        this(xnio, optionMap, DEFAULT_BUFFER_POOL, JsseSslUtils.createSSLContext(optionMap));
    }

    public UndertowXnioSsl(Xnio xnio, OptionMap optionMap, SSLContext sslContext) {
        this(xnio, optionMap, DEFAULT_BUFFER_POOL, sslContext);
    }

    public UndertowXnioSsl(Xnio xnio, OptionMap optionMap, ByteBufferPool bufferPool) throws NoSuchProviderException, NoSuchAlgorithmException, KeyManagementException {
        this(xnio, optionMap, bufferPool, JsseSslUtils.createSSLContext(optionMap));
    }

    public UndertowXnioSsl(Xnio xnio, OptionMap optionMap, ByteBufferPool bufferPool, SSLContext sslContext) {
        super(xnio, sslContext, optionMap);
        this.bufferPool = bufferPool;
        this.sslContext = sslContext;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public static SSLEngine getSslEngine(SslConnection connection) {
        if (connection instanceof UndertowSslConnection) {
            return ((UndertowSslConnection)connection).getSSLEngine();
        }
        return JsseXnioSsl.getSslEngine(connection);
    }

    public static SslConduit getSslConduit(SslConnection connection) {
        return ((UndertowSslConnection)connection).getSslConduit();
    }

    @Override
    public IoFuture<ConnectedSslStreamChannel> connectSsl(XnioWorker worker, InetSocketAddress bindAddress, InetSocketAddress destination, final ChannelListener<? super ConnectedSslStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        final FutureResult futureResult = new FutureResult(IoUtils.directExecutor());
        IoFuture<SslConnection> futureSslConnection = this.openSslConnection(worker, bindAddress, destination, (ChannelListener<? super SslConnection>)new ChannelListener<SslConnection>(){

            @Override
            public void handleEvent(SslConnection sslConnection) {
                AssembledConnectedSslStreamChannel assembledChannel = new AssembledConnectedSslStreamChannel(sslConnection, (StreamSourceChannel)sslConnection.getSourceChannel(), (StreamSinkChannel)sslConnection.getSinkChannel());
                if (!futureResult.setResult(assembledChannel)) {
                    IoUtils.safeClose((Closeable)assembledChannel);
                } else {
                    ChannelListeners.invokeChannelListener(assembledChannel, openListener);
                }
            }
        }, bindListener, optionMap).addNotifier(new IoFuture.HandlingNotifier<SslConnection, FutureResult<ConnectedSslStreamChannel>>(){

            @Override
            public void handleCancelled(FutureResult<ConnectedSslStreamChannel> result) {
                result.setCancelled();
            }

            @Override
            public void handleFailed(IOException exception, FutureResult<ConnectedSslStreamChannel> result) {
                result.setException(exception);
            }
        }, futureResult);
        futureResult.getIoFuture().addNotifier(new IoFuture.HandlingNotifier<ConnectedStreamChannel, IoFuture<SslConnection>>(){

            @Override
            public void handleCancelled(IoFuture<SslConnection> result) {
                result.cancel();
            }
        }, futureSslConnection);
        futureResult.addCancelHandler(futureSslConnection);
        return futureResult.getIoFuture();
    }

    @Override
    public IoFuture<SslConnection> openSslConnection(XnioWorker worker, InetSocketAddress bindAddress, InetSocketAddress destination, ChannelListener<? super SslConnection> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        FutureResult<SslConnection> futureResult = new FutureResult<SslConnection>(worker);
        IoFuture<StreamConnection> connection = worker.openStreamConnection(bindAddress, destination, new StreamConnectionChannelListener(optionMap, destination, futureResult, openListener), bindListener, optionMap);
        return this.setupSslConnection(futureResult, connection);
    }

    @Override
    public IoFuture<SslConnection> openSslConnection(XnioIoThread ioThread, InetSocketAddress bindAddress, InetSocketAddress destination, ChannelListener<? super SslConnection> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        FutureResult<SslConnection> futureResult = new FutureResult<SslConnection>(ioThread);
        IoFuture<StreamConnection> connection = ioThread.openStreamConnection(bindAddress, destination, new StreamConnectionChannelListener(optionMap, destination, futureResult, openListener), bindListener, optionMap);
        return this.setupSslConnection(futureResult, connection);
    }

    public SslConnection wrapExistingConnection(StreamConnection connection, OptionMap optionMap) {
        return new UndertowSslConnection(connection, UndertowXnioSsl.createSSLEngine(this.sslContext, optionMap, (InetSocketAddress)connection.getPeerAddress(), true), this.bufferPool);
    }

    public SslConnection wrapExistingConnection(StreamConnection connection, OptionMap optionMap, boolean clientMode) {
        return new UndertowSslConnection(connection, UndertowXnioSsl.createSSLEngine(this.sslContext, optionMap, (InetSocketAddress)connection.getPeerAddress(), clientMode), this.bufferPool);
    }

    public SslConnection wrapExistingConnection(StreamConnection connection, OptionMap optionMap, URI destinationURI) {
        SSLEngine sslEngine = UndertowXnioSsl.createSSLEngine(this.sslContext, optionMap, this.getPeerAddress(destinationURI), true);
        SSLParameters sslParameters = sslEngine.getSSLParameters();
        if (sslParameters.getServerNames() == null || sslParameters.getServerNames().isEmpty()) {
            sslParameters.setServerNames(Collections.singletonList(new SNIHostName(destinationURI.getHost())));
            sslEngine.setSSLParameters(sslParameters);
        }
        return new UndertowSslConnection(connection, sslEngine, this.bufferPool);
    }

    private InetSocketAddress getPeerAddress(URI destinationURI) {
        String hostname = destinationURI.getHost();
        int port = destinationURI.getPort();
        if (port == -1) {
            port = destinationURI.getScheme().equals("wss") ? 443 : 80;
        }
        return new InetSocketAddress(hostname, port);
    }

    private static SSLEngine createSSLEngine(SSLContext sslContext, OptionMap optionMap, InetSocketAddress peerAddress, boolean client) {
        String endpointIdentificationAlgorithm;
        boolean useCipherSuitesOrder;
        SslClientAuthMode clientAuthMode;
        Sequence<String> protocols2;
        SSLEngine engine = sslContext.createSSLEngine(optionMap.get(Options.SSL_PEER_HOST_NAME, peerAddress.getHostString()), optionMap.get(Options.SSL_PEER_PORT, peerAddress.getPort()));
        engine.setUseClientMode(client);
        engine.setEnableSessionCreation(optionMap.get(Options.SSL_ENABLE_SESSION_CREATION, true));
        Sequence<String> cipherSuites = optionMap.get(Options.SSL_ENABLED_CIPHER_SUITES);
        if (cipherSuites != null) {
            HashSet<String> supported = new HashSet<String>(Arrays.asList(engine.getSupportedCipherSuites()));
            ArrayList<String> finalList = new ArrayList<String>();
            for (String string2 : cipherSuites) {
                if (!supported.contains(string2)) continue;
                finalList.add(string2);
            }
            engine.setEnabledCipherSuites(finalList.toArray(new String[finalList.size()]));
        }
        if ((protocols2 = optionMap.get(Options.SSL_ENABLED_PROTOCOLS)) != null) {
            HashSet<String> supported = new HashSet<String>(Arrays.asList(engine.getSupportedProtocols()));
            ArrayList<String> finalList = new ArrayList<String>();
            for (String name3 : protocols2) {
                if (!supported.contains(name3)) continue;
                finalList.add(name3);
            }
            engine.setEnabledProtocols(finalList.toArray(new String[finalList.size()]));
        }
        if (!client && (clientAuthMode = optionMap.get(Options.SSL_CLIENT_AUTH_MODE)) != null) {
            switch (clientAuthMode) {
                case NOT_REQUESTED: {
                    engine.setNeedClientAuth(false);
                    engine.setWantClientAuth(false);
                    break;
                }
                case REQUESTED: {
                    engine.setWantClientAuth(true);
                    break;
                }
                case REQUIRED: {
                    engine.setNeedClientAuth(true);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        if (useCipherSuitesOrder = optionMap.get(UndertowOptions.SSL_USER_CIPHER_SUITES_ORDER, false)) {
            SSLParameters sslParameters = engine.getSSLParameters();
            sslParameters.setUseCipherSuitesOrder(true);
            engine.setSSLParameters(sslParameters);
        }
        if ((endpointIdentificationAlgorithm = (String)optionMap.get(UndertowOptions.ENDPOINT_IDENTIFICATION_ALGORITHM, null)) != null) {
            SSLParameters sSLParameters = engine.getSSLParameters();
            sSLParameters.setEndpointIdentificationAlgorithm(endpointIdentificationAlgorithm);
            engine.setSSLParameters(sSLParameters);
        }
        return engine;
    }

    private IoFuture<SslConnection> setupSslConnection(FutureResult<SslConnection> futureResult, IoFuture<StreamConnection> connection) {
        connection.addNotifier(new IoFuture.HandlingNotifier<StreamConnection, FutureResult<SslConnection>>(){

            @Override
            public void handleCancelled(FutureResult<SslConnection> attachment) {
                attachment.setCancelled();
            }

            @Override
            public void handleFailed(IOException exception, FutureResult<SslConnection> attachment) {
                attachment.setException(exception);
            }
        }, futureResult);
        futureResult.addCancelHandler(connection);
        return futureResult.getIoFuture();
    }

    @Override
    public AcceptingChannel<ConnectedSslStreamChannel> createSslTcpServer(XnioWorker worker, InetSocketAddress bindAddress, ChannelListener<? super AcceptingChannel<ConnectedSslStreamChannel>> acceptListener, OptionMap optionMap) throws IOException {
        final AcceptingChannel<SslConnection> server2 = this.createSslConnectionServer(worker, bindAddress, null, optionMap);
        AcceptingChannel<ConnectedSslStreamChannel> acceptingChannel = new AcceptingChannel<ConnectedSslStreamChannel>(){

            @Override
            public ConnectedSslStreamChannel accept() throws IOException {
                SslConnection connection = (SslConnection)server2.accept();
                return connection == null ? null : new AssembledConnectedSslStreamChannel(connection, (StreamSourceChannel)connection.getSourceChannel(), (StreamSinkChannel)connection.getSinkChannel());
            }

            @Override
            public ChannelListener.Setter<? extends AcceptingChannel<ConnectedSslStreamChannel>> getAcceptSetter() {
                return ChannelListeners.getDelegatingSetter(server2.getAcceptSetter(), this);
            }

            @Override
            public ChannelListener.Setter<? extends AcceptingChannel<ConnectedSslStreamChannel>> getCloseSetter() {
                return ChannelListeners.getDelegatingSetter(server2.getCloseSetter(), this);
            }

            @Override
            public SocketAddress getLocalAddress() {
                return server2.getLocalAddress();
            }

            @Override
            public <A extends SocketAddress> A getLocalAddress(Class<A> type2) {
                return server2.getLocalAddress(type2);
            }

            @Override
            public void suspendAccepts() {
                server2.suspendAccepts();
            }

            @Override
            public void resumeAccepts() {
                server2.resumeAccepts();
            }

            @Override
            public boolean isAcceptResumed() {
                return server2.isAcceptResumed();
            }

            @Override
            public void wakeupAccepts() {
                server2.wakeupAccepts();
            }

            @Override
            public void awaitAcceptable() throws IOException {
                server2.awaitAcceptable();
            }

            @Override
            public void awaitAcceptable(long time2, TimeUnit timeUnit) throws IOException {
                server2.awaitAcceptable(time2, timeUnit);
            }

            @Override
            public XnioWorker getWorker() {
                return server2.getWorker();
            }

            @Override
            @Deprecated
            public XnioExecutor getAcceptThread() {
                return server2.getAcceptThread();
            }

            @Override
            public XnioIoThread getIoThread() {
                return server2.getIoThread();
            }

            @Override
            public void close() throws IOException {
                server2.close();
            }

            @Override
            public boolean isOpen() {
                return server2.isOpen();
            }

            @Override
            public boolean supportsOption(Option<?> option) {
                return server2.supportsOption(option);
            }

            @Override
            public <T> T getOption(Option<T> option) throws IOException {
                return server2.getOption(option);
            }

            @Override
            public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
                return server2.setOption(option, value);
            }
        };
        acceptingChannel.getAcceptSetter().set(acceptListener);
        return acceptingChannel;
    }

    public void updateSSLContext(SSLContext context) {
        this.sslContext = context;
    }

    @Override
    public AcceptingChannel<SslConnection> createSslConnectionServer(XnioWorker worker, InetSocketAddress bindAddress, ChannelListener<? super AcceptingChannel<SslConnection>> acceptListener, OptionMap optionMap) throws IOException {
        UndertowAcceptingSslChannel server2 = new UndertowAcceptingSslChannel(this, worker.createStreamConnectionServer(bindAddress, null, optionMap), optionMap, this.bufferPool, false);
        if (acceptListener != null) {
            server2.getAcceptSetter().set(acceptListener);
        }
        return server2;
    }

    private class StreamConnectionChannelListener
    implements ChannelListener<StreamConnection> {
        private final OptionMap optionMap;
        private final InetSocketAddress destination;
        private final FutureResult<SslConnection> futureResult;
        private final ChannelListener<? super SslConnection> openListener;

        StreamConnectionChannelListener(OptionMap optionMap, InetSocketAddress destination, FutureResult<SslConnection> futureResult, ChannelListener<? super SslConnection> openListener) {
            this.optionMap = optionMap;
            this.destination = destination;
            this.futureResult = futureResult;
            this.openListener = openListener;
        }

        @Override
        public void handleEvent(StreamConnection connection) {
            try {
                SSLEngine sslEngine = JsseSslUtils.createSSLEngine(UndertowXnioSsl.this.sslContext, this.optionMap, this.destination);
                SSLParameters params = sslEngine.getSSLParameters();
                params.setServerNames(Collections.singletonList(new SNIHostName(this.destination.getHostString())));
                String endpointIdentificationAlgorithm = this.optionMap.get(UndertowOptions.ENDPOINT_IDENTIFICATION_ALGORITHM, null);
                if (endpointIdentificationAlgorithm != null) {
                    params.setEndpointIdentificationAlgorithm(endpointIdentificationAlgorithm);
                }
                sslEngine.setSSLParameters(params);
                UndertowSslConnection wrappedConnection = new UndertowSslConnection(connection, sslEngine, UndertowXnioSsl.this.bufferPool);
                if (!this.futureResult.setResult(wrappedConnection)) {
                    IoUtils.safeClose((Closeable)connection);
                } else {
                    ChannelListeners.invokeChannelListener(wrappedConnection, this.openListener);
                }
            }
            catch (Throwable e2) {
                this.futureResult.setException(new IOException(e2));
            }
        }
    }
}

