/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.handlers;

import io.undertow.UndertowLogger;
import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;

public class AuthenticationConstraintHandler
implements HttpHandler {
    private final HttpHandler next;

    public AuthenticationConstraintHandler(HttpHandler next2) {
        this.next = next2;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (this.isAuthenticationRequired(exchange)) {
            SecurityContext context = exchange.getSecurityContext();
            UndertowLogger.SECURITY_LOGGER.debugf("Setting authentication required for exchange %s", (Object)exchange);
            context.setAuthenticationRequired();
        }
        this.next.handleRequest(exchange);
    }

    protected boolean isAuthenticationRequired(HttpServerExchange exchange) {
        return true;
    }
}

