/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.builder.HandlerBuilder;
import io.undertow.util.HttpString;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DisallowedMethodsHandler
implements HttpHandler {
    private final Set<HttpString> disallowedMethods;
    private final HttpHandler next;

    public DisallowedMethodsHandler(HttpHandler next2, Set<HttpString> disallowedMethods) {
        this.disallowedMethods = new HashSet<HttpString>(disallowedMethods);
        this.next = next2;
    }

    public DisallowedMethodsHandler(HttpHandler next2, HttpString ... disallowedMethods) {
        this.disallowedMethods = new HashSet<HttpString>(Arrays.asList(disallowedMethods));
        this.next = next2;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (this.disallowedMethods.contains(exchange.getRequestMethod())) {
            exchange.setStatusCode(405);
            exchange.endExchange();
        } else {
            this.next.handleRequest(exchange);
        }
    }

    private static class Wrapper
    implements HandlerWrapper {
        private final String[] methods;

        private Wrapper(String[] methods2) {
            this.methods = methods2;
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            HttpString[] strings = new HttpString[this.methods.length];
            for (int i = 0; i < this.methods.length; ++i) {
                strings[i] = new HttpString(this.methods[i]);
            }
            return new DisallowedMethodsHandler(handler, strings);
        }
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "disallowed-methods";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.singletonMap("methods", String[].class);
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("methods");
        }

        @Override
        public String defaultParameter() {
            return "methods";
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return new Wrapper((String[])config.get("methods"));
        }
    }
}

