/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.cache.LRUCache;
import io.undertow.util.PathMatcher;

public class PathHandler
implements HttpHandler {
    private final PathMatcher<HttpHandler> pathMatcher = new PathMatcher();
    private final LRUCache<String, PathMatcher.PathMatch<HttpHandler>> cache;

    public PathHandler(HttpHandler defaultHandler) {
        this(0);
        this.pathMatcher.addPrefixPath("/", defaultHandler);
    }

    public PathHandler(HttpHandler defaultHandler, int cacheSize) {
        this(cacheSize);
        this.pathMatcher.addPrefixPath("/", defaultHandler);
    }

    public PathHandler() {
        this(0);
    }

    public PathHandler(int cacheSize) {
        this.cache = cacheSize > 0 ? new LRUCache(cacheSize, -1, true) : null;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        PathMatcher.PathMatch<HttpHandler> match = null;
        boolean hit = false;
        if (this.cache != null) {
            match = this.cache.get(exchange.getRelativePath());
            hit = true;
        }
        if (match == null) {
            match = this.pathMatcher.match(exchange.getRelativePath());
        }
        if (match.getValue() == null) {
            ResponseCodeHandler.HANDLE_404.handleRequest(exchange);
            return;
        }
        if (hit) {
            this.cache.add(exchange.getRelativePath(), match);
        }
        exchange.setRelativePath(match.getRemaining());
        if (exchange.getResolvedPath().isEmpty()) {
            exchange.setResolvedPath(match.getMatched());
        } else {
            exchange.setResolvedPath(exchange.getResolvedPath() + match.getMatched());
        }
        match.getValue().handleRequest(exchange);
    }

    @Deprecated
    public synchronized PathHandler addPath(String path2, HttpHandler handler) {
        return this.addPrefixPath(path2, handler);
    }

    public synchronized PathHandler addPrefixPath(String path2, HttpHandler handler) {
        Handlers.handlerNotNull(handler);
        this.pathMatcher.addPrefixPath(path2, handler);
        return this;
    }

    public synchronized PathHandler addExactPath(String path2, HttpHandler handler) {
        Handlers.handlerNotNull(handler);
        this.pathMatcher.addExactPath(path2, handler);
        return this;
    }

    @Deprecated
    public synchronized PathHandler removePath(String path2) {
        return this.removePrefixPath(path2);
    }

    public synchronized PathHandler removePrefixPath(String path2) {
        this.pathMatcher.removePrefixPath(path2);
        return this;
    }

    public synchronized PathHandler removeExactPath(String path2) {
        this.pathMatcher.removeExactPath(path2);
        return this;
    }

    public synchronized PathHandler clearPaths() {
        this.pathMatcher.clearPaths();
        return this;
    }
}

