/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowLogger;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.builder.HandlerBuilder;
import io.undertow.util.Headers;
import io.undertow.util.NetworkUtils;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class ProxyPeerAddressHandler
implements HttpHandler {
    private static final Pattern IP4_EXACT = Pattern.compile("(?:\\d{1,3}\\.){3}\\d{1,3}");
    private static final Pattern IP6_EXACT = Pattern.compile("(?:[a-zA-Z0-9]{1,4}:){7}[a-zA-Z0-9]{1,4}");
    private final HttpHandler next;

    public ProxyPeerAddressHandler(HttpHandler next2) {
        this.next = next2;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String forwardedProto;
        String forwardedFor = exchange.getRequestHeaders().getFirst(Headers.X_FORWARDED_FOR);
        if (forwardedFor != null) {
            String remoteClient = this.mostRecent(forwardedFor);
            if (IP4_EXACT.matcher(forwardedFor).matches()) {
                exchange.setSourceAddress(new InetSocketAddress(NetworkUtils.parseIpv4Address(remoteClient), 0));
            } else if (IP6_EXACT.matcher(forwardedFor).matches()) {
                exchange.setSourceAddress(new InetSocketAddress(NetworkUtils.parseIpv6Address(remoteClient), 0));
            } else {
                exchange.setSourceAddress(InetSocketAddress.createUnresolved(remoteClient, 0));
            }
        }
        if ((forwardedProto = exchange.getRequestHeaders().getFirst(Headers.X_FORWARDED_PROTO)) != null) {
            exchange.setRequestScheme(this.mostRecent(forwardedProto));
        }
        String forwardedHost = exchange.getRequestHeaders().getFirst(Headers.X_FORWARDED_HOST);
        String forwardedPort = exchange.getRequestHeaders().getFirst(Headers.X_FORWARDED_PORT);
        if (forwardedHost != null) {
            String value = this.mostRecent(forwardedHost);
            if (value.startsWith("[")) {
                int index2;
                int end = value.lastIndexOf("]");
                if (end == -1) {
                    end = 0;
                }
                if ((index2 = value.indexOf(":", end)) != -1) {
                    forwardedPort = value.substring(index2 + 1);
                    value = value.substring(0, index2);
                }
            } else {
                int index3 = value.lastIndexOf(":");
                if (index3 != -1) {
                    forwardedPort = value.substring(index3 + 1);
                    value = value.substring(0, index3);
                }
            }
            int port = 0;
            String hostHeader = NetworkUtils.formatPossibleIpv6Address(value);
            if (forwardedPort != null) {
                try {
                    port = Integer.parseInt(this.mostRecent(forwardedPort));
                    if (port > 0) {
                        String scheme = exchange.getRequestScheme();
                        if (!ProxyPeerAddressHandler.standardPort(port, scheme)) {
                            hostHeader = hostHeader + ":" + port;
                        }
                    } else {
                        UndertowLogger.REQUEST_LOGGER.debugf("Ignoring negative port: %s", (Object)forwardedPort);
                    }
                }
                catch (NumberFormatException ignore) {
                    UndertowLogger.REQUEST_LOGGER.debugf("Cannot parse port: %s", (Object)forwardedPort);
                }
            }
            exchange.getRequestHeaders().put(Headers.HOST, hostHeader);
            exchange.setDestinationAddress(InetSocketAddress.createUnresolved(value, port));
        }
        this.next.handleRequest(exchange);
    }

    private String mostRecent(String header) {
        int index2 = header.indexOf(44);
        if (index2 == -1) {
            return header;
        }
        return header.substring(0, index2);
    }

    private static boolean standardPort(int port, String scheme) {
        return port == 80 && "http".equals(scheme) || port == 443 && "https".equals(scheme);
    }

    private static class Wrapper
    implements HandlerWrapper {
        private Wrapper() {
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            return new ProxyPeerAddressHandler(handler);
        }
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "proxy-peer-address";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.emptyMap();
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.emptySet();
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return new Wrapper();
        }
    }
}

