/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientStatistics;
import io.undertow.client.UndertowClient;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.proxy.ConnectionPoolManager;
import io.undertow.server.handlers.proxy.ProxyCallback;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyConnection;
import io.undertow.util.CopyOnWriteMap;
import io.undertow.util.Headers;
import io.undertow.util.WorkerUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.ssl.XnioSsl;

public class ProxyConnectionPool
implements Closeable {
    private final URI uri;
    private final InetSocketAddress bindAddress;
    private final XnioSsl ssl;
    private final UndertowClient client;
    private final ConnectionPoolManager connectionPoolManager;
    private final OptionMap options;
    private volatile boolean closed;
    private final int maxConnections;
    private final int maxCachedConnections;
    private final int coreCachedConnections;
    private final long timeToLive;
    private final AtomicInteger openConnections = new AtomicInteger(0);
    private final AtomicLong requestCount = new AtomicLong();
    private final AtomicLong read = new AtomicLong();
    private final AtomicLong written = new AtomicLong();
    private final ConcurrentMap<XnioIoThread, HostThreadData> hostThreadData = new CopyOnWriteMap<XnioIoThread, HostThreadData>();

    public ProxyConnectionPool(ConnectionPoolManager connectionPoolManager, URI uri, UndertowClient client, OptionMap options) {
        this(connectionPoolManager, uri, null, client, options);
    }

    public ProxyConnectionPool(ConnectionPoolManager connectionPoolManager, InetSocketAddress bindAddress, URI uri, UndertowClient client, OptionMap options) {
        this(connectionPoolManager, bindAddress, uri, null, client, options);
    }

    public ProxyConnectionPool(ConnectionPoolManager connectionPoolManager, URI uri, XnioSsl ssl, UndertowClient client, OptionMap options) {
        this(connectionPoolManager, null, uri, ssl, client, options);
    }

    public ProxyConnectionPool(ConnectionPoolManager connectionPoolManager, InetSocketAddress bindAddress, URI uri, XnioSsl ssl, UndertowClient client, OptionMap options) {
        this.connectionPoolManager = connectionPoolManager;
        this.maxConnections = Math.max(connectionPoolManager.getMaxConnections(), 1);
        this.maxCachedConnections = Math.max(connectionPoolManager.getMaxCachedConnections(), 0);
        this.coreCachedConnections = Math.max(connectionPoolManager.getSMaxConnections(), 0);
        this.timeToLive = connectionPoolManager.getTtl();
        this.bindAddress = bindAddress;
        this.uri = uri;
        this.ssl = ssl;
        this.client = client;
        this.options = options;
    }

    public URI getUri() {
        return this.uri;
    }

    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    @Override
    public void close() {
        this.closed = true;
        for (HostThreadData data2 : this.hostThreadData.values()) {
            final ConnectionHolder holder = data2.availableConnections.poll();
            if (holder == null) continue;
            holder.clientConnection.getIoThread().execute(new Runnable(){

                @Override
                public void run() {
                    IoUtils.safeClose((Closeable)holder.clientConnection);
                }
            });
        }
    }

    private void returnConnection(ConnectionHolder connectionHolder) {
        ClientStatistics stats = connectionHolder.clientConnection.getStatistics();
        this.requestCount.incrementAndGet();
        if (stats != null) {
            this.read.addAndGet(stats.getRead());
            this.written.addAndGet(stats.getWritten());
            stats.reset();
        }
        HostThreadData hostData = this.getData();
        if (this.closed) {
            IoUtils.safeClose((Closeable)connectionHolder.clientConnection);
            ConnectionHolder con = hostData.availableConnections.poll();
            while (con != null) {
                IoUtils.safeClose((Closeable)con.clientConnection);
                con = hostData.availableConnections.poll();
            }
            this.redistributeQueued(hostData);
            return;
        }
        ClientConnection connection = connectionHolder.clientConnection;
        if (connection.isOpen() && !connection.isUpgraded()) {
            CallbackHolder callback = hostData.awaitingConnections.poll();
            while (callback != null && callback.isCancelled()) {
                callback = hostData.awaitingConnections.poll();
            }
            if (callback != null) {
                if (callback.getTimeoutKey() != null) {
                    callback.getTimeoutKey().remove();
                }
                this.connectionReady(connectionHolder, callback.getCallback(), callback.getExchange(), false);
            } else {
                ConnectionHolder holder;
                int cachedConnectionCount = hostData.availableConnections.size();
                if (cachedConnectionCount >= this.maxCachedConnections && (holder = hostData.availableConnections.poll()) != null) {
                    IoUtils.safeClose((Closeable)holder.clientConnection);
                }
                hostData.availableConnections.add(connectionHolder);
                if (this.timeToLive > 0L) {
                    long currentTime = System.currentTimeMillis();
                    connectionHolder.timeout = currentTime + this.timeToLive;
                    if (hostData.availableConnections.size() > this.coreCachedConnections && hostData.nextTimeout <= 0L) {
                        hostData.timeoutKey = WorkerUtils.executeAfter(connection.getIoThread(), hostData.timeoutTask, this.timeToLive, TimeUnit.MILLISECONDS);
                        hostData.nextTimeout = connectionHolder.timeout;
                    }
                }
            }
        } else if (connection.isOpen() && connection.isUpgraded()) {
            connection.getCloseSetter().set(null);
            this.handleClosedConnection(hostData, connectionHolder);
        }
    }

    private void handleClosedConnection(HostThreadData hostData, ConnectionHolder connection) {
        this.openConnections.decrementAndGet();
        int connections = --hostData.connections;
        hostData.availableConnections.remove(connection);
        if (connections < this.maxConnections) {
            CallbackHolder task = hostData.awaitingConnections.poll();
            while (task != null && task.isCancelled()) {
                task = hostData.awaitingConnections.poll();
            }
            if (task != null) {
                this.openConnection(task.exchange, task.callback, hostData, false);
            }
        }
    }

    private void openConnection(final HttpServerExchange exchange, final ProxyCallback<ProxyConnection> callback, final HostThreadData data2, final boolean exclusive) {
        if (!exclusive) {
            ++data2.connections;
        }
        try {
            this.client.connect(new ClientCallback<ClientConnection>(){

                @Override
                public void completed(ClientConnection result) {
                    ProxyConnectionPool.this.openConnections.incrementAndGet();
                    final ConnectionHolder connectionHolder = new ConnectionHolder(result);
                    if (!exclusive) {
                        result.getCloseSetter().set((ChannelListener<? extends ClientConnection>)new ChannelListener<ClientConnection>(){

                            @Override
                            public void handleEvent(ClientConnection channel) {
                                ProxyConnectionPool.this.handleClosedConnection(data2, connectionHolder);
                            }
                        });
                    }
                    ProxyConnectionPool.this.connectionReady(connectionHolder, callback, exchange, exclusive);
                }

                @Override
                public void failed(IOException e2) {
                    if (!exclusive) {
                        --data2.connections;
                    }
                    UndertowLogger.REQUEST_LOGGER.debug("Failed to connect", e2);
                    if (!ProxyConnectionPool.this.connectionPoolManager.handleError()) {
                        ProxyConnectionPool.this.redistributeQueued(ProxyConnectionPool.this.getData());
                        ProxyConnectionPool.this.scheduleFailedHostRetry(exchange);
                    }
                    callback.failed(exchange);
                }
            }, this.bindAddress, this.getUri(), exchange.getIoThread(), this.ssl, exchange.getConnection().getByteBufferPool(), this.options);
        }
        catch (RuntimeException e2) {
            if (!exclusive) {
                --data2.connections;
            }
            this.connectionPoolManager.handleError();
            callback.failed(exchange);
            throw e2;
        }
    }

    private void redistributeQueued(HostThreadData hostData) {
        CallbackHolder callback = hostData.awaitingConnections.poll();
        while (callback != null) {
            if (callback.getTimeoutKey() != null) {
                callback.getTimeoutKey().remove();
            }
            if (!callback.isCancelled()) {
                long time2 = System.currentTimeMillis();
                if (callback.getExpireTime() > 0L && callback.getExpireTime() < time2) {
                    callback.getCallback().failed(callback.getExchange());
                } else {
                    callback.getCallback().queuedRequestFailed(callback.getExchange());
                }
            }
            callback = hostData.awaitingConnections.poll();
        }
    }

    private void connectionReady(final ConnectionHolder result, ProxyCallback<ProxyConnection> callback, HttpServerExchange exchange, final boolean exclusive) {
        try {
            exchange.addExchangeCompleteListener(new ExchangeCompletionListener(){

                @Override
                public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
                    if (!exclusive) {
                        ProxyConnectionPool.this.returnConnection(result);
                    }
                    nextListener.proceed();
                }
            });
        }
        catch (Exception e2) {
            this.returnConnection(result);
            callback.failed(exchange);
            return;
        }
        callback.completed(exchange, new ProxyConnection(result.clientConnection, this.uri.getPath() == null ? "/" : this.uri.getPath()));
    }

    public AvailabilityType available() {
        if (this.closed) {
            return AvailabilityType.CLOSED;
        }
        if (!this.connectionPoolManager.isAvailable()) {
            return AvailabilityType.PROBLEM;
        }
        HostThreadData data2 = this.getData();
        if (data2.connections < this.maxConnections) {
            return AvailabilityType.AVAILABLE;
        }
        if (!data2.availableConnections.isEmpty()) {
            return AvailabilityType.AVAILABLE;
        }
        if (data2.awaitingConnections.size() >= this.connectionPoolManager.getMaxQueueSize()) {
            return AvailabilityType.FULL_QUEUE;
        }
        return AvailabilityType.FULL;
    }

    private void scheduleFailedHostRetry(final HttpServerExchange exchange) {
        int retry = this.connectionPoolManager.getProblemServerRetry();
        if (retry > 0 && !this.connectionPoolManager.isAvailable()) {
            WorkerUtils.executeAfter(exchange.getIoThread(), new Runnable(){

                @Override
                public void run() {
                    if (ProxyConnectionPool.this.closed) {
                        return;
                    }
                    UndertowLogger.PROXY_REQUEST_LOGGER.debugf("Attempting to reconnect to failed host %s", (Object)ProxyConnectionPool.this.getUri());
                    try {
                        ProxyConnectionPool.this.client.connect(new ClientCallback<ClientConnection>(){

                            @Override
                            public void completed(ClientConnection result) {
                                UndertowLogger.PROXY_REQUEST_LOGGER.debugf("Connected to previously failed host %s, returning to service", (Object)ProxyConnectionPool.this.getUri());
                                if (ProxyConnectionPool.this.connectionPoolManager.clearError()) {
                                    final ConnectionHolder connectionHolder = new ConnectionHolder(result);
                                    final HostThreadData data2 = ProxyConnectionPool.this.getData();
                                    result.getCloseSetter().set((ChannelListener<? extends ClientConnection>)new ChannelListener<ClientConnection>(){

                                        @Override
                                        public void handleEvent(ClientConnection channel) {
                                            ProxyConnectionPool.this.handleClosedConnection(data2, connectionHolder);
                                        }
                                    });
                                    ++data2.connections;
                                    ProxyConnectionPool.this.returnConnection(connectionHolder);
                                } else {
                                    ProxyConnectionPool.this.scheduleFailedHostRetry(exchange);
                                }
                            }

                            @Override
                            public void failed(IOException e2) {
                                UndertowLogger.PROXY_REQUEST_LOGGER.debugf("Failed to reconnect to failed host %s", (Object)ProxyConnectionPool.this.getUri());
                                ProxyConnectionPool.this.connectionPoolManager.handleError();
                                ProxyConnectionPool.this.scheduleFailedHostRetry(exchange);
                            }
                        }, ProxyConnectionPool.this.bindAddress, ProxyConnectionPool.this.getUri(), exchange.getIoThread(), ProxyConnectionPool.this.ssl, exchange.getConnection().getByteBufferPool(), ProxyConnectionPool.this.options);
                    }
                    catch (RuntimeException e2) {
                        ProxyConnectionPool.this.connectionPoolManager.handleError();
                        ProxyConnectionPool.this.scheduleFailedHostRetry(exchange);
                    }
                }
            }, retry, TimeUnit.SECONDS);
        }
    }

    private void timeoutConnections(long currentTime, HostThreadData data2) {
        ConnectionHolder holder;
        int idleConnections = data2.availableConnections.size();
        while (idleConnections > 0 && idleConnections > this.coreCachedConnections && (holder = data2.availableConnections.peek()) != null) {
            if (!holder.clientConnection.isOpen()) {
                --idleConnections;
                continue;
            }
            if (currentTime >= holder.timeout) {
                holder = data2.availableConnections.poll();
                IoUtils.safeClose((Closeable)holder.clientConnection);
                --idleConnections;
                continue;
            }
            if (data2.timeoutKey != null) {
                data2.timeoutKey.remove();
                data2.timeoutKey = null;
            }
            long remaining = holder.timeout - currentTime + 1L;
            data2.nextTimeout = holder.timeout;
            data2.timeoutKey = WorkerUtils.executeAfter(holder.clientConnection.getIoThread(), data2.timeoutTask, remaining, TimeUnit.MILLISECONDS);
            return;
        }
        if (data2.timeoutKey != null) {
            data2.timeoutKey.remove();
            data2.timeoutKey = null;
        }
        data2.nextTimeout = -1L;
    }

    private HostThreadData getData() {
        Thread thread2 = Thread.currentThread();
        if (!(thread2 instanceof XnioIoThread)) {
            throw UndertowMessages.MESSAGES.canOnlyBeCalledByIoThread();
        }
        XnioIoThread ioThread = (XnioIoThread)thread2;
        HostThreadData data2 = (HostThreadData)this.hostThreadData.get(ioThread);
        if (data2 != null) {
            return data2;
        }
        data2 = new HostThreadData();
        HostThreadData existing = this.hostThreadData.putIfAbsent(ioThread, data2);
        if (existing != null) {
            return existing;
        }
        return data2;
    }

    public ClientStatistics getClientStatistics() {
        return new ClientStatistics(){

            @Override
            public long getRequests() {
                return ProxyConnectionPool.this.requestCount.get();
            }

            @Override
            public long getRead() {
                return ProxyConnectionPool.this.read.get();
            }

            @Override
            public long getWritten() {
                return ProxyConnectionPool.this.written.get();
            }

            @Override
            public void reset() {
                ProxyConnectionPool.this.requestCount.set(0L);
                ProxyConnectionPool.this.read.set(0L);
                ProxyConnectionPool.this.written.set(0L);
            }
        };
    }

    public int getOpenConnections() {
        return this.openConnections.get();
    }

    public void connect(ProxyClient.ProxyTarget proxyTarget, HttpServerExchange exchange, ProxyCallback<ProxyConnection> callback, long timeout, TimeUnit timeUnit, boolean exclusive) {
        HostThreadData data2 = this.getData();
        ConnectionHolder connectionHolder = data2.availableConnections.poll();
        while (connectionHolder != null && !connectionHolder.clientConnection.isOpen()) {
            connectionHolder = data2.availableConnections.poll();
        }
        boolean upgradeRequest = exchange.getRequestHeaders().contains(Headers.UPGRADE);
        if (connectionHolder != null && (!upgradeRequest || connectionHolder.clientConnection.isUpgradeSupported())) {
            if (exclusive) {
                --data2.connections;
            }
            this.connectionReady(connectionHolder, callback, exchange, exclusive);
        } else if (exclusive || data2.connections < this.maxConnections) {
            this.openConnection(exchange, callback, data2, exclusive);
        } else {
            CallbackHolder holder;
            if (data2.awaitingConnections.size() >= this.connectionPoolManager.getMaxQueueSize()) {
                callback.queuedRequestFailed(exchange);
                return;
            }
            if (timeout > 0L) {
                long time2 = System.currentTimeMillis();
                holder = new CallbackHolder(proxyTarget, callback, exchange, time2 + timeUnit.toMillis(timeout));
                holder.setTimeoutKey(WorkerUtils.executeAfter(exchange.getIoThread(), holder, timeout, timeUnit));
            } else {
                holder = new CallbackHolder(proxyTarget, callback, exchange, -1L);
            }
            data2.awaitingConnections.add(holder);
        }
    }

    void closeCurrentConnections() {
        final CountDownLatch latch = new CountDownLatch(this.hostThreadData.size());
        for (final Map.Entry data2 : this.hostThreadData.entrySet()) {
            ((XnioIoThread)data2.getKey()).execute(new Runnable(){

                @Override
                public void run() {
                    ConnectionHolder d = ((HostThreadData)data2.getValue()).availableConnections.poll();
                    while (d != null) {
                        IoUtils.safeClose((Closeable)d.clientConnection);
                        d = ((HostThreadData)data2.getValue()).availableConnections.poll();
                    }
                    ((HostThreadData)data2.getValue()).connections = 0;
                    latch.countDown();
                }
            });
        }
        try {
            latch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e2);
        }
    }

    public static enum AvailabilityType {
        AVAILABLE,
        DRAIN,
        FULL,
        FULL_QUEUE,
        PROBLEM,
        CLOSED;

    }

    private static final class CallbackHolder
    implements Runnable {
        final ProxyClient.ProxyTarget proxyTarget;
        final ProxyCallback<ProxyConnection> callback;
        final HttpServerExchange exchange;
        final long expireTime;
        XnioExecutor.Key timeoutKey;
        boolean cancelled = false;

        private CallbackHolder(ProxyClient.ProxyTarget proxyTarget, ProxyCallback<ProxyConnection> callback, HttpServerExchange exchange, long expireTime) {
            this.proxyTarget = proxyTarget;
            this.callback = callback;
            this.exchange = exchange;
            this.expireTime = expireTime;
        }

        private ProxyCallback<ProxyConnection> getCallback() {
            return this.callback;
        }

        private HttpServerExchange getExchange() {
            return this.exchange;
        }

        private long getExpireTime() {
            return this.expireTime;
        }

        private XnioExecutor.Key getTimeoutKey() {
            return this.timeoutKey;
        }

        private boolean isCancelled() {
            return this.cancelled || this.exchange.isResponseStarted();
        }

        private void setTimeoutKey(XnioExecutor.Key timeoutKey) {
            this.timeoutKey = timeoutKey;
        }

        @Override
        public void run() {
            this.cancelled = true;
            this.callback.failed(this.exchange);
        }

        public ProxyClient.ProxyTarget getProxyTarget() {
            return this.proxyTarget;
        }
    }

    private static final class ConnectionHolder {
        private long timeout;
        private final ClientConnection clientConnection;

        private ConnectionHolder(ClientConnection clientConnection) {
            this.clientConnection = clientConnection;
        }
    }

    private final class HostThreadData {
        int connections = 0;
        XnioExecutor.Key timeoutKey;
        long nextTimeout = -1L;
        final Deque<ConnectionHolder> availableConnections = new ArrayDeque<ConnectionHolder>();
        final Deque<CallbackHolder> awaitingConnections = new ArrayDeque<CallbackHolder>();
        final Runnable timeoutTask = new Runnable(){

            @Override
            public void run() {
                long currentTime = System.currentTimeMillis();
                ProxyConnectionPool.this.timeoutConnections(currentTime, HostThreadData.this);
            }
        };

        private HostThreadData() {
        }
    }
}

