/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy.mod_cluster;

import io.undertow.UndertowMessages;
import io.undertow.server.handlers.proxy.mod_cluster.Context;
import io.undertow.util.CopyOnWriteMap;
import io.undertow.util.PathMatcher;
import io.undertow.util.URLUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;

public class VirtualHost {
    private static final String STRING_PATH_SEPARATOR = "/";
    private final HostEntry defaultHandler = new HostEntry("/");
    private final ConcurrentMap<String, HostEntry> contexts = new CopyOnWriteMap<String, HostEntry>();
    private volatile int[] lengths = new int[0];

    protected VirtualHost() {
    }

    PathMatcher.PathMatch<HostEntry> match(String path2) {
        int length = path2.length();
        int[] lengths = this.lengths;
        for (int i = 0; i < lengths.length; ++i) {
            String part;
            HostEntry next2;
            char c;
            int pathLength = lengths[i];
            if (pathLength == length) {
                HostEntry next3 = (HostEntry)this.contexts.get(path2);
                if (next3 == null) continue;
                return new PathMatcher.PathMatch<HostEntry>(path2, "", next3);
            }
            if (pathLength >= length || (c = path2.charAt(pathLength)) != '/' || (next2 = (HostEntry)this.contexts.get(part = path2.substring(0, pathLength))) == null) continue;
            return new PathMatcher.PathMatch<HostEntry>(part, path2.substring(pathLength), next2);
        }
        if (this.defaultHandler.contexts.isEmpty()) {
            return new PathMatcher.PathMatch<Object>("", path2, null);
        }
        return new PathMatcher.PathMatch<HostEntry>("", path2, this.defaultHandler);
    }

    public synchronized void registerContext(String path2, String jvmRoute, Context context) {
        if (path2.isEmpty()) {
            throw UndertowMessages.MESSAGES.pathMustBeSpecified();
        }
        String normalizedPath = URLUtils.normalizeSlashes(path2);
        if (STRING_PATH_SEPARATOR.equals(normalizedPath)) {
            this.defaultHandler.contexts.put(jvmRoute, context);
            return;
        }
        boolean rebuild = false;
        HostEntry hostEntry = (HostEntry)this.contexts.get(normalizedPath);
        if (hostEntry == null) {
            rebuild = true;
            hostEntry = new HostEntry(normalizedPath);
            this.contexts.put(normalizedPath, hostEntry);
        }
        assert (!hostEntry.contexts.containsKey(jvmRoute));
        hostEntry.contexts.put(jvmRoute, context);
        if (rebuild) {
            this.buildLengths();
        }
    }

    public synchronized void removeContext(String path2, String jvmRoute, Context context) {
        HostEntry hostEntry;
        if (path2 == null || path2.isEmpty()) {
            throw UndertowMessages.MESSAGES.pathMustBeSpecified();
        }
        String normalizedPath = URLUtils.normalizeSlashes(path2);
        if (STRING_PATH_SEPARATOR.equals(normalizedPath)) {
            this.defaultHandler.contexts.remove(jvmRoute, context);
        }
        if ((hostEntry = (HostEntry)this.contexts.get(normalizedPath)) != null && hostEntry.contexts.remove(jvmRoute, context) && hostEntry.contexts.isEmpty()) {
            this.contexts.remove(normalizedPath);
            this.buildLengths();
        }
    }

    boolean isEmpty() {
        return this.contexts.isEmpty() && this.defaultHandler.contexts.isEmpty();
    }

    private void buildLengths() {
        TreeSet<Integer> lengths = new TreeSet<Integer>(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return -o1.compareTo(o2);
            }
        });
        for (String p : this.contexts.keySet()) {
            lengths.add(p.length());
        }
        int[] lengthArray = new int[lengths.size()];
        int pos = 0;
        Iterator iterator = lengths.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            lengthArray[pos++] = i;
        }
        this.lengths = lengthArray;
    }

    static class HostEntry {
        private final ConcurrentMap<String, Context> contexts = new CopyOnWriteMap<String, Context>();
        private final String contextPath;

        HostEntry(String contextPath) {
            this.contextPath = contextPath;
        }

        protected String getContextPath() {
            return this.contextPath;
        }

        protected Context getContextForNode(String jvmRoute) {
            return (Context)this.contexts.get(jvmRoute);
        }

        protected Collection<String> getNodes() {
            return Collections.unmodifiableCollection(this.contexts.keySet());
        }

        protected Collection<Context> getContexts() {
            return Collections.unmodifiableCollection(this.contexts.values());
        }
    }
}

