/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.resource;

import io.undertow.UndertowMessages;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceChangeListener;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.handlers.resource.URLResource;
import java.io.IOException;
import java.net.URL;

public class ClassPathResourceManager
implements ResourceManager {
    private final ClassLoader classLoader;
    private final String prefix;

    public ClassPathResourceManager(ClassLoader loader, Package p) {
        this(loader, p.getName().replace(".", "/"));
    }

    public ClassPathResourceManager(ClassLoader classLoader, String prefix) {
        this.classLoader = classLoader;
        this.prefix = prefix.isEmpty() ? "" : (prefix.endsWith("/") ? prefix : prefix + "/");
    }

    public ClassPathResourceManager(ClassLoader classLoader) {
        this(classLoader, "");
    }

    @Override
    public Resource getResource(String path2) throws IOException {
        String realPath;
        URL resource2;
        String modPath = path2;
        if (modPath.startsWith("/")) {
            modPath = path2.substring(1);
        }
        if ((resource2 = this.classLoader.getResource(realPath = this.prefix + modPath)) == null) {
            return null;
        }
        return new URLResource(resource2, path2);
    }

    @Override
    public boolean isResourceChangeListenerSupported() {
        return false;
    }

    @Override
    public void registerResourceChangeListener(ResourceChangeListener listener) {
        throw UndertowMessages.MESSAGES.resourceChangeListenerNotSupported();
    }

    @Override
    public void removeResourceChangeListener(ResourceChangeListener listener) {
        throw UndertowMessages.MESSAGES.resourceChangeListenerNotSupported();
    }

    @Override
    public void close() throws IOException {
    }
}

