/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.resource;

import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.handlers.resource.ResourceSupplier;
import io.undertow.util.CopyOnWriteMap;
import io.undertow.util.ETag;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.MimeMappings;
import io.undertow.util.QValueParser;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class PreCompressedResourceSupplier
implements ResourceSupplier {
    private final ResourceManager resourceManager;
    private final Map<String, String> encodingMap = new CopyOnWriteMap<String, String>();

    public PreCompressedResourceSupplier(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    @Override
    public Resource getResource(HttpServerExchange exchange, String path2) throws IOException {
        Resource originalResource = this.resourceManager.getResource(path2);
        if (exchange.getRequestHeaders().contains(Headers.RANGE)) {
            return originalResource;
        }
        Resource resource2 = this.getEncodedResource(exchange, path2, originalResource);
        if (resource2 == null) {
            return originalResource;
        }
        return resource2;
    }

    private Resource getEncodedResource(HttpServerExchange exchange, String path2, final Resource originalResource) throws IOException {
        HeaderValues res = exchange.getRequestHeaders().get(Headers.ACCEPT_ENCODING);
        if (res == null || res.isEmpty()) {
            return null;
        }
        List<List<QValueParser.QValueResult>> found = QValueParser.parse(res);
        for (List<QValueParser.QValueResult> result : found) {
            for (final QValueParser.QValueResult value : result) {
                String newPath;
                Resource resource2;
                String extension = this.encodingMap.get(value.getValue());
                if (extension == null || (resource2 = this.resourceManager.getResource(newPath = path2 + extension)) == null || resource2.isDirectory()) continue;
                return new Resource(){

                    @Override
                    public String getPath() {
                        return resource2.getPath();
                    }

                    @Override
                    public Date getLastModified() {
                        return resource2.getLastModified();
                    }

                    @Override
                    public String getLastModifiedString() {
                        return resource2.getLastModifiedString();
                    }

                    @Override
                    public ETag getETag() {
                        return resource2.getETag();
                    }

                    @Override
                    public String getName() {
                        return resource2.getName();
                    }

                    @Override
                    public boolean isDirectory() {
                        return false;
                    }

                    @Override
                    public List<Resource> list() {
                        return resource2.list();
                    }

                    @Override
                    public String getContentType(MimeMappings mimeMappings) {
                        return originalResource.getContentType(mimeMappings);
                    }

                    @Override
                    public void serve(Sender sender, HttpServerExchange exchange, IoCallback completionCallback) {
                        exchange.getResponseHeaders().put(Headers.CONTENT_ENCODING, value.getValue());
                        resource2.serve(sender, exchange, completionCallback);
                    }

                    @Override
                    public Long getContentLength() {
                        return resource2.getContentLength();
                    }

                    @Override
                    public String getCacheKey() {
                        return resource2.getCacheKey();
                    }

                    @Override
                    public File getFile() {
                        return resource2.getFile();
                    }

                    @Override
                    public Path getFilePath() {
                        return resource2.getFilePath();
                    }

                    @Override
                    public File getResourceManagerRoot() {
                        return resource2.getResourceManagerRoot();
                    }

                    @Override
                    public Path getResourceManagerRootPath() {
                        return resource2.getResourceManagerRootPath();
                    }

                    @Override
                    public URL getUrl() {
                        return resource2.getUrl();
                    }
                };
            }
        }
        return null;
    }

    public PreCompressedResourceSupplier addEncoding(String encoding2, String extension) {
        this.encodingMap.put(encoding2, extension);
        return this;
    }

    public PreCompressedResourceSupplier removeEncoding(String encoding2) {
        this.encodingMap.remove(encoding2);
        return this;
    }
}

