/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.sse;

import io.undertow.UndertowLogger;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Attachable;
import io.undertow.util.AttachmentKey;
import io.undertow.util.AttachmentList;
import io.undertow.util.HeaderMap;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.XnioExecutor;
import org.xnio.channels.StreamSinkChannel;

public class ServerSentEventConnection
implements Channel,
Attachable {
    private final HttpServerExchange exchange;
    private final StreamSinkChannel sink;
    private final SseWriteListener writeListener = new SseWriteListener();
    private PooledByteBuffer pooled;
    private final Deque<SSEData> queue = new ConcurrentLinkedDeque<SSEData>();
    private final Queue<SSEData> buffered = new ConcurrentLinkedDeque<SSEData>();
    private final Queue<SSEData> flushingMessages = new ArrayDeque<SSEData>();
    private final List<ChannelListener<ServerSentEventConnection>> closeTasks = new CopyOnWriteArrayList<ChannelListener<ServerSentEventConnection>>();
    private Map<String, String> parameters;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private static final AtomicIntegerFieldUpdater<ServerSentEventConnection> openUpdater = AtomicIntegerFieldUpdater.newUpdater(ServerSentEventConnection.class, "open");
    private volatile int open = 1;
    private volatile boolean shutdown = false;
    private volatile long keepAliveTime = -1L;
    private XnioExecutor.Key timerKey;

    public ServerSentEventConnection(HttpServerExchange exchange, StreamSinkChannel sink) {
        this.exchange = exchange;
        this.sink = sink;
        this.sink.getCloseSetter().set((ChannelListener<? extends StreamSinkChannel>)new ChannelListener<StreamSinkChannel>(){

            @Override
            public void handleEvent(StreamSinkChannel channel) {
                if (ServerSentEventConnection.this.timerKey != null) {
                    ServerSentEventConnection.this.timerKey.remove();
                }
                for (ChannelListener listener : ServerSentEventConnection.this.closeTasks) {
                    ChannelListeners.invokeChannelListener(ServerSentEventConnection.this, listener);
                }
                IoUtils.safeClose((Closeable)ServerSentEventConnection.this);
            }
        });
        this.sink.getWriteSetter().set(this.writeListener);
    }

    public synchronized void addCloseTask(ChannelListener<ServerSentEventConnection> listener) {
        this.closeTasks.add(listener);
    }

    public Principal getPrincipal() {
        Account account = this.getAccount();
        if (account != null) {
            return account.getPrincipal();
        }
        return null;
    }

    public Account getAccount() {
        SecurityContext sc = this.exchange.getSecurityContext();
        if (sc != null) {
            return sc.getAuthenticatedAccount();
        }
        return null;
    }

    public HeaderMap getRequestHeaders() {
        return this.exchange.getRequestHeaders();
    }

    public HeaderMap getResponseHeaders() {
        return this.exchange.getResponseHeaders();
    }

    public String getRequestURI() {
        return this.exchange.getRequestURI();
    }

    public Map<String, Deque<String>> getQueryParameters() {
        return this.exchange.getQueryParameters();
    }

    public String getQueryString() {
        return this.exchange.getQueryString();
    }

    public void send(String data2) {
        this.send(data2, null, null, null);
    }

    public void send(String data2, EventCallback callback) {
        this.send(data2, null, null, callback);
    }

    public void sendRetry(long retry) {
        this.sendRetry(retry, null);
    }

    public synchronized void sendRetry(long retry, EventCallback callback) {
        if (this.open == 0 || this.shutdown) {
            if (callback != null) {
                callback.failed(this, null, null, null, new ClosedChannelException());
            }
            return;
        }
        this.queue.add(new SSEData(retry, callback));
        this.sink.getIoThread().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ServerSentEventConnection serverSentEventConnection = ServerSentEventConnection.this;
                synchronized (serverSentEventConnection) {
                    if (ServerSentEventConnection.this.pooled == null) {
                        ServerSentEventConnection.this.fillBuffer();
                        ServerSentEventConnection.this.writeListener.handleEvent(ServerSentEventConnection.this.sink);
                    }
                }
            }
        });
    }

    public synchronized void send(String data2, String event, String id, EventCallback callback) {
        if (this.open == 0 || this.shutdown) {
            if (callback != null) {
                callback.failed(this, data2, event, id, new ClosedChannelException());
            }
            return;
        }
        this.queue.add(new SSEData(event, data2, id, callback));
        this.sink.getIoThread().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ServerSentEventConnection serverSentEventConnection = ServerSentEventConnection.this;
                synchronized (serverSentEventConnection) {
                    if (ServerSentEventConnection.this.pooled == null) {
                        ServerSentEventConnection.this.fillBuffer();
                        ServerSentEventConnection.this.writeListener.handleEvent(ServerSentEventConnection.this.sink);
                    }
                }
            }
        });
    }

    public String getParameter(String name2) {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.get(name2);
    }

    public void setParameter(String name2, String value) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        this.parameters.put(name2, value);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
        if (this.timerKey != null) {
            this.timerKey.remove();
        }
        this.timerKey = this.sink.getIoThread().executeAtInterval(new Runnable(){

            @Override
            public void run() {
                if (ServerSentEventConnection.this.shutdown || ServerSentEventConnection.this.open == 0) {
                    if (ServerSentEventConnection.this.timerKey != null) {
                        ServerSentEventConnection.this.timerKey.remove();
                    }
                    return;
                }
                if (ServerSentEventConnection.this.pooled == null) {
                    ServerSentEventConnection.this.pooled = ServerSentEventConnection.this.exchange.getConnection().getByteBufferPool().allocate();
                    ServerSentEventConnection.this.pooled.getBuffer().put(":\n".getBytes(StandardCharsets.UTF_8));
                    ServerSentEventConnection.this.pooled.getBuffer().flip();
                    ServerSentEventConnection.this.writeListener.handleEvent(ServerSentEventConnection.this.sink);
                }
            }
        }, keepAliveTime, TimeUnit.MILLISECONDS);
    }

    private void fillBuffer() {
        if (this.queue.isEmpty()) {
            if (this.pooled != null) {
                this.pooled.close();
                this.pooled = null;
                this.sink.suspendWrites();
            }
            return;
        }
        if (this.pooled == null) {
            this.pooled = this.exchange.getConnection().getByteBufferPool().allocate();
        } else {
            this.pooled.getBuffer().clear();
        }
        ByteBuffer buffer = this.pooled.getBuffer();
        while (!this.queue.isEmpty() && buffer.hasRemaining()) {
            SSEData data2 = this.queue.poll();
            this.buffered.add(data2);
            if (data2.leftOverData == null) {
                StringBuilder message = new StringBuilder();
                if (data2.retry > 0L) {
                    message.append("retry:");
                    message.append(data2.retry);
                    message.append('\n');
                } else {
                    if (data2.id != null) {
                        message.append("id:");
                        message.append(data2.id);
                        message.append('\n');
                    }
                    if (data2.event != null) {
                        message.append("event:");
                        message.append(data2.event);
                        message.append('\n');
                    }
                    if (data2.data != null) {
                        message.append("data:");
                        for (int i = 0; i < data2.data.length(); ++i) {
                            char c = data2.data.charAt(i);
                            if (c == '\n') {
                                message.append("\ndata:");
                                continue;
                            }
                            message.append(c);
                        }
                        message.append('\n');
                    }
                }
                message.append('\n');
                byte[] messageBytes = message.toString().getBytes(StandardCharsets.UTF_8);
                if (messageBytes.length < buffer.remaining()) {
                    buffer.put(messageBytes);
                    data2.endBufferPosition = buffer.position();
                    continue;
                }
                this.queue.addFirst(data2);
                int rem2 = buffer.remaining();
                buffer.put(messageBytes, 0, rem2);
                SSEData.access$1202(data2, messageBytes);
                data2.leftOverDataOffset = rem2;
                continue;
            }
            int remainingData = data2.leftOverData.length - data2.leftOverDataOffset;
            if (remainingData > buffer.remaining()) {
                this.queue.addFirst(data2);
                int toWrite = buffer.remaining();
                buffer.put(data2.leftOverData, data2.leftOverDataOffset, toWrite);
                SSEData sSEData = data2;
                sSEData.leftOverDataOffset = sSEData.leftOverDataOffset + toWrite;
                continue;
            }
            buffer.put(data2.leftOverData, data2.leftOverDataOffset, remainingData);
            data2.endBufferPosition = buffer.position();
            SSEData.access$1202(data2, null);
        }
        buffer.flip();
        this.sink.resumeWrites();
    }

    public void shutdown() {
        if (this.open == 0 || this.shutdown) {
            return;
        }
        this.shutdown = true;
        this.sink.getIoThread().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ServerSentEventConnection serverSentEventConnection = ServerSentEventConnection.this;
                synchronized (serverSentEventConnection) {
                    if (ServerSentEventConnection.this.queue.isEmpty() && ServerSentEventConnection.this.pooled == null) {
                        ServerSentEventConnection.this.exchange.endExchange();
                    }
                }
            }
        });
    }

    @Override
    public boolean isOpen() {
        return this.open != 0;
    }

    @Override
    public void close() throws IOException {
        this.close(new ClosedChannelException());
    }

    private synchronized void close(IOException e2) throws IOException {
        if (openUpdater.compareAndSet(this, 1, 0)) {
            if (this.pooled != null) {
                this.pooled.close();
                this.pooled = null;
            }
            ArrayList<SSEData> cb = new ArrayList<SSEData>(this.buffered.size() + this.queue.size() + this.flushingMessages.size());
            cb.addAll(this.buffered);
            cb.addAll(this.queue);
            cb.addAll(this.flushingMessages);
            this.queue.clear();
            this.buffered.clear();
            this.flushingMessages.clear();
            for (SSEData i : cb) {
                if (i.callback == null) continue;
                try {
                    i.callback.failed(this, i.data, i.event, i.id, e2);
                }
                catch (Exception ex) {
                    UndertowLogger.REQUEST_LOGGER.failedToInvokeFailedCallback(i.callback, ex);
                }
            }
            this.sink.shutdownWrites();
            if (!this.sink.flush()) {
                this.sink.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, new ChannelExceptionHandler<StreamSinkChannel>(){

                    @Override
                    public void handleException(StreamSinkChannel channel, IOException exception) {
                        IoUtils.safeClose((Closeable)ServerSentEventConnection.this.sink);
                    }
                }));
                this.sink.resumeWrites();
            }
        }
    }

    @Override
    public <T> T getAttachment(AttachmentKey<T> key2) {
        return this.exchange.getAttachment(key2);
    }

    @Override
    public <T> List<T> getAttachmentList(AttachmentKey<? extends List<T>> key2) {
        return this.exchange.getAttachmentList(key2);
    }

    @Override
    public <T> T putAttachment(AttachmentKey<T> key2, T value) {
        return this.exchange.putAttachment(key2, value);
    }

    @Override
    public <T> T removeAttachment(AttachmentKey<T> key2) {
        return this.exchange.removeAttachment(key2);
    }

    @Override
    public <T> void addToAttachmentList(AttachmentKey<AttachmentList<T>> key2, T value) {
        this.exchange.addToAttachmentList(key2, value);
    }

    private void handleException(IOException e2) {
        IoUtils.safeClose(this, this.sink, this.exchange.getConnection());
    }

    private class SseWriteListener
    implements ChannelListener<StreamSinkChannel> {
        private SseWriteListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleEvent(StreamSinkChannel channel) {
            ServerSentEventConnection serverSentEventConnection = ServerSentEventConnection.this;
            synchronized (serverSentEventConnection) {
                try {
                    int res;
                    ByteBuffer buffer;
                    if (!ServerSentEventConnection.this.flushingMessages.isEmpty()) {
                        if (!channel.flush()) {
                            return;
                        }
                        for (SSEData data2 : ServerSentEventConnection.this.flushingMessages) {
                            if (data2.callback == null || data2.leftOverData != null) continue;
                            data2.callback.done(ServerSentEventConnection.this, data2.data, data2.event, data2.id);
                        }
                        ServerSentEventConnection.this.flushingMessages.clear();
                        buffer = ServerSentEventConnection.this.pooled.getBuffer();
                        if (!buffer.hasRemaining()) {
                            ServerSentEventConnection.this.fillBuffer();
                            if (ServerSentEventConnection.this.pooled == null) {
                                if (channel.flush()) {
                                    channel.suspendWrites();
                                }
                                return;
                            }
                        }
                    } else if (ServerSentEventConnection.this.pooled == null) {
                        if (channel.flush()) {
                            channel.suspendWrites();
                        }
                        return;
                    }
                    buffer = ServerSentEventConnection.this.pooled.getBuffer();
                    do {
                        res = channel.write(buffer);
                        boolean flushed = channel.flush();
                        while (!ServerSentEventConnection.this.buffered.isEmpty()) {
                            SSEData data3 = (SSEData)ServerSentEventConnection.this.buffered.peek();
                            if (data3.endBufferPosition > 0 && buffer.position() >= data3.endBufferPosition) {
                                ServerSentEventConnection.this.buffered.poll();
                                if (flushed) {
                                    if (data3.callback == null || data3.leftOverData != null) continue;
                                    data3.callback.done(ServerSentEventConnection.this, data3.data, data3.event, data3.id);
                                    continue;
                                }
                                ServerSentEventConnection.this.flushingMessages.add(data3);
                                continue;
                            }
                            if (data3.endBufferPosition > 0) break;
                            ServerSentEventConnection.this.buffered.poll();
                            break;
                        }
                        if (!flushed && !ServerSentEventConnection.this.flushingMessages.isEmpty()) {
                            ServerSentEventConnection.this.sink.resumeWrites();
                            return;
                        }
                        if (!buffer.hasRemaining()) {
                            ServerSentEventConnection.this.fillBuffer();
                            if (ServerSentEventConnection.this.pooled != null) continue;
                            return;
                        }
                        if (res != 0) continue;
                        ServerSentEventConnection.this.sink.resumeWrites();
                        return;
                    } while (res > 0);
                }
                catch (IOException e2) {
                    ServerSentEventConnection.this.handleException(e2);
                }
            }
        }
    }

    private static class SSEData {
        final String event;
        final String data;
        final String id;
        final long retry;
        final EventCallback callback;
        private int endBufferPosition = -1;
        private byte[] leftOverData;
        private int leftOverDataOffset;

        private SSEData(String event, String data2, String id, EventCallback callback) {
            this.event = event;
            this.data = data2;
            this.id = id;
            this.callback = callback;
            this.retry = -1L;
        }

        private SSEData(long retry, EventCallback callback) {
            this.event = null;
            this.data = null;
            this.id = null;
            this.callback = callback;
            this.retry = retry;
        }

        static /* synthetic */ byte[] access$1202(SSEData x0, byte[] x1) {
            x0.leftOverData = x1;
            return x1;
        }
    }

    public static interface EventCallback {
        public void done(ServerSentEventConnection var1, String var2, String var3, String var4);

        public void failed(ServerSentEventConnection var1, String var2, String var3, String var4, IOException var5);
    }
}

