/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.session;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionConfig;
import java.util.Deque;
import java.util.Locale;

public class PathParameterSessionConfig
implements SessionConfig {
    private final String name;

    public PathParameterSessionConfig(String name2) {
        this.name = name2;
    }

    public PathParameterSessionConfig() {
        this("JSESSIONID".toLowerCase(Locale.ENGLISH));
    }

    @Override
    public void setSessionId(HttpServerExchange exchange, String sessionId) {
        exchange.getPathParameters().remove(this.name);
        exchange.addPathParam(this.name, sessionId);
        UndertowLogger.SESSION_LOGGER.tracef("Setting path parameter session id %s on %s", (Object)sessionId, (Object)exchange);
    }

    @Override
    public void clearSession(HttpServerExchange exchange, String sessionId) {
        UndertowLogger.SESSION_LOGGER.tracef("Clearing path parameter session id %s on %s", (Object)sessionId, (Object)exchange);
        exchange.getPathParameters().remove(this.name);
    }

    @Override
    public String findSessionId(HttpServerExchange exchange) {
        Deque<String> stringDeque = exchange.getPathParameters().get(this.name);
        if (stringDeque == null) {
            return null;
        }
        UndertowLogger.SESSION_LOGGER.tracef("Found path parameter session id %s on %s", (Object)stringDeque.getFirst(), (Object)exchange);
        return stringDeque.getFirst();
    }

    @Override
    public SessionConfig.SessionCookieSource sessionCookieSource(HttpServerExchange exchange) {
        return this.findSessionId(exchange) != null ? SessionConfig.SessionCookieSource.URL : SessionConfig.SessionCookieSource.NONE;
    }

    @Override
    public String rewriteUrl(String url, String sessionId) {
        int pound;
        if (url == null || sessionId == null) {
            return url;
        }
        String path2 = url;
        String query = "";
        String anchor = "";
        int question = url.indexOf(63);
        if (question >= 0) {
            path2 = url.substring(0, question);
            query = url.substring(question);
        }
        if ((pound = path2.indexOf(35)) >= 0) {
            anchor = path2.substring(pound);
            path2 = path2.substring(0, pound);
        }
        StringBuilder sb = new StringBuilder();
        int paramIndex = path2.indexOf(";" + this.name);
        if (paramIndex >= 0) {
            sb.append(path2.substring(0, paramIndex));
            String remainder = path2.substring(paramIndex + this.name.length() + 1);
            int endIndex1 = remainder.indexOf(";");
            int endIndex2 = remainder.indexOf("/");
            if (endIndex1 != -1) {
                if (endIndex2 != -1 && endIndex2 < endIndex1) {
                    sb.append(remainder.substring(endIndex2));
                } else {
                    sb.append(remainder.substring(endIndex1));
                }
            } else if (endIndex2 != -1) {
                sb.append(remainder.substring(endIndex2));
            }
        } else {
            sb.append(path2);
        }
        sb.append(';');
        sb.append(this.name);
        sb.append('=');
        sb.append(sessionId);
        sb.append(anchor);
        sb.append(query);
        UndertowLogger.SESSION_LOGGER.tracef("Rewrote URL from %s to %s", (Object)url, (Object)sb);
        return sb.toString();
    }
}

