/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.compat.rewrite;

import io.undertow.server.handlers.resource.Resource;
import io.undertow.servlet.compat.rewrite.Resolver;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.util.DateUtils;
import java.io.IOException;
import java.util.Calendar;
import javax.servlet.http.HttpServletRequest;

public class UndertowResolver
extends Resolver {
    private final ServletRequestContext servletRequestContext;
    private final HttpServletRequest request;

    public UndertowResolver(ServletRequestContext servletRequestContext, HttpServletRequest request) {
        this.servletRequestContext = servletRequestContext;
        this.request = request;
    }

    @Override
    public String resolve(String key2) {
        if (key2.equals("HTTP_USER_AGENT")) {
            return this.request.getHeader("user-agent");
        }
        if (key2.equals("HTTP_REFERER")) {
            return this.request.getHeader("referer");
        }
        if (key2.equals("HTTP_COOKIE")) {
            return this.request.getHeader("cookie");
        }
        if (key2.equals("HTTP_FORWARDED")) {
            return this.request.getHeader("forwarded");
        }
        if (key2.equals("HTTP_HOST")) {
            int index2;
            String host = this.request.getHeader("host");
            int n = index2 = host != null ? host.indexOf(58) : -1;
            if (index2 != -1) {
                host = host.substring(0, index2);
            }
            return host;
        }
        if (key2.equals("HTTP_PROXY_CONNECTION")) {
            return this.request.getHeader("proxy-connection");
        }
        if (key2.equals("HTTP_ACCEPT")) {
            return this.request.getHeader("accept");
        }
        if (key2.equals("REMOTE_ADDR")) {
            return this.request.getRemoteAddr();
        }
        if (key2.equals("REMOTE_HOST")) {
            return this.request.getRemoteHost();
        }
        if (key2.equals("REMOTE_PORT")) {
            return String.valueOf(this.request.getRemotePort());
        }
        if (key2.equals("REMOTE_USER")) {
            return this.request.getRemoteUser();
        }
        if (key2.equals("REMOTE_IDENT")) {
            return this.request.getRemoteUser();
        }
        if (key2.equals("REQUEST_METHOD")) {
            return this.request.getMethod();
        }
        if (key2.equals("SCRIPT_FILENAME")) {
            return this.request.getRealPath(this.request.getServletPath());
        }
        if (key2.equals("REQUEST_PATH")) {
            return this.servletRequestContext.getExchange().getRelativePath();
        }
        if (key2.equals("CONTEXT_PATH")) {
            return this.request.getContextPath();
        }
        if (key2.equals("SERVLET_PATH")) {
            return UndertowResolver.emptyStringIfNull(this.request.getServletPath());
        }
        if (key2.equals("PATH_INFO")) {
            return UndertowResolver.emptyStringIfNull(this.request.getPathInfo());
        }
        if (key2.equals("QUERY_STRING")) {
            return UndertowResolver.emptyStringIfNull(this.request.getQueryString());
        }
        if (key2.equals("AUTH_TYPE")) {
            return this.request.getAuthType();
        }
        if (key2.equals("DOCUMENT_ROOT")) {
            return this.request.getRealPath("/");
        }
        if (key2.equals("SERVER_NAME")) {
            return this.request.getLocalName();
        }
        if (key2.equals("SERVER_ADDR")) {
            return this.request.getLocalAddr();
        }
        if (key2.equals("SERVER_PORT")) {
            return String.valueOf(this.request.getLocalPort());
        }
        if (key2.equals("SERVER_PROTOCOL")) {
            return this.request.getProtocol();
        }
        if (key2.equals("SERVER_SOFTWARE")) {
            return "tomcat";
        }
        if (key2.equals("THE_REQUEST")) {
            return this.request.getMethod() + " " + this.request.getRequestURI() + " " + this.request.getProtocol();
        }
        if (key2.equals("REQUEST_URI")) {
            return this.request.getRequestURI();
        }
        if (key2.equals("REQUEST_FILENAME")) {
            return this.request.getPathTranslated();
        }
        if (key2.equals("HTTPS")) {
            return this.request.isSecure() ? "on" : "off";
        }
        if (key2.equals("TIME_YEAR")) {
            return String.valueOf(Calendar.getInstance().get(1));
        }
        if (key2.equals("TIME_MON")) {
            return String.valueOf(Calendar.getInstance().get(2));
        }
        if (key2.equals("TIME_DAY")) {
            return String.valueOf(Calendar.getInstance().get(5));
        }
        if (key2.equals("TIME_HOUR")) {
            return String.valueOf(Calendar.getInstance().get(11));
        }
        if (key2.equals("TIME_MIN")) {
            return String.valueOf(Calendar.getInstance().get(12));
        }
        if (key2.equals("TIME_SEC")) {
            return String.valueOf(Calendar.getInstance().get(13));
        }
        if (key2.equals("TIME_WDAY")) {
            return String.valueOf(Calendar.getInstance().get(7));
        }
        if (key2.equals("TIME")) {
            return DateUtils.getCurrentDateTime(this.servletRequestContext.getExchange());
        }
        return null;
    }

    @Override
    public String resolveEnv(String key2) {
        Object result = this.request.getAttribute(key2);
        return result != null ? result.toString() : System.getProperty(key2);
    }

    @Override
    public String resolveSsl(String key2) {
        return null;
    }

    @Override
    public String resolveHttp(String key2) {
        return this.request.getHeader(key2);
    }

    @Override
    public boolean resolveResource(int type2, String name2) {
        Resource resource2;
        try {
            resource2 = this.servletRequestContext.getDeployment().getDeploymentInfo().getResourceManager().getResource(name2);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        switch (type2) {
            case 0: {
                return resource2 == null;
            }
            case 1: {
                return resource2 != null;
            }
            case 2: {
                return resource2 != null && resource2.getContentLength() > 0L;
            }
        }
        return false;
    }

    private static String emptyStringIfNull(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }
}

