/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.server.HttpHandler;
import io.undertow.server.session.Session;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.handlers.ServletInitialHandler;
import io.undertow.servlet.handlers.ServletPathMatches;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpSessionImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.servlet.ServletContext;

final class SecurityActions {
    private SecurityActions() {
    }

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static void setContextClassLoader(final ClassLoader classLoader) {
        if (System.getSecurityManager() == null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    return null;
                }
            });
        }
    }

    static String getSystemProperty(final String prop) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(prop);
        }
        return (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return System.getProperty(prop);
            }
        });
    }

    static HttpSessionImpl forSession(final Session session, final ServletContext servletContext, final boolean newSession) {
        if (System.getSecurityManager() == null) {
            return HttpSessionImpl.forSession(session, servletContext, newSession);
        }
        return AccessController.doPrivileged(new PrivilegedAction<HttpSessionImpl>(){

            @Override
            public HttpSessionImpl run() {
                return HttpSessionImpl.forSession(session, servletContext, newSession);
            }
        });
    }

    static ServletRequestContext currentServletRequestContext() {
        if (System.getSecurityManager() == null) {
            return ServletRequestContext.current();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ServletRequestContext>(){

            @Override
            public ServletRequestContext run() {
                return ServletRequestContext.current();
            }
        });
    }

    static void setCurrentRequestContext(final ServletRequestContext servletRequestContext) {
        if (System.getSecurityManager() == null) {
            ServletRequestContext.setCurrentRequestContext(servletRequestContext);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    ServletRequestContext.setCurrentRequestContext(servletRequestContext);
                    return null;
                }
            });
        }
    }

    static void clearCurrentServletAttachments() {
        if (System.getSecurityManager() == null) {
            ServletRequestContext.clearCurrentServletAttachments();
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    ServletRequestContext.clearCurrentServletAttachments();
                    return null;
                }
            });
        }
    }

    static ServletRequestContext requireCurrentServletRequestContext() {
        if (System.getSecurityManager() == null) {
            return ServletRequestContext.requireCurrent();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ServletRequestContext>(){

            @Override
            public ServletRequestContext run() {
                return ServletRequestContext.requireCurrent();
            }
        });
    }

    static ServletInitialHandler createServletInitialHandler(final ServletPathMatches paths, final HttpHandler next2, final Deployment deployment, final ServletContextImpl servletContext) {
        if (System.getSecurityManager() == null) {
            return new ServletInitialHandler(paths, next2, deployment, servletContext);
        }
        return AccessController.doPrivileged(new PrivilegedAction<ServletInitialHandler>(){

            @Override
            public ServletInitialHandler run() {
                return new ServletInitialHandler(paths, next2, deployment, servletContext);
            }
        });
    }
}

