/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.cache.LRUCache;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.FilterMappingInfo;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.core.ManagedFilter;
import io.undertow.servlet.core.ManagedFilters;
import io.undertow.servlet.core.ManagedServlet;
import io.undertow.servlet.core.ManagedServlets;
import io.undertow.servlet.handlers.DefaultServlet;
import io.undertow.servlet.handlers.FilterHandler;
import io.undertow.servlet.handlers.ServletChain;
import io.undertow.servlet.handlers.ServletHandler;
import io.undertow.servlet.handlers.ServletPathMatch;
import io.undertow.servlet.handlers.ServletPathMatchesData;
import io.undertow.servlet.handlers.security.ServletSecurityRoleHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.http.MappingMatch;

public class ServletPathMatches {
    public static final String DEFAULT_SERVLET_NAME = "default";
    private final Deployment deployment;
    private volatile String[] welcomePages;
    private final ResourceManager resourceManager;
    private volatile ServletPathMatchesData data;
    private final LRUCache<String, ServletPathMatch> pathMatchCache = new LRUCache(1000, -1, true);

    public ServletPathMatches(Deployment deployment) {
        this.deployment = deployment;
        this.welcomePages = deployment.getDeploymentInfo().getWelcomePages().toArray(new String[deployment.getDeploymentInfo().getWelcomePages().size()]);
        this.resourceManager = deployment.getDeploymentInfo().getResourceManager();
    }

    public void initData() {
        this.getData();
    }

    public ServletChain getServletHandlerByName(String name2) {
        return this.getData().getServletHandlerByName(name2);
    }

    public ServletPathMatch getServletHandlerByPath(String path2) {
        ServletPathMatch existing = this.pathMatchCache.get(path2);
        if (existing != null) {
            return existing;
        }
        ServletPathMatch match = this.getData().getServletHandlerByPath(path2);
        if (!match.isRequiredWelcomeFileMatch()) {
            this.pathMatchCache.add(path2, match);
            return match;
        }
        try {
            String remaining = match.getRemaining() == null ? match.getMatched() : match.getRemaining();
            Resource resource2 = this.resourceManager.getResource(remaining);
            if (resource2 == null || !resource2.isDirectory()) {
                this.pathMatchCache.add(path2, match);
                return match;
            }
            boolean pathEndsWithSlash = remaining.endsWith("/");
            String pathWithTrailingSlash = pathEndsWithSlash ? remaining : remaining + "/";
            ServletPathMatch welcomePage = this.findWelcomeFile(pathWithTrailingSlash, !pathEndsWithSlash);
            if (welcomePage != null) {
                this.pathMatchCache.add(path2, welcomePage);
                return welcomePage;
            }
            welcomePage = this.findWelcomeServlet(pathWithTrailingSlash, !pathEndsWithSlash);
            if (welcomePage != null) {
                this.pathMatchCache.add(path2, welcomePage);
                return welcomePage;
            }
            if (pathEndsWithSlash) {
                this.pathMatchCache.add(path2, match);
                return match;
            }
            ServletPathMatch redirect = new ServletPathMatch(match.getServletChain(), match.getMatched(), match.getRemaining(), ServletPathMatch.Type.REDIRECT, "/");
            this.pathMatchCache.add(path2, redirect);
            return redirect;
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public void invalidate() {
        this.data = null;
        this.pathMatchCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServletPathMatchesData getData() {
        ServletPathMatchesData data2 = this.data;
        if (data2 != null) {
            return data2;
        }
        ServletPathMatches servletPathMatches = this;
        synchronized (servletPathMatches) {
            if (this.data != null) {
                return this.data;
            }
            this.data = this.setupServletChains();
            return this.data;
        }
    }

    private ServletPathMatch findWelcomeFile(String path2, boolean requiresRedirect) {
        if (File.separatorChar != '/' && path2.contains(File.separator)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String i : this.welcomePages) {
            try {
                sb.append(path2);
                sb.append(i);
                String mergedPath = sb.toString();
                sb.setLength(0);
                Resource resource2 = this.resourceManager.getResource(mergedPath);
                if (resource2 == null) continue;
                ServletPathMatch handler = this.data.getServletHandlerByPath(mergedPath);
                return new ServletPathMatch(handler.getServletChain(), mergedPath, null, requiresRedirect ? ServletPathMatch.Type.REDIRECT : ServletPathMatch.Type.REWRITE, mergedPath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private ServletPathMatch findWelcomeServlet(String path2, boolean requiresRedirect) {
        StringBuilder sb = new StringBuilder();
        for (String i : this.welcomePages) {
            sb.append(path2);
            sb.append(i);
            String mergedPath = sb.toString();
            sb.setLength(0);
            ServletPathMatch handler = this.data.getServletHandlerByPath(mergedPath);
            if (handler == null || handler.isRequiredWelcomeFileMatch()) continue;
            return new ServletPathMatch(handler.getServletChain(), handler.getMatched(), handler.getRemaining(), requiresRedirect ? ServletPathMatch.Type.REDIRECT : ServletPathMatch.Type.REWRITE, mergedPath);
        }
        return null;
    }

    public void setWelcomePages(List<String> welcomePages) {
        this.welcomePages = welcomePages.toArray(new String[welcomePages.size()]);
    }

    /*
     * WARNING - void declaration
     */
    private ServletPathMatchesData setupServletChains() {
        ServletHandler defaultServlet = null;
        ManagedServlets servlets = this.deployment.getServlets();
        ManagedFilters filters = this.deployment.getFilters();
        HashMap<String, ServletHandler> extensionServlets = new HashMap<String, ServletHandler>();
        HashMap<String, ServletHandler> pathServlets = new HashMap<String, ServletHandler>();
        HashSet<String> pathMatches = new HashSet<String>();
        HashSet<String> extensionMatches = new HashSet<String>();
        DeploymentInfo deploymentInfo = this.deployment.getDeploymentInfo();
        for (FilterMappingInfo filterMappingInfo : deploymentInfo.getFilterMappings()) {
            if (filterMappingInfo.getMappingType() != FilterMappingInfo.MappingType.URL) continue;
            String path2 = filterMappingInfo.getMapping();
            if (path2.equals("*")) {
                path2 = "/*";
            }
            if (!path2.startsWith("*.")) {
                pathMatches.add(path2);
                continue;
            }
            extensionMatches.add(path2.substring(2));
        }
        for (Map.Entry entry : servlets.getServletHandlers().entrySet()) {
            ServletHandler handler = (ServletHandler)entry.getValue();
            for (String path3 : handler.getManagedServlet().getServletInfo().getMappings()) {
                if (path3.equals("/")) {
                    pathMatches.add("/*");
                    if (defaultServlet != null) {
                        throw UndertowServletMessages.MESSAGES.twoServletsWithSameMapping(path3);
                    }
                    defaultServlet = handler;
                    continue;
                }
                if (!path3.startsWith("*.")) {
                    if (path3.isEmpty()) {
                        path3 = "/";
                    }
                    pathMatches.add(path3);
                    if (pathServlets.containsKey(path3)) {
                        throw UndertowServletMessages.MESSAGES.twoServletsWithSameMapping(path3);
                    }
                    pathServlets.put(path3, handler);
                    continue;
                }
                String ext = path3.substring(2);
                extensionMatches.add(ext);
                if (extensionServlets.containsKey(ext)) {
                    throw UndertowServletMessages.MESSAGES.twoServletsWithSameMapping(path3);
                }
                extensionServlets.put(ext, handler);
            }
        }
        ServletHandler managedDefaultServlet = servlets.getServletHandler(DEFAULT_SERVLET_NAME);
        if (managedDefaultServlet == null) {
            managedDefaultServlet = servlets.addServlet(new ServletInfo(DEFAULT_SERVLET_NAME, DefaultServlet.class));
        }
        if (defaultServlet == null) {
            pathMatches.add("/*");
            defaultServlet = managedDefaultServlet;
        }
        ServletPathMatchesData.Builder builder = ServletPathMatchesData.builder();
        for (String string2 : pathMatches) {
            void var17_32;
            MatchData targetServletMatch = ServletPathMatches.resolveServletForPath(string2, pathServlets, extensionServlets, defaultServlet);
            EnumMap<DispatcherType, List<ManagedFilter>> noExtension = new EnumMap<DispatcherType, List<ManagedFilter>>(DispatcherType.class);
            HashMap extension = new HashMap();
            for (String string3 : extensionMatches) {
                extension.put(string3, new EnumMap(DispatcherType.class));
            }
            for (FilterMappingInfo filterMappingInfo : deploymentInfo.getFilterMappings()) {
                ManagedFilter filter2 = filters.getManagedFilter(filterMappingInfo.getFilterName());
                if (filterMappingInfo.getMappingType() == FilterMappingInfo.MappingType.SERVLET) {
                    if (targetServletMatch.handler != null && (filterMappingInfo.getMapping().equals(targetServletMatch.handler.getManagedServlet().getServletInfo().getName()) || filterMappingInfo.getMapping().equals("*"))) {
                        ServletPathMatches.addToListMap(noExtension, filterMappingInfo.getDispatcher(), filter2);
                    }
                    for (Map.Entry entry : extension.entrySet()) {
                        ServletHandler pathServlet = targetServletMatch.handler;
                        boolean defaultServletMatch = targetServletMatch.defaultServlet;
                        if (defaultServletMatch && extensionServlets.containsKey(entry.getKey())) {
                            pathServlet = (ServletHandler)extensionServlets.get(entry.getKey());
                        }
                        if (!filterMappingInfo.getMapping().equals(pathServlet.getManagedServlet().getServletInfo().getName()) && !filterMappingInfo.getMapping().equals("*")) continue;
                        ServletPathMatches.addToListMap((Map)extension.get(entry.getKey()), filterMappingInfo.getDispatcher(), filter2);
                    }
                    continue;
                }
                if (filterMappingInfo.getMapping().isEmpty() || !filterMappingInfo.getMapping().startsWith("*.")) {
                    if (!ServletPathMatches.isFilterApplicable(string2, filterMappingInfo.getMapping())) continue;
                    ServletPathMatches.addToListMap(noExtension, filterMappingInfo.getDispatcher(), filter2);
                    for (Map l : extension.values()) {
                        ServletPathMatches.addToListMap(l, filterMappingInfo.getDispatcher(), filter2);
                    }
                    continue;
                }
                ServletPathMatches.addToListMap((Map)extension.get(filterMappingInfo.getMapping().substring(2)), filterMappingInfo.getDispatcher(), filter2);
            }
            if (string2.endsWith("/*")) {
                String prefix = string2.substring(0, string2.length() - 2);
                builder.addPrefixMatch(prefix, this.createHandler(deploymentInfo, targetServletMatch.handler, noExtension, targetServletMatch.matchedPath, targetServletMatch.defaultServlet, targetServletMatch.mappingMatch, targetServletMatch.userPath), targetServletMatch.defaultServlet || targetServletMatch.handler.getManagedServlet().getServletInfo().isRequireWelcomeFileMapping());
                for (Map.Entry entry : extension.entrySet()) {
                    ServletHandler pathServlet = targetServletMatch.handler;
                    String pathMatch = targetServletMatch.matchedPath;
                    boolean defaultServletMatch = targetServletMatch.defaultServlet;
                    if (defaultServletMatch && extensionServlets.containsKey(entry.getKey())) {
                        defaultServletMatch = false;
                        pathServlet = (ServletHandler)extensionServlets.get(entry.getKey());
                    }
                    HttpHandler handler = pathServlet;
                    if (!((Map)entry.getValue()).isEmpty()) {
                        handler = new FilterHandler((Map)entry.getValue(), deploymentInfo.isAllowNonStandardWrappers(), handler);
                    }
                    builder.addExtensionMatch(prefix, (String)entry.getKey(), ServletPathMatches.servletChain(handler, pathServlet.getManagedServlet(), (Map)entry.getValue(), pathMatch, deploymentInfo, defaultServletMatch, defaultServletMatch ? MappingMatch.DEFAULT : MappingMatch.EXTENSION, defaultServletMatch ? "/" : "*." + (String)entry.getKey()));
                }
                continue;
            }
            if (string2.isEmpty()) {
                builder.addExactMatch("/", this.createHandler(deploymentInfo, targetServletMatch.handler, noExtension, targetServletMatch.matchedPath, targetServletMatch.defaultServlet, targetServletMatch.mappingMatch, targetServletMatch.userPath));
                continue;
            }
            int lastSegmentIndex = string2.lastIndexOf(47);
            if (lastSegmentIndex > 0) {
                String string4 = string2.substring(lastSegmentIndex);
            } else {
                String string5 = string2;
            }
            if (var17_32.contains(".")) {
                String ext = var17_32.substring(var17_32.lastIndexOf(46) + 1);
                if (extension.containsKey(ext)) {
                    Map extMap = (Map)extension.get(ext);
                    builder.addExactMatch(string2, this.createHandler(deploymentInfo, targetServletMatch.handler, extMap, targetServletMatch.matchedPath, targetServletMatch.defaultServlet, targetServletMatch.mappingMatch, targetServletMatch.userPath));
                    continue;
                }
                builder.addExactMatch(string2, this.createHandler(deploymentInfo, targetServletMatch.handler, noExtension, targetServletMatch.matchedPath, targetServletMatch.defaultServlet, targetServletMatch.mappingMatch, targetServletMatch.userPath));
                continue;
            }
            builder.addExactMatch(string2, this.createHandler(deploymentInfo, targetServletMatch.handler, noExtension, targetServletMatch.matchedPath, targetServletMatch.defaultServlet, targetServletMatch.mappingMatch, targetServletMatch.userPath));
        }
        for (Map.Entry entry : servlets.getServletHandlers().entrySet()) {
            EnumMap<DispatcherType, List<ManagedFilter>> filtersByDispatcher = new EnumMap<DispatcherType, List<ManagedFilter>>(DispatcherType.class);
            for (FilterMappingInfo filterMapping : deploymentInfo.getFilterMappings()) {
                ManagedFilter filter3 = filters.getManagedFilter(filterMapping.getFilterName());
                if (filterMapping.getMappingType() != FilterMappingInfo.MappingType.SERVLET || !filterMapping.getMapping().equals(entry.getKey())) continue;
                ServletPathMatches.addToListMap(filtersByDispatcher, filterMapping.getDispatcher(), filter3);
            }
            if (filtersByDispatcher.isEmpty()) {
                builder.addNameMatch((String)entry.getKey(), ServletPathMatches.servletChain((HttpHandler)entry.getValue(), ((ServletHandler)entry.getValue()).getManagedServlet(), filtersByDispatcher, null, deploymentInfo, false, MappingMatch.EXACT, ""));
                continue;
            }
            builder.addNameMatch((String)entry.getKey(), ServletPathMatches.servletChain(new FilterHandler(filtersByDispatcher, deploymentInfo.isAllowNonStandardWrappers(), (HttpHandler)entry.getValue()), ((ServletHandler)entry.getValue()).getManagedServlet(), filtersByDispatcher, null, deploymentInfo, false, MappingMatch.EXACT, ""));
        }
        return builder.build();
    }

    private ServletChain createHandler(DeploymentInfo deploymentInfo, ServletHandler targetServlet, Map<DispatcherType, List<ManagedFilter>> noExtension, String servletPath, boolean defaultServlet, MappingMatch mappingMatch, String pattern) {
        ServletChain initialHandler;
        if (noExtension.isEmpty()) {
            initialHandler = ServletPathMatches.servletChain(targetServlet, targetServlet.getManagedServlet(), noExtension, servletPath, deploymentInfo, defaultServlet, mappingMatch, pattern);
        } else {
            FilterHandler handler = new FilterHandler(noExtension, deploymentInfo.isAllowNonStandardWrappers(), targetServlet);
            initialHandler = ServletPathMatches.servletChain(handler, targetServlet.getManagedServlet(), noExtension, servletPath, deploymentInfo, defaultServlet, mappingMatch, pattern);
        }
        return initialHandler;
    }

    private static MatchData resolveServletForPath(String path2, Map<String, ServletHandler> pathServlets, Map<String, ServletHandler> extensionServlets, ServletHandler defaultServlet) {
        String ext;
        if (pathServlets.containsKey(path2)) {
            if (path2.endsWith("/*")) {
                String base = path2.substring(0, path2.length() - 2);
                return new MatchData(pathServlets.get(path2), base, path2, MappingMatch.PATH, false);
            }
            if (path2.equals("/")) {
                return new MatchData(pathServlets.get(path2), path2, "", MappingMatch.CONTEXT_ROOT, false);
            }
            return new MatchData(pathServlets.get(path2), path2, path2, MappingMatch.EXACT, false);
        }
        String match = null;
        ServletHandler servlet = null;
        String userPath = "";
        for (Map.Entry<String, ServletHandler> entry : pathServlets.entrySet()) {
            String key2 = entry.getKey();
            if (!key2.endsWith("/*")) continue;
            String base = key2.substring(0, key2.length() - 1);
            if (match != null && base.length() <= match.length() || !path2.startsWith(base) && !path2.equals(base.substring(0, base.length() - 1))) continue;
            match = base.substring(0, base.length() - 1);
            servlet = entry.getValue();
            userPath = key2;
        }
        if (servlet != null) {
            return new MatchData(servlet, match, userPath, MappingMatch.PATH, false);
        }
        int index2 = path2.lastIndexOf(46);
        if (index2 != -1 && (servlet = extensionServlets.get(ext = path2.substring(index2 + 1))) != null) {
            return new MatchData(servlet, null, "*." + ext, MappingMatch.EXTENSION, false);
        }
        return new MatchData(defaultServlet, null, "/", MappingMatch.DEFAULT, true);
    }

    private static boolean isFilterApplicable(String path2, String filterPath) {
        String modifiedPath = filterPath.equals("*") ? "/*" : filterPath;
        if (path2.isEmpty()) {
            return modifiedPath.equals("/*") || modifiedPath.equals("/");
        }
        if (modifiedPath.endsWith("/*")) {
            String baseFilterPath = modifiedPath.substring(0, modifiedPath.length() - 1);
            String exactFilterPath = modifiedPath.substring(0, modifiedPath.length() - 2);
            return path2.startsWith(baseFilterPath) || path2.equals(exactFilterPath);
        }
        return modifiedPath.equals(path2);
    }

    private static <K, V> void addToListMap(Map<K, List<V>> map2, K key2, V value) {
        List<V> list = map2.get(key2);
        if (list == null) {
            list = new ArrayList<V>();
            map2.put(key2, list);
        }
        list.add(value);
    }

    private static ServletChain servletChain(HttpHandler next2, ManagedServlet managedServlet, Map<DispatcherType, List<ManagedFilter>> filters, String servletPath, DeploymentInfo deploymentInfo, boolean defaultServlet, MappingMatch mappingMatch, String pattern) {
        HttpHandler servletHandler = next2;
        if (!deploymentInfo.isSecurityDisabled()) {
            servletHandler = new ServletSecurityRoleHandler(servletHandler, deploymentInfo.getAuthorizationManager());
        }
        servletHandler = ServletPathMatches.wrapHandlers(servletHandler, managedServlet.getServletInfo().getHandlerChainWrappers());
        return new ServletChain(servletHandler, managedServlet, servletPath, defaultServlet, mappingMatch, pattern, filters);
    }

    private static HttpHandler wrapHandlers(HttpHandler wrapee, List<HandlerWrapper> wrappers) {
        HttpHandler current = wrapee;
        for (HandlerWrapper wrapper : wrappers) {
            current = wrapper.wrap(current);
        }
        return current;
    }

    private static class MatchData {
        final ServletHandler handler;
        final String matchedPath;
        final String userPath;
        final MappingMatch mappingMatch;
        final boolean defaultServlet;

        private MatchData(ServletHandler handler, String matchedPath, String userPath, MappingMatch mappingMatch, boolean defaultServlet) {
            this.handler = handler;
            this.matchedPath = matchedPath;
            this.userPath = userPath;
            this.mappingMatch = mappingMatch;
            this.defaultServlet = defaultServlet;
        }
    }
}

