/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.server.ServerConnection;
import io.undertow.server.handlers.Cookie;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import javax.servlet.http.PushBuilder;

public class PushBuilderImpl
implements PushBuilder {
    private static final Set<HttpString> IGNORE;
    private static final Set<HttpString> CONDITIONAL;
    private static final Set<String> INVALID_METHOD;
    private final HttpServletRequestImpl servletRequest;
    private String method;
    private String queryString;
    private String sessionId;
    private final HeaderMap headers = new HeaderMap();
    private String path;

    public PushBuilderImpl(HttpServletRequestImpl servletRequest) {
        this.servletRequest = servletRequest;
        this.method = "GET";
        this.queryString = servletRequest.getQueryString();
        HttpSession session = servletRequest.getSession(false);
        this.sessionId = session != null ? session.getId() : servletRequest.getRequestedSessionId();
        for (HeaderValues headerValues : servletRequest.getExchange().getRequestHeaders()) {
            if (IGNORE.contains(headerValues.getHeaderName())) continue;
            this.headers.addAll(headerValues.getHeaderName(), headerValues);
        }
        if (servletRequest.getQueryString() == null) {
            this.headers.add(Headers.REFERER, servletRequest.getRequestURL().toString());
        } else {
            this.headers.add(Headers.REFERER, servletRequest.getRequestURL() + "?" + servletRequest.getQueryString());
        }
        this.path = null;
        for (Map.Entry entry : servletRequest.getExchange().getResponseCookies().entrySet()) {
            if (((Cookie)entry.getValue()).getMaxAge() != null && ((Cookie)entry.getValue()).getMaxAge() <= 0) {
                HeaderValues existing = this.headers.get(Headers.COOKIE);
                if (existing == null) continue;
                Iterator<String> it = existing.iterator();
                while (it.hasNext()) {
                    String val2 = it.next();
                    if (!val2.startsWith((String)entry.getKey() + "=")) continue;
                    it.remove();
                }
                continue;
            }
            if (((String)entry.getKey()).equals(servletRequest.getServletContext().getSessionCookieConfig().getName())) continue;
            this.headers.add(Headers.COOKIE, (String)entry.getKey() + "=" + ((Cookie)entry.getValue()).getValue());
        }
    }

    @Override
    public PushBuilder method(String method) {
        if (method == null) {
            throw UndertowServletMessages.MESSAGES.paramCannotBeNullNPE("method");
        }
        if (INVALID_METHOD.contains(method)) {
            throw UndertowServletMessages.MESSAGES.invalidMethodForPushRequest(method);
        }
        this.method = method;
        return this;
    }

    @Override
    public PushBuilder queryString(String queryString) {
        this.queryString = queryString;
        return this;
    }

    @Override
    public PushBuilder sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @Override
    public PushBuilder setHeader(String name2, String value) {
        this.headers.put(new HttpString(name2), value);
        return this;
    }

    @Override
    public PushBuilder addHeader(String name2, String value) {
        this.headers.add(new HttpString(name2), value);
        return this;
    }

    @Override
    public PushBuilder removeHeader(String name2) {
        this.headers.remove(name2);
        return this;
    }

    @Override
    public PushBuilder path(String path2) {
        this.path = path2;
        return this;
    }

    @Override
    public void push() {
        if (this.path == null) {
            throw UndertowServletMessages.MESSAGES.pathWasNotSet();
        }
        ServerConnection con = this.servletRequest.getExchange().getConnection();
        if (con.isPushSupported()) {
            String path2;
            HeaderMap newHeaders = new HeaderMap();
            for (HeaderValues entry : this.headers) {
                newHeaders.addAll(entry.getHeaderName(), entry);
            }
            if (this.sessionId != null) {
                newHeaders.put(Headers.COOKIE, "JSESSIONID=" + this.sessionId);
            }
            if (!(path2 = this.path).startsWith("/")) {
                path2 = this.servletRequest.getContextPath() + "/" + path2;
            }
            if (this.queryString != null && !this.queryString.isEmpty()) {
                path2 = path2.contains("?") ? path2 + "&" + this.queryString : path2 + "?" + this.queryString;
            }
            con.pushResource(path2, new HttpString(this.method), newHeaders);
        }
        this.path = null;
        for (HttpString h : CONDITIONAL) {
            this.headers.remove(h);
        }
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public Set<String> getHeaderNames() {
        HashSet<String> names = new HashSet<String>();
        for (HeaderValues name2 : this.headers) {
            names.add(name2.getHeaderName().toString());
        }
        return names;
    }

    @Override
    public String getHeader(String name2) {
        return this.headers.getFirst(name2);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    static {
        HashSet<HttpString> ignore = new HashSet<HttpString>();
        ignore.add(Headers.IF_MATCH);
        ignore.add(Headers.IF_NONE_MATCH);
        ignore.add(Headers.IF_MODIFIED_SINCE);
        ignore.add(Headers.IF_UNMODIFIED_SINCE);
        ignore.add(Headers.IF_RANGE);
        ignore.add(Headers.RANGE);
        ignore.add(Headers.ACCEPT_RANGES);
        ignore.add(Headers.EXPECT);
        ignore.add(Headers.REFERER);
        IGNORE = Collections.unmodifiableSet(ignore);
        HashSet<HttpString> conditional = new HashSet<HttpString>();
        conditional.add(Headers.IF_MATCH);
        conditional.add(Headers.IF_NONE_MATCH);
        conditional.add(Headers.IF_MODIFIED_SINCE);
        conditional.add(Headers.IF_UNMODIFIED_SINCE);
        conditional.add(Headers.IF_RANGE);
        CONDITIONAL = Collections.unmodifiableSet(conditional);
        HashSet<String> invalid = new HashSet<String>();
        invalid.add("OPTIONS");
        invalid.add("PUT");
        invalid.add("POST");
        invalid.add("DELETE");
        invalid.add("CONNECT");
        invalid.add("TRACE");
        invalid.add("");
        INVALID_METHOD = Collections.unmodifiableSet(invalid);
    }
}

