/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.connector.ByteBufferPool;
import io.undertow.servlet.spec.UpgradeServletInputStream;
import io.undertow.servlet.spec.UpgradeServletOutputStream;
import java.io.IOException;
import java.util.concurrent.Executor;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.WebConnection;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.StreamConnection;

public class WebConnectionImpl
implements WebConnection {
    private final StreamConnection channel;
    private final UpgradeServletOutputStream outputStream;
    private final UpgradeServletInputStream inputStream;
    private final Executor ioExecutor;

    public WebConnectionImpl(StreamConnection channel, ByteBufferPool bufferPool, Executor ioExecutor) {
        this.channel = channel;
        this.ioExecutor = ioExecutor;
        this.outputStream = new UpgradeServletOutputStream(channel.getSinkChannel(), ioExecutor);
        this.inputStream = new UpgradeServletInputStream(channel.getSourceChannel(), bufferPool, ioExecutor);
        channel.getCloseSetter().set((ChannelListener<? extends StreamConnection>)new ChannelListener<StreamConnection>(){

            @Override
            public void handleEvent(StreamConnection channel) {
                try {
                    WebConnectionImpl.this.close();
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
        });
    }

    @Override
    public ServletInputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    @Override
    public void close() throws Exception {
        try {
            this.outputStream.closeBlocking();
        }
        catch (Throwable throwable) {
            IoUtils.safeClose(this.inputStream, this.channel);
            throw throwable;
        }
        IoUtils.safeClose(this.inputStream, this.channel);
    }
}

