/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.util;

import io.undertow.servlet.UndertowServletLogger;
import io.undertow.servlet.api.SessionPersistenceManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class InMemorySessionPersistence
implements SessionPersistenceManager {
    private static final Map<String, Map<String, SessionEntry>> data = new ConcurrentHashMap<String, Map<String, SessionEntry>>();

    @Override
    public void persistSessions(String deploymentName, Map<String, SessionPersistenceManager.PersistentSession> sessionData) {
        try {
            HashMap<String, SessionEntry> serializedData = new HashMap<String, SessionEntry>();
            for (Map.Entry<String, SessionPersistenceManager.PersistentSession> sessionEntry : sessionData.entrySet()) {
                HashMap<String, byte[]> data2 = new HashMap<String, byte[]>();
                for (Map.Entry<String, Object> sessionAttribute : sessionEntry.getValue().getSessionData().entrySet()) {
                    try {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream(out);
                        objectOutputStream.writeObject(sessionAttribute.getValue());
                        objectOutputStream.close();
                        data2.put(sessionAttribute.getKey(), out.toByteArray());
                    }
                    catch (Exception e2) {
                        UndertowServletLogger.ROOT_LOGGER.failedToPersistSessionAttribute(sessionAttribute.getKey(), sessionAttribute.getValue(), sessionEntry.getKey(), e2);
                    }
                }
                serializedData.put(sessionEntry.getKey(), new SessionEntry(sessionEntry.getValue().getExpiration(), data2));
            }
            data.put(deploymentName, serializedData);
        }
        catch (Exception e3) {
            UndertowServletLogger.ROOT_LOGGER.failedToPersistSessions(e3);
        }
    }

    @Override
    public Map<String, SessionPersistenceManager.PersistentSession> loadSessionAttributes(String deploymentName, ClassLoader classLoader) {
        try {
            long time2 = System.currentTimeMillis();
            Map<String, SessionEntry> data2 = data.remove(deploymentName);
            if (data2 != null) {
                HashMap<String, SessionPersistenceManager.PersistentSession> ret = new HashMap<String, SessionPersistenceManager.PersistentSession>();
                for (Map.Entry<String, SessionEntry> sessionEntry : data2.entrySet()) {
                    if (sessionEntry.getValue().expiry.getTime() <= time2) continue;
                    HashMap<String, Object> session = new HashMap<String, Object>();
                    for (Map.Entry sessionAttribute : sessionEntry.getValue().data.entrySet()) {
                        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream((byte[])sessionAttribute.getValue()));
                        session.put((String)sessionAttribute.getKey(), in.readObject());
                    }
                    ret.put(sessionEntry.getKey(), new SessionPersistenceManager.PersistentSession(sessionEntry.getValue().expiry, session));
                }
                return ret;
            }
        }
        catch (Exception e2) {
            UndertowServletLogger.ROOT_LOGGER.failedtoLoadPersistentSessions(e2);
        }
        return null;
    }

    @Override
    public void clear(String deploymentName) {
    }

    static final class SessionEntry {
        private final Date expiry;
        private final Map<String, byte[]> data;

        private SessionEntry(Date expiry, Map<String, byte[]> data2) {
            this.expiry = expiry;
            this.data = data2;
        }
    }
}

