/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.websockets;

import io.undertow.connector.ByteBufferPool;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.HttpUpgradeListener;
import io.undertow.servlet.websockets.SecurityActions;
import io.undertow.util.AttachmentKey;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xnio.FinishedIoFuture;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.OptionMap;

public class ServletWebSocketHttpExchange
implements WebSocketHttpExchange {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final HttpServerExchange exchange;
    private final Set<WebSocketChannel> peerConnections;

    public ServletWebSocketHttpExchange(HttpServletRequest request, HttpServletResponse response, Set<WebSocketChannel> peerConnections) {
        this.request = request;
        this.response = response;
        this.peerConnections = peerConnections;
        this.exchange = SecurityActions.requireCurrentServletRequestContext().getOriginalRequest().getExchange();
    }

    @Override
    public <T> void putAttachment(AttachmentKey<T> key2, T value) {
        this.exchange.putAttachment(key2, value);
    }

    @Override
    public <T> T getAttachment(AttachmentKey<T> key2) {
        return this.exchange.getAttachment(key2);
    }

    @Override
    public String getRequestHeader(String headerName) {
        return this.request.getHeader(headerName);
    }

    @Override
    public Map<String, List<String>> getRequestHeaders() {
        TreeMap headers = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        Enumeration<String> headerNames = this.request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String header = headerNames.nextElement();
            Enumeration<String> theHeaders = this.request.getHeaders(header);
            ArrayList<String> vals2 = new ArrayList<String>();
            headers.put(header, vals2);
            while (theHeaders.hasMoreElements()) {
                vals2.add(theHeaders.nextElement());
            }
        }
        return Collections.unmodifiableMap(headers);
    }

    @Override
    public String getResponseHeader(String headerName) {
        return this.response.getHeader(headerName);
    }

    @Override
    public Map<String, List<String>> getResponseHeaders() {
        HashMap<String, ArrayList<String>> headers = new HashMap<String, ArrayList<String>>();
        Collection<String> headerNames = this.response.getHeaderNames();
        for (String header : headerNames) {
            headers.put(header, new ArrayList<String>(this.response.getHeaders(header)));
        }
        return Collections.unmodifiableMap(headers);
    }

    @Override
    public void setResponseHeaders(Map<String, List<String>> headers) {
        for (String string2 : this.response.getHeaderNames()) {
            this.response.setHeader(string2, null);
        }
        for (Map.Entry entry : headers.entrySet()) {
            for (String val2 : (List)entry.getValue()) {
                this.response.addHeader((String)entry.getKey(), val2);
            }
        }
    }

    @Override
    public void setResponseHeader(String headerName, String headerValue) {
        this.response.setHeader(headerName, headerValue);
    }

    @Override
    public void upgradeChannel(HttpUpgradeListener upgradeCallback) {
        this.exchange.upgradeChannel(upgradeCallback);
    }

    @Override
    public IoFuture<Void> sendData(ByteBuffer data2) {
        try {
            ServletOutputStream outputStream = this.response.getOutputStream();
            while (data2.hasRemaining()) {
                outputStream.write(data2.get());
            }
            return new FinishedIoFuture<Object>(null);
        }
        catch (IOException e2) {
            FutureResult ioFuture = new FutureResult();
            ioFuture.setException(e2);
            return ioFuture.getIoFuture();
        }
    }

    @Override
    public IoFuture<byte[]> readRequestData() {
        ByteArrayOutputStream data2 = new ByteArrayOutputStream();
        try {
            int r;
            ServletInputStream in = this.request.getInputStream();
            byte[] buf = new byte[1024];
            while ((r = in.read(buf)) != -1) {
                data2.write(buf, 0, r);
            }
            return new FinishedIoFuture<byte[]>(data2.toByteArray());
        }
        catch (IOException e2) {
            FutureResult ioFuture = new FutureResult();
            ioFuture.setException(e2);
            return ioFuture.getIoFuture();
        }
    }

    @Override
    public void endExchange() {
    }

    @Override
    public void close() {
        IoUtils.safeClose((Closeable)this.exchange.getConnection());
    }

    @Override
    public String getRequestScheme() {
        return this.request.getScheme();
    }

    @Override
    public String getRequestURI() {
        return this.request.getRequestURI() + (this.request.getQueryString() == null ? "" : "?" + this.request.getQueryString());
    }

    @Override
    public ByteBufferPool getBufferPool() {
        return this.exchange.getConnection().getByteBufferPool();
    }

    @Override
    public String getQueryString() {
        return this.request.getQueryString();
    }

    @Override
    public Object getSession() {
        return this.request.getSession(false);
    }

    @Override
    public Map<String, List<String>> getRequestParameters() {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        for (Map.Entry<String, String[]> param : this.request.getParameterMap().entrySet()) {
            params.put(param.getKey(), new ArrayList<Object>(Arrays.asList((Object[])param.getValue())));
        }
        return params;
    }

    @Override
    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    @Override
    public boolean isUserInRole(String role) {
        return this.request.isUserInRole(role);
    }

    @Override
    public Set<WebSocketChannel> getPeerConnections() {
        return this.peerConnections;
    }

    @Override
    public OptionMap getOptions() {
        return this.exchange.getConnection().getUndertowOptions();
    }
}

