/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class CopyOnWriteMap<K, V>
implements ConcurrentMap<K, V> {
    private volatile Map<K, V> delegate = Collections.emptyMap();

    public CopyOnWriteMap() {
    }

    public CopyOnWriteMap(Map<K, V> existing) {
        this.delegate = new HashMap<K, V>(existing);
    }

    @Override
    public synchronized V putIfAbsent(K key2, V value) {
        Map<K, V> delegate = this.delegate;
        V existing = delegate.get(key2);
        if (existing != null) {
            return existing;
        }
        this.putInternal(key2, value);
        return null;
    }

    @Override
    public synchronized boolean remove(Object key2, Object value) {
        Map<K, V> delegate = this.delegate;
        V existing = delegate.get(key2);
        if (existing.equals(value)) {
            this.removeInternal(key2);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean replace(K key2, V oldValue, V newValue) {
        Map<K, V> delegate = this.delegate;
        V existing = delegate.get(key2);
        if (existing.equals(oldValue)) {
            this.putInternal(key2, newValue);
            return true;
        }
        return false;
    }

    @Override
    public synchronized V replace(K key2, V value) {
        Map<K, V> delegate = this.delegate;
        V existing = delegate.get(key2);
        if (existing != null) {
            this.putInternal(key2, value);
            return existing;
        }
        return null;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.delegate.containsKey(key2);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public V get(Object key2) {
        return this.delegate.get(key2);
    }

    @Override
    public synchronized V put(K key2, V value) {
        return this.putInternal(key2, value);
    }

    @Override
    public synchronized V remove(Object key2) {
        return this.removeInternal(key2);
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> m) {
        HashMap<K, V> delegate = new HashMap<K, V>(this.delegate);
        for (Map.Entry<K, V> e2 : m.entrySet()) {
            delegate.put(e2.getKey(), e2.getValue());
        }
        this.delegate = delegate;
    }

    @Override
    public synchronized void clear() {
        this.delegate = Collections.emptyMap();
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    private V putInternal(K key2, V value) {
        HashMap<K, V> delegate = new HashMap<K, V>(this.delegate);
        V existing = delegate.put(key2, value);
        this.delegate = delegate;
        return existing;
    }

    public V removeInternal(Object key2) {
        HashMap<K, V> delegate = new HashMap<K, V>(this.delegate);
        Object existing = delegate.remove(key2);
        this.delegate = delegate;
        return existing;
    }
}

