/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.UndertowLogger;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSinkChannel;

public class StringWriteChannelListener
implements ChannelListener<StreamSinkChannel> {
    private final ByteBuffer buffer;

    public StringWriteChannelListener(String string2) {
        this(string2, Charset.defaultCharset());
    }

    public StringWriteChannelListener(String string2, Charset charset) {
        this.buffer = ByteBuffer.wrap(string2.getBytes(charset));
    }

    public void setup(StreamSinkChannel channel) {
        try {
            int c;
            do {
                c = channel.write(this.buffer);
            } while (this.buffer.hasRemaining() && c > 0);
            if (this.buffer.hasRemaining()) {
                channel.getWriteSetter().set(this);
                channel.resumeWrites();
            } else {
                this.writeDone(channel);
            }
        }
        catch (IOException e2) {
            this.handleError(channel, e2);
        }
    }

    protected void handleError(StreamSinkChannel channel, IOException e2) {
        UndertowLogger.REQUEST_IO_LOGGER.ioException(e2);
        IoUtils.safeClose((Closeable)channel);
    }

    @Override
    public void handleEvent(StreamSinkChannel channel) {
        try {
            int c;
            do {
                c = channel.write(this.buffer);
            } while (this.buffer.hasRemaining() && c > 0);
            if (this.buffer.hasRemaining()) {
                channel.resumeWrites();
                return;
            }
            this.writeDone(channel);
        }
        catch (IOException e2) {
            this.handleError(channel, e2);
        }
    }

    public boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    protected void writeDone(final StreamSinkChannel channel) {
        try {
            channel.shutdownWrites();
            if (!channel.flush()) {
                channel.getWriteSetter().set(ChannelListeners.flushingChannelListener(new ChannelListener<StreamSinkChannel>(){

                    @Override
                    public void handleEvent(StreamSinkChannel o) {
                        IoUtils.safeClose((Closeable)channel);
                    }
                }, ChannelListeners.closingChannelExceptionHandler()));
                channel.resumeWrites();
            }
        }
        catch (IOException e2) {
            this.handleError(channel, e2);
        }
    }
}

