/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core;

import java.nio.ByteBuffer;
import org.xnio.Buffers;

public final class UTF8Output {
    private static final int UTF8_ACCEPT = 0;
    private static final byte HIGH_BIT = -128;
    private static final byte[] TYPES = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 10, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 11, 6, 6, 6, 5, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
    private static final byte[] STATES = new byte[]{0, 12, 24, 36, 60, 96, 84, 12, 12, 12, 48, 72, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 0, 12, 12, 12, 12, 12, 0, 12, 0, 12, 12, 12, 24, 12, 12, 12, 12, 12, 24, 12, 24, 12, 12, 12, 12, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 12, 12, 12, 12, 36, 12, 36, 12, 12, 12, 36, 12, 12, 12, 12, 12, 36, 12, 36, 12, 12, 12, 36, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
    private byte state = 0;
    private int codep;
    private final StringBuilder stringBuilder;

    public UTF8Output(ByteBuffer ... payload) {
        this.stringBuilder = new StringBuilder((int)Buffers.remaining(payload));
        this.write(payload);
    }

    public UTF8Output() {
        this.stringBuilder = new StringBuilder();
    }

    public void write(ByteBuffer ... bytes2) {
        for (ByteBuffer buf : bytes2) {
            while (buf.hasRemaining()) {
                this.write(buf.get());
            }
        }
    }

    private void write(byte b) {
        if (this.state == 0 && (b & 0xFFFFFF80) == 0) {
            this.stringBuilder.append((char)b);
            return;
        }
        byte type2 = TYPES[b & 0xFF];
        this.codep = this.state != 0 ? b & 0x3F | this.codep << 6 : 255 >> type2 & b;
        this.state = STATES[this.state + type2];
        if (this.state == 0) {
            for (char c : Character.toChars(this.codep)) {
                this.stringBuilder.append(c);
            }
        }
    }

    public String extract() {
        String text = this.stringBuilder.toString();
        this.stringBuilder.setLength(0);
        return text;
    }

    public boolean hasData() {
        return this.stringBuilder.length() != 0;
    }
}

