/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core;

import io.undertow.connector.PooledByteBuffer;
import io.undertow.util.ImmediatePooledByteBuffer;
import io.undertow.util.WorkerUtils;
import io.undertow.websockets.core.CloseMessage;
import io.undertow.websockets.core.StreamSinkFrameChannel;
import io.undertow.websockets.core.WebSocketCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.WebSocketMessages;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.xnio.Buffers;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.XnioExecutor;

public class WebSockets {
    public static void sendText(String message, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        WebSockets.sendText(message, wsChannel, callback, null);
    }

    public static <T> void sendText(String message, WebSocketChannel wsChannel, WebSocketCallback<T> callback, T context) {
        ByteBuffer data2 = ByteBuffer.wrap(message.getBytes(StandardCharsets.UTF_8));
        WebSockets.sendInternal(data2, WebSocketFrameType.TEXT, wsChannel, callback, context, -1L);
    }

    public static void sendText(String message, WebSocketChannel wsChannel, WebSocketCallback<Void> callback, long timeoutmillis) {
        WebSockets.sendText(message, wsChannel, callback, null, timeoutmillis);
    }

    public static <T> void sendText(String message, WebSocketChannel wsChannel, WebSocketCallback<T> callback, T context, long timeoutmillis) {
        ByteBuffer data2 = ByteBuffer.wrap(message.getBytes(StandardCharsets.UTF_8));
        WebSockets.sendInternal(data2, WebSocketFrameType.TEXT, wsChannel, callback, context, timeoutmillis);
    }

    public static void sendText(ByteBuffer message, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        WebSockets.sendInternal(message, WebSocketFrameType.TEXT, wsChannel, callback, null, -1L);
    }

    public static <T> void sendText(ByteBuffer message, WebSocketChannel wsChannel, WebSocketCallback<T> callback, T context) {
        WebSockets.sendInternal(message, WebSocketFrameType.TEXT, wsChannel, callback, context, -1L);
    }

    public static void sendText(ByteBuffer message, WebSocketChannel wsChannel, WebSocketCallback<Void> callback, long timeoutmillis) {
        WebSockets.sendInternal(message, WebSocketFrameType.TEXT, wsChannel, callback, null, timeoutmillis);
    }

    public static <T> void sendText(ByteBuffer message, WebSocketChannel wsChannel, WebSocketCallback<T> callback, T context, long timeoutmillis) {
        WebSockets.sendInternal(message, WebSocketFrameType.TEXT, wsChannel, callback, context, timeoutmillis);
    }

    public static void sendText(PooledByteBuffer pooledData, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        WebSockets.sendInternal(pooledData, WebSocketFrameType.TEXT, wsChannel, callback, null, -1L);
    }

    public static <T> void sendText(PooledByteBuffer pooledData, WebSocketChannel wsChannel, WebSocketCallback<T> callback, T context) {
        WebSockets.sendInternal(pooledData, WebSocketFrameType.TEXT, wsChannel, callback, context, -1L);
    }

    public static void sendText(PooledByteBuffer pooledData, WebSocketChannel wsChannel, WebSocketCallback<Void> callback, long timeoutmillis) {
        WebSockets.sendInternal(pooledData, WebSocketFrameType.TEXT, wsChannel, callback, null, timeoutmillis);
    }

    public static <T> void sendText(PooledByteBuffer pooledData, WebSocketChannel wsChannel, WebSocketCallback<T> callback, T context, long timeoutmillis) {
        WebSockets.sendInternal(pooledData, WebSocketFrameType.TEXT, wsChannel, callback, context, timeoutmillis);
    }

    public static void sendTextBlocking(String message, WebSocketChannel wsChannel) throws IOException {
        ByteBuffer data2 = ByteBuffer.wrap(message.getBytes(StandardCharsets.UTF_8));
        WebSockets.sendBlockingInternal(data2, WebSocketFrameType.TEXT, wsChannel);
    }

    public static void sendTextBlocking(ByteBuffer message, WebSocketChannel wsChannel) throws IOException {
        WebSockets.sendBlockingInternal(message, WebSocketFrameType.TEXT, wsChannel);
    }

    public static void sendTextBlocking(PooledByteBuffer pooledData, WebSocketChannel wsChannel) throws IOException {
        WebSockets.sendBlockingInternal(pooledData, WebSocketFrameType.TEXT, wsChannel);
    }

    public static void sendPing(ByteBuffer data2, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        WebSockets.sendInternal(data2, WebSocketFrameType.PING, wsChannel, callback, null, -1L);
    }

    public static <T> void sendPing(ByteBuffer data2, WebSocketChannel wsChannel, WebSocketCallback<T> callback, T context) {
        WebSockets.sendInternal(data2, WebSocketFrameType.PING, wsChannel, callback, context, -1L);
    }

    public static void sendPing(ByteBuffer data2, WebSocketChannel wsChannel, WebSocketCallback<Void> callback, long timeoutmillis) {
        WebSockets.sendInternal(data2, WebSocketFrameType.PING, wsChannel, callback, null, timeoutmillis);
    }

    public static <T> void sendPing(ByteBuffer data2, WebSocketChannel wsChannel, WebSocketCallback<T> callback, T context, long timeoutmillis) {
        WebSockets.sendInternal(data2, WebSocketFrameType.PING, wsChannel, callback, context, timeoutmillis);
    }

    public static void sendPing(ByteBuffer[] data2, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        WebSockets.sendInternal(WebSockets.mergeBuffers(data2), WebSocketFrameType.PING, wsChannel, callback, null, -1L);
    }

    public static <T> void sendPing(ByteBuffer[] data2, WebSocketChannel wsChannel, WebSocketCallback<T> callback, T context) {
        WebSockets.sendInternal(WebSockets.mergeBuffers(data2), WebSocketFrameType.PING, wsChannel, callback, context, -1L);
    }

    public static void sendPing(ByteBuffer[] data2, WebSocketChannel wsChannel, WebSocketCallback<Void> callback, long timeoutmillis) {
        WebSockets.sendInternal(WebSockets.mergeBuffers(data2), WebSocketFrameType.PING, wsChannel, callback, null, timeoutmillis);
    }

    public static <T> void sendPing(ByteBuffer[] data2, WebSocketChannel wsChannel, WebSocketCallback<T> callback, T context, long timeoutmillis) {
        WebSockets.sendInternal(WebSockets.mergeBuffers(data2), WebSocketFrameType.PING, wsChannel, callback, context, timeoutmillis);
    }

    public static void sendPing(PooledByteBuffer pooledData, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        WebSockets.sendInternal(pooledData, WebSocketFrameType.PING, wsChannel, callback, null, -1L);
    }

    public static <T> void sendPing(PooledByteBuffer pooledData, WebSocketChannel wsChannel, WebSocketCallback<T> callback, T context) {
        WebSockets.sendInternal(pooledData, WebSocketFrameType.PING, wsChannel, callback, context, -1L);
    }

    public static void sendPing(PooledByteBuffer pooledData, WebSocketChannel wsChannel, WebSocketCallback<Void> callback, long timeoutmillis) {
        WebSockets.sendInternal(pooledData, WebSocketFrameType.PING, wsChannel, callback, null, timeoutmillis);
    }

    public static <T> void sendPing(PooledByteBuffer pooledData, WebSocketChannel wsChannel, WebSocketCallback<T> callback, T context, long timeoutmillis) {
        WebSockets.sendInternal(pooledData, WebSocketFrameType.PING, wsChannel, callback, context, timeoutmillis);
    }

    public static void sendPingBlocking(ByteBuffer data2, WebSocketChannel wsChannel) throws IOException {
        WebSockets.sendBlockingInternal(data2, WebSocketFrameType.PING, wsChannel);
    }

    public static void sendPingBlocking(ByteBuffer[] data2, WebSocketChannel wsChannel) throws IOException {
        WebSockets.sendBlockingInternal(WebSockets.mergeBuffers(data2), WebSocketFrameType.PING, wsChannel);
    }

    public static void sendPingBlocking(PooledByteBuffer pooledData, WebSocketChannel wsChannel) throws IOException {
        WebSockets.sendBlockingInternal(pooledData, WebSocketFrameType.PING, wsChannel);
    }

    public static void sendPong(ByteBuffer data2, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        WebSockets.sendInternal(data2, WebSocketFrameType.PONG, wsChannel, callback, null, -1L);
    }

    public static <T> void sendPong(ByteBuffer data2, WebSocketChannel wsChannel, WebSocketCallback<T> callback, T context) {
        WebSockets.sendInternal(data2, WebSocketFrameType.PONG, wsChannel, callback, context, -1L);
    }

    public static void sendPong(ByteBuffer data2, WebSocketChannel wsChannel, WebSocketCallback<Void> callback, long timeoutmillis) {
        WebSockets.sendInternal(data2, WebSocketFrameType.PONG, wsChannel, callback, null, timeoutmillis);
    }

    public static <T> void sendPong(ByteBuffer data2, WebSocketChannel wsChannel, WebSocketCallback<T> callback, T context, long timeoutmillis) {
        WebSockets.sendInternal(data2, WebSocketFrameType.PONG, wsChannel, callback, context, timeoutmillis);
    }

    public static void sendPong(ByteBuffer[] data2, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        WebSockets.sendInternal(WebSockets.mergeBuffers(data2), WebSocketFrameType.PONG, wsChannel, callback, null, -1L);
    }

    public static <T> void sendPong(ByteBuffer[] data2, WebSocketChannel wsChannel, WebSocketCallback<T> callback, T context) {
        WebSockets.sendInternal(WebSockets.mergeBuffers(data2), WebSocketFrameType.PONG, wsChannel, callback, context, -1L);
    }

    public static void sendPong(ByteBuffer[] data2, WebSocketChannel wsChannel, WebSocketCallback<Void> callback, long timeoutmillis) {
        WebSockets.sendInternal(WebSockets.mergeBuffers(data2), WebSocketFrameType.PONG, wsChannel, callback, null, timeoutmillis);
    }

    public static <T> void sendPong(ByteBuffer[] data2, WebSocketChannel wsChannel, WebSocketCallback<T> callback, T context, long timeoutmillis) {
        WebSockets.sendInternal(WebSockets.mergeBuffers(data2), WebSocketFrameType.PONG, wsChannel, callback, context, timeoutmillis);
    }

    public static void sendPong(PooledByteBuffer pooledData, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        WebSockets.sendInternal(pooledData, WebSocketFrameType.PONG, wsChannel, callback, null, -1L);
    }

    public static <T> void sendPong(PooledByteBuffer pooledData, WebSocketChannel wsChannel, WebSocketCallback<T> callback, T context) {
        WebSockets.sendInternal(pooledData, WebSocketFrameType.PONG, wsChannel, callback, context, -1L);
    }

    public static void sendPong(PooledByteBuffer pooledData, WebSocketChannel wsChannel, WebSocketCallback<Void> callback, long timeoutmillis) {
        WebSockets.sendInternal(pooledData, WebSocketFrameType.PONG, wsChannel, callback, null, timeoutmillis);
    }

    public static <T> void sendPong(PooledByteBuffer pooledData, WebSocketChannel wsChannel, WebSocketCallback<T> callback, T context, long timeoutmillis) {
        WebSockets.sendInternal(pooledData, WebSocketFrameType.PONG, wsChannel, callback, context, timeoutmillis);
    }

    public static void sendPongBlocking(ByteBuffer data2, WebSocketChannel wsChannel) throws IOException {
        WebSockets.sendBlockingInternal(data2, WebSocketFrameType.PONG, wsChannel);
    }

    public static void sendPongBlocking(ByteBuffer[] data2, WebSocketChannel wsChannel) throws IOException {
        WebSockets.sendBlockingInternal(WebSockets.mergeBuffers(data2), WebSocketFrameType.PONG, wsChannel);
    }

    public static void sendPongBlocking(PooledByteBuffer pooledData, WebSocketChannel wsChannel) throws IOException {
        WebSockets.sendBlockingInternal(pooledData, WebSocketFrameType.PONG, wsChannel);
    }

    public static void sendBinary(ByteBuffer data2, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        WebSockets.sendInternal(data2, WebSocketFrameType.BINARY, wsChannel, callback, null, -1L);
    }

    public static <T> void sendBinary(ByteBuffer data2, WebSocketChannel wsChannel, WebSocketCallback<T> callback, T context) {
        WebSockets.sendInternal(data2, WebSocketFrameType.BINARY, wsChannel, callback, context, -1L);
    }

    public static void sendBinary(ByteBuffer data2, WebSocketChannel wsChannel, WebSocketCallback<Void> callback, long timeoutmillis) {
        WebSockets.sendInternal(data2, WebSocketFrameType.BINARY, wsChannel, callback, null, timeoutmillis);
    }

    public static <T> void sendBinary(ByteBuffer data2, WebSocketChannel wsChannel, WebSocketCallback<T> callback, T context, long timeoutmillis) {
        WebSockets.sendInternal(data2, WebSocketFrameType.BINARY, wsChannel, callback, context, timeoutmillis);
    }

    public static void sendBinary(ByteBuffer[] data2, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        WebSockets.sendInternal(WebSockets.mergeBuffers(data2), WebSocketFrameType.BINARY, wsChannel, callback, null, -1L);
    }

    public static <T> void sendBinary(ByteBuffer[] data2, WebSocketChannel wsChannel, WebSocketCallback<T> callback, T context) {
        WebSockets.sendInternal(WebSockets.mergeBuffers(data2), WebSocketFrameType.BINARY, wsChannel, callback, context, -1L);
    }

    public static void sendBinary(ByteBuffer[] data2, WebSocketChannel wsChannel, WebSocketCallback<Void> callback, long timeoutmillis) {
        WebSockets.sendInternal(WebSockets.mergeBuffers(data2), WebSocketFrameType.BINARY, wsChannel, callback, null, timeoutmillis);
    }

    public static <T> void sendBinary(ByteBuffer[] data2, WebSocketChannel wsChannel, WebSocketCallback<T> callback, T context, long timeoutmillis) {
        WebSockets.sendInternal(WebSockets.mergeBuffers(data2), WebSocketFrameType.BINARY, wsChannel, callback, context, timeoutmillis);
    }

    public static void sendBinary(PooledByteBuffer pooledData, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        WebSockets.sendInternal(pooledData, WebSocketFrameType.BINARY, wsChannel, callback, null, -1L);
    }

    public static <T> void sendBinary(PooledByteBuffer pooledData, WebSocketChannel wsChannel, WebSocketCallback<T> callback, T context) {
        WebSockets.sendInternal(pooledData, WebSocketFrameType.BINARY, wsChannel, callback, context, -1L);
    }

    public static void sendBinary(PooledByteBuffer pooledData, WebSocketChannel wsChannel, WebSocketCallback<Void> callback, long timeoutmillis) {
        WebSockets.sendInternal(pooledData, WebSocketFrameType.BINARY, wsChannel, callback, null, timeoutmillis);
    }

    public static <T> void sendBinary(PooledByteBuffer pooledData, WebSocketChannel wsChannel, WebSocketCallback<T> callback, T context, long timeoutmillis) {
        WebSockets.sendInternal(pooledData, WebSocketFrameType.BINARY, wsChannel, callback, context, timeoutmillis);
    }

    public static void sendBinaryBlocking(ByteBuffer data2, WebSocketChannel wsChannel) throws IOException {
        WebSockets.sendBlockingInternal(data2, WebSocketFrameType.BINARY, wsChannel);
    }

    public static void sendBinaryBlocking(ByteBuffer[] data2, WebSocketChannel wsChannel) throws IOException {
        WebSockets.sendBlockingInternal(WebSockets.mergeBuffers(data2), WebSocketFrameType.BINARY, wsChannel);
    }

    public static void sendBinaryBlocking(PooledByteBuffer pooledData, WebSocketChannel wsChannel) throws IOException {
        WebSockets.sendBlockingInternal(pooledData, WebSocketFrameType.BINARY, wsChannel);
    }

    public static void sendClose(ByteBuffer data2, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        CloseMessage sm = new CloseMessage(data2);
        WebSockets.sendClose(sm, wsChannel, callback);
    }

    public static <T> void sendClose(ByteBuffer data2, WebSocketChannel wsChannel, WebSocketCallback<T> callback, T context) {
        CloseMessage sm = new CloseMessage(data2);
        WebSockets.sendClose(sm, wsChannel, callback, context);
    }

    public static void sendClose(ByteBuffer[] data2, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        CloseMessage sm = new CloseMessage(data2);
        WebSockets.sendClose(sm, wsChannel, callback);
    }

    public static <T> void sendClose(ByteBuffer[] data2, WebSocketChannel wsChannel, WebSocketCallback<T> callback, T context) {
        CloseMessage sm = new CloseMessage(data2);
        WebSockets.sendClose(sm, wsChannel, callback, context);
    }

    public static void sendClose(int code, String reason, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        WebSockets.sendClose(new CloseMessage(code, reason), wsChannel, callback);
    }

    public static <T> void sendClose(int code, String reason, WebSocketChannel wsChannel, WebSocketCallback<T> callback, T context) {
        WebSockets.sendClose(new CloseMessage(code, reason), wsChannel, callback, context);
    }

    public static void sendClose(CloseMessage closeMessage, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        WebSockets.sendClose(closeMessage, wsChannel, callback, null);
    }

    public static <T> void sendClose(CloseMessage closeMessage, WebSocketChannel wsChannel, WebSocketCallback<T> callback, T context) {
        wsChannel.setCloseCode(closeMessage.getCode());
        wsChannel.setCloseReason(closeMessage.getReason());
        WebSockets.sendInternal(closeMessage.toByteBuffer(), WebSocketFrameType.CLOSE, wsChannel, callback, context, -1L);
    }

    public static void sendCloseBlocking(CloseMessage closeMessage, WebSocketChannel wsChannel) throws IOException {
        wsChannel.setCloseReason(closeMessage.getReason());
        wsChannel.setCloseCode(closeMessage.getCode());
        WebSockets.sendBlockingInternal(closeMessage.toByteBuffer(), WebSocketFrameType.CLOSE, wsChannel);
    }

    public static void sendCloseBlocking(int code, String reason, WebSocketChannel wsChannel) throws IOException {
        WebSockets.sendCloseBlocking(new CloseMessage(code, reason), wsChannel);
    }

    public static void sendCloseBlocking(ByteBuffer data2, WebSocketChannel wsChannel) throws IOException {
        WebSockets.sendCloseBlocking(new CloseMessage(data2), wsChannel);
    }

    public static void sendCloseBlocking(ByteBuffer[] data2, WebSocketChannel wsChannel) throws IOException {
        WebSockets.sendCloseBlocking(new CloseMessage(data2), wsChannel);
    }

    private static <T> void sendInternal(ByteBuffer data2, WebSocketFrameType type2, WebSocketChannel wsChannel, WebSocketCallback<T> callback, T context, long timeoutmillis) {
        WebSockets.sendInternal(new ImmediatePooledByteBuffer(data2), type2, wsChannel, callback, context, timeoutmillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void sendInternal(PooledByteBuffer pooledData, WebSocketFrameType type2, WebSocketChannel wsChannel, WebSocketCallback<T> callback, T context, long timeoutmillis) {
        boolean closePooledData = true;
        try {
            StreamSinkFrameChannel channel = wsChannel.send(type2);
            closePooledData = false;
            if (!channel.send(pooledData)) {
                throw WebSocketMessages.MESSAGES.unableToSendOnNewChannel();
            }
            WebSockets.flushChannelAsync(wsChannel, callback, channel, context, timeoutmillis);
        }
        catch (IOException e2) {
            if (callback != null) {
                callback.onError(wsChannel, context, e2);
            } else {
                IoUtils.safeClose((Closeable)wsChannel);
            }
        }
        finally {
            if (closePooledData) {
                pooledData.close();
            }
        }
    }

    private static <T> void flushChannelAsync(final WebSocketChannel wsChannel, final WebSocketCallback<T> callback, StreamSinkFrameChannel channel, final T context, long timeoutmillis) throws IOException {
        final WebSocketFrameType type2 = channel.getType();
        channel.shutdownWrites();
        if (!channel.flush()) {
            channel.getWriteSetter().set(ChannelListeners.flushingChannelListener(new ChannelListener<StreamSinkFrameChannel>(){

                @Override
                public void handleEvent(StreamSinkFrameChannel channel) {
                    if (callback != null) {
                        callback.complete(wsChannel, context);
                    }
                    if (type2 == WebSocketFrameType.CLOSE && wsChannel.isCloseFrameReceived()) {
                        IoUtils.safeClose((Closeable)wsChannel);
                    }
                    channel.getWriteSetter().set(null);
                }
            }, new ChannelExceptionHandler<StreamSinkFrameChannel>(){

                @Override
                public void handleException(StreamSinkFrameChannel channel, IOException exception) {
                    if (callback != null) {
                        callback.onError(wsChannel, context, exception);
                    }
                    IoUtils.safeClose(channel, wsChannel);
                    channel.getWriteSetter().set(null);
                }
            }));
            if (timeoutmillis > 0L) {
                WebSockets.setupTimeout(channel, timeoutmillis);
            }
            channel.resumeWrites();
            return;
        }
        if (callback != null) {
            callback.complete(wsChannel, context);
        }
    }

    private static void setupTimeout(final StreamSinkFrameChannel channel, long timeoutmillis) {
        final XnioExecutor.Key key2 = WorkerUtils.executeAfter(channel.getIoThread(), new Runnable(){

            @Override
            public void run() {
                if (channel.isOpen()) {
                    IoUtils.safeClose((Closeable)channel);
                }
            }
        }, timeoutmillis, TimeUnit.MILLISECONDS);
        channel.getCloseSetter().set(new ChannelListener<StreamSinkFrameChannel>(){

            @Override
            public void handleEvent(StreamSinkFrameChannel channel) {
                key2.remove();
            }
        });
    }

    private static void sendBlockingInternal(ByteBuffer data2, WebSocketFrameType type2, WebSocketChannel wsChannel) throws IOException {
        WebSockets.sendBlockingInternal(new ImmediatePooledByteBuffer(data2), type2, wsChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendBlockingInternal(PooledByteBuffer pooledData, WebSocketFrameType type2, WebSocketChannel wsChannel) throws IOException {
        boolean closePooledData = true;
        try {
            StreamSinkFrameChannel channel = wsChannel.send(type2);
            closePooledData = false;
            if (!channel.send(pooledData)) {
                throw WebSocketMessages.MESSAGES.unableToSendOnNewChannel();
            }
            channel.shutdownWrites();
            while (!channel.flush()) {
                channel.awaitWritable();
            }
            if (type2 == WebSocketFrameType.CLOSE && wsChannel.isCloseFrameReceived()) {
                IoUtils.safeClose((Closeable)wsChannel);
            }
        }
        finally {
            if (closePooledData) {
                pooledData.close();
            }
        }
    }

    private WebSockets() {
    }

    public static ByteBuffer mergeBuffers(ByteBuffer ... payload) {
        int size = (int)Buffers.remaining(payload);
        if (size == 0) {
            return Buffers.EMPTY_BYTE_BUFFER;
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        for (ByteBuffer buf : payload) {
            buffer.put(buf);
        }
        buffer.flip();
        return buffer;
    }
}

