/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javassist.bytecode.ConstPool;
import javassist.bytecode.ExceptionTableEntry;

public class ExceptionTable
implements Cloneable {
    private ConstPool constPool;
    private List<ExceptionTableEntry> entries;

    public ExceptionTable(ConstPool cp) {
        this.constPool = cp;
        this.entries = new ArrayList<ExceptionTableEntry>();
    }

    ExceptionTable(ConstPool cp, DataInputStream in) throws IOException {
        this.constPool = cp;
        int length = in.readUnsignedShort();
        ArrayList<ExceptionTableEntry> list = new ArrayList<ExceptionTableEntry>(length);
        for (int i = 0; i < length; ++i) {
            int start = in.readUnsignedShort();
            int end = in.readUnsignedShort();
            int handle = in.readUnsignedShort();
            int type2 = in.readUnsignedShort();
            list.add(new ExceptionTableEntry(start, end, handle, type2));
        }
        this.entries = list;
    }

    public Object clone() throws CloneNotSupportedException {
        ExceptionTable r = (ExceptionTable)super.clone();
        r.entries = new ArrayList<ExceptionTableEntry>(this.entries);
        return r;
    }

    public int size() {
        return this.entries.size();
    }

    public int startPc(int nth2) {
        return this.entries.get((int)nth2).startPc;
    }

    public void setStartPc(int nth2, int value) {
        this.entries.get((int)nth2).startPc = value;
    }

    public int endPc(int nth2) {
        return this.entries.get((int)nth2).endPc;
    }

    public void setEndPc(int nth2, int value) {
        this.entries.get((int)nth2).endPc = value;
    }

    public int handlerPc(int nth2) {
        return this.entries.get((int)nth2).handlerPc;
    }

    public void setHandlerPc(int nth2, int value) {
        this.entries.get((int)nth2).handlerPc = value;
    }

    public int catchType(int nth2) {
        return this.entries.get((int)nth2).catchType;
    }

    public void setCatchType(int nth2, int value) {
        this.entries.get((int)nth2).catchType = value;
    }

    public void add(int index2, ExceptionTable table, int offset) {
        int len = table.size();
        while (--len >= 0) {
            ExceptionTableEntry e2 = table.entries.get(len);
            this.add(index2, e2.startPc + offset, e2.endPc + offset, e2.handlerPc + offset, e2.catchType);
        }
    }

    public void add(int index2, int start, int end, int handler, int type2) {
        if (start < end) {
            this.entries.add(index2, new ExceptionTableEntry(start, end, handler, type2));
        }
    }

    public void add(int start, int end, int handler, int type2) {
        if (start < end) {
            this.entries.add(new ExceptionTableEntry(start, end, handler, type2));
        }
    }

    public void remove(int index2) {
        this.entries.remove(index2);
    }

    public ExceptionTable copy(ConstPool newCp, Map<String, String> classnames) {
        ExceptionTable et = new ExceptionTable(newCp);
        ConstPool srcCp = this.constPool;
        for (ExceptionTableEntry e2 : this.entries) {
            int type2 = srcCp.copy(e2.catchType, newCp, classnames);
            et.add(e2.startPc, e2.endPc, e2.handlerPc, type2);
        }
        return et;
    }

    void shiftPc(int where, int gapLength, boolean exclusive) {
        for (ExceptionTableEntry e2 : this.entries) {
            e2.startPc = ExceptionTable.shiftPc(e2.startPc, where, gapLength, exclusive);
            e2.endPc = ExceptionTable.shiftPc(e2.endPc, where, gapLength, exclusive);
            e2.handlerPc = ExceptionTable.shiftPc(e2.handlerPc, where, gapLength, exclusive);
        }
    }

    private static int shiftPc(int pc, int where, int gapLength, boolean exclusive) {
        if (pc > where || exclusive && pc == where) {
            pc += gapLength;
        }
        return pc;
    }

    void write(DataOutputStream out) throws IOException {
        out.writeShort(this.size());
        for (ExceptionTableEntry e2 : this.entries) {
            out.writeShort(e2.startPc);
            out.writeShort(e2.endPc);
            out.writeShort(e2.handlerPc);
            out.writeShort(e2.catchType);
        }
    }
}

