/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ByteArray;
import javassist.bytecode.ConstPool;

public class InnerClassesAttribute
extends AttributeInfo {
    public static final String tag = "InnerClasses";

    InnerClassesAttribute(ConstPool cp, int n, DataInputStream in) throws IOException {
        super(cp, n, in);
    }

    private InnerClassesAttribute(ConstPool cp, byte[] info) {
        super(cp, tag, info);
    }

    public InnerClassesAttribute(ConstPool cp) {
        super(cp, tag, new byte[2]);
        ByteArray.write16bit(0, this.get(), 0);
    }

    public int tableLength() {
        return ByteArray.readU16bit(this.get(), 0);
    }

    public int innerClassIndex(int nth2) {
        return ByteArray.readU16bit(this.get(), nth2 * 8 + 2);
    }

    public String innerClass(int nth2) {
        int i = this.innerClassIndex(nth2);
        if (i == 0) {
            return null;
        }
        return this.constPool.getClassInfo(i);
    }

    public void setInnerClassIndex(int nth2, int index2) {
        ByteArray.write16bit(index2, this.get(), nth2 * 8 + 2);
    }

    public int outerClassIndex(int nth2) {
        return ByteArray.readU16bit(this.get(), nth2 * 8 + 4);
    }

    public String outerClass(int nth2) {
        int i = this.outerClassIndex(nth2);
        if (i == 0) {
            return null;
        }
        return this.constPool.getClassInfo(i);
    }

    public void setOuterClassIndex(int nth2, int index2) {
        ByteArray.write16bit(index2, this.get(), nth2 * 8 + 4);
    }

    public int innerNameIndex(int nth2) {
        return ByteArray.readU16bit(this.get(), nth2 * 8 + 6);
    }

    public String innerName(int nth2) {
        int i = this.innerNameIndex(nth2);
        if (i == 0) {
            return null;
        }
        return this.constPool.getUtf8Info(i);
    }

    public void setInnerNameIndex(int nth2, int index2) {
        ByteArray.write16bit(index2, this.get(), nth2 * 8 + 6);
    }

    public int accessFlags(int nth2) {
        return ByteArray.readU16bit(this.get(), nth2 * 8 + 8);
    }

    public void setAccessFlags(int nth2, int flags) {
        ByteArray.write16bit(flags, this.get(), nth2 * 8 + 8);
    }

    public int find(String name2) {
        int n = this.tableLength();
        for (int i = 0; i < n; ++i) {
            if (!name2.equals(this.innerClass(i))) continue;
            return i;
        }
        return -1;
    }

    public void append(String inner, String outer, String name2, int flags) {
        int i = this.constPool.addClassInfo(inner);
        int o = this.constPool.addClassInfo(outer);
        int n = this.constPool.addUtf8Info(name2);
        this.append(i, o, n, flags);
    }

    public void append(int inner, int outer, int name2, int flags) {
        byte[] data2 = this.get();
        int len = data2.length;
        byte[] newData = new byte[len + 8];
        for (int i = 2; i < len; ++i) {
            newData[i] = data2[i];
        }
        int n = ByteArray.readU16bit(data2, 0);
        ByteArray.write16bit(n + 1, newData, 0);
        ByteArray.write16bit(inner, newData, len);
        ByteArray.write16bit(outer, newData, len + 2);
        ByteArray.write16bit(name2, newData, len + 4);
        ByteArray.write16bit(flags, newData, len + 6);
        this.set(newData);
    }

    public int remove(int nth2) {
        byte[] data2 = this.get();
        int len = data2.length;
        if (len < 10) {
            return 0;
        }
        int n = ByteArray.readU16bit(data2, 0);
        int nthPos = 2 + nth2 * 8;
        if (n <= nth2) {
            return n;
        }
        byte[] newData = new byte[len - 8];
        ByteArray.write16bit(n - 1, newData, 0);
        int i = 2;
        int j = 2;
        while (i < len) {
            if (i == nthPos) {
                i += 8;
                continue;
            }
            newData[j++] = data2[i++];
        }
        this.set(newData);
        return n - 1;
    }

    @Override
    public AttributeInfo copy(ConstPool newCp, Map<String, String> classnames) {
        byte[] src = this.get();
        byte[] dest = new byte[src.length];
        ConstPool cp = this.getConstPool();
        InnerClassesAttribute attr = new InnerClassesAttribute(newCp, dest);
        int n = ByteArray.readU16bit(src, 0);
        ByteArray.write16bit(n, dest, 0);
        int j = 2;
        for (int i = 0; i < n; ++i) {
            int innerClass = ByteArray.readU16bit(src, j);
            int outerClass = ByteArray.readU16bit(src, j + 2);
            int innerName = ByteArray.readU16bit(src, j + 4);
            int innerAccess = ByteArray.readU16bit(src, j + 6);
            if (innerClass != 0) {
                innerClass = cp.copy(innerClass, newCp, classnames);
            }
            ByteArray.write16bit(innerClass, dest, j);
            if (outerClass != 0) {
                outerClass = cp.copy(outerClass, newCp, classnames);
            }
            ByteArray.write16bit(outerClass, dest, j + 2);
            if (innerName != 0) {
                innerName = cp.copy(innerName, newCp, classnames);
            }
            ByteArray.write16bit(innerName, dest, j + 4);
            ByteArray.write16bit(innerAccess, dest, j + 6);
            j += 8;
        }
        return attr;
    }
}

