/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.jsp.el;

import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.PropertyNotWritableException;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.PageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplicitObjectELResolver
extends ELResolver {
    public Object getValue(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base != null) {
            return null;
        }
        PageContext ctxt = (PageContext)context.getContext(JspContext.class);
        if ("pageContext".equals(property)) {
            context.setPropertyResolved(true);
            return ctxt;
        }
        ImplicitObjects implicitObjects = ImplicitObjects.getImplicitObjects(ctxt);
        if ("pageScope".equals(property)) {
            context.setPropertyResolved(true);
            return implicitObjects.getPageScopeMap();
        }
        if ("requestScope".equals(property)) {
            context.setPropertyResolved(true);
            return implicitObjects.getRequestScopeMap();
        }
        if ("sessionScope".equals(property)) {
            context.setPropertyResolved(true);
            return implicitObjects.getSessionScopeMap();
        }
        if ("applicationScope".equals(property)) {
            context.setPropertyResolved(true);
            return implicitObjects.getApplicationScopeMap();
        }
        if ("param".equals(property)) {
            context.setPropertyResolved(true);
            return implicitObjects.getParamMap();
        }
        if ("paramValues".equals(property)) {
            context.setPropertyResolved(true);
            return implicitObjects.getParamsMap();
        }
        if ("header".equals(property)) {
            context.setPropertyResolved(true);
            return implicitObjects.getHeaderMap();
        }
        if ("headerValues".equals(property)) {
            context.setPropertyResolved(true);
            return implicitObjects.getHeadersMap();
        }
        if ("initParam".equals(property)) {
            context.setPropertyResolved(true);
            return implicitObjects.getInitParamMap();
        }
        if ("cookie".equals(property)) {
            context.setPropertyResolved(true);
            return implicitObjects.getCookieMap();
        }
        return null;
    }

    public Class getType(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null && ("pageContext".equals(property) || "pageScope".equals(property)) || "requestScope".equals(property) || "sessionScope".equals(property) || "applicationScope".equals(property) || "param".equals(property) || "paramValues".equals(property) || "header".equals(property) || "headerValues".equals(property) || "initParam".equals(property) || "cookie".equals(property)) {
            context.setPropertyResolved(true);
        }
        return null;
    }

    public void setValue(ELContext context, Object base, Object property, Object val2) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null && ("pageContext".equals(property) || "pageScope".equals(property)) || "requestScope".equals(property) || "sessionScope".equals(property) || "applicationScope".equals(property) || "param".equals(property) || "paramValues".equals(property) || "header".equals(property) || "headerValues".equals(property) || "initParam".equals(property) || "cookie".equals(property)) {
            throw new PropertyNotWritableException();
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null && ("pageContext".equals(property) || "pageScope".equals(property)) || "requestScope".equals(property) || "sessionScope".equals(property) || "applicationScope".equals(property) || "param".equals(property) || "paramValues".equals(property) || "header".equals(property) || "headerValues".equals(property) || "initParam".equals(property) || "cookie".equals(property)) {
            context.setPropertyResolved(true);
            return true;
        }
        return false;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        ArrayList<FeatureDescriptor> list = new ArrayList<FeatureDescriptor>(11);
        FeatureDescriptor descriptor2 = new FeatureDescriptor();
        descriptor2.setName("pageContext");
        descriptor2.setDisplayName("pageContext");
        descriptor2.setExpert(false);
        descriptor2.setHidden(false);
        descriptor2.setPreferred(true);
        descriptor2.setValue("type", PageContext.class);
        descriptor2.setValue("resolvableAtDesignTime", Boolean.TRUE);
        list.add(descriptor2);
        descriptor2 = new FeatureDescriptor();
        descriptor2.setName("pageScope");
        descriptor2.setDisplayName("pageScope");
        descriptor2.setExpert(false);
        descriptor2.setHidden(false);
        descriptor2.setPreferred(true);
        descriptor2.setValue("type", Map.class);
        descriptor2.setValue("resolvableAtDesignTime", Boolean.TRUE);
        list.add(descriptor2);
        descriptor2 = new FeatureDescriptor();
        descriptor2.setName("requestScope");
        descriptor2.setDisplayName("requestScope");
        descriptor2.setExpert(false);
        descriptor2.setHidden(false);
        descriptor2.setPreferred(true);
        descriptor2.setValue("type", Map.class);
        descriptor2.setValue("resolvableAtDesignTime", Boolean.TRUE);
        list.add(descriptor2);
        descriptor2 = new FeatureDescriptor();
        descriptor2.setName("sessionScope");
        descriptor2.setDisplayName("sessionScope");
        descriptor2.setExpert(false);
        descriptor2.setHidden(false);
        descriptor2.setPreferred(true);
        descriptor2.setValue("type", Map.class);
        descriptor2.setValue("resolvableAtDesignTime", Boolean.TRUE);
        list.add(descriptor2);
        descriptor2 = new FeatureDescriptor();
        descriptor2.setName("applicationScope");
        descriptor2.setDisplayName("applicationScope");
        descriptor2.setExpert(false);
        descriptor2.setHidden(false);
        descriptor2.setPreferred(true);
        descriptor2.setValue("type", Map.class);
        descriptor2.setValue("resolvableAtDesignTime", Boolean.TRUE);
        list.add(descriptor2);
        descriptor2 = new FeatureDescriptor();
        descriptor2.setName("param");
        descriptor2.setDisplayName("param");
        descriptor2.setExpert(false);
        descriptor2.setHidden(false);
        descriptor2.setPreferred(true);
        descriptor2.setValue("type", Map.class);
        descriptor2.setValue("resolvableAtDesignTime", Boolean.TRUE);
        list.add(descriptor2);
        descriptor2 = new FeatureDescriptor();
        descriptor2.setName("paramValues");
        descriptor2.setDisplayName("paramValues");
        descriptor2.setExpert(false);
        descriptor2.setHidden(false);
        descriptor2.setPreferred(true);
        descriptor2.setValue("type", Map.class);
        descriptor2.setValue("resolvableAtDesignTime", Boolean.TRUE);
        list.add(descriptor2);
        descriptor2 = new FeatureDescriptor();
        descriptor2.setName("header");
        descriptor2.setDisplayName("header");
        descriptor2.setExpert(false);
        descriptor2.setHidden(false);
        descriptor2.setPreferred(true);
        descriptor2.setValue("type", Map.class);
        descriptor2.setValue("resolvableAtDesignTime", Boolean.TRUE);
        list.add(descriptor2);
        descriptor2 = new FeatureDescriptor();
        descriptor2.setName("headerValues");
        descriptor2.setDisplayName("headerValues");
        descriptor2.setExpert(false);
        descriptor2.setHidden(false);
        descriptor2.setPreferred(true);
        descriptor2.setValue("type", Map.class);
        descriptor2.setValue("resolvableAtDesignTime", Boolean.TRUE);
        list.add(descriptor2);
        descriptor2 = new FeatureDescriptor();
        descriptor2.setName("cookie");
        descriptor2.setDisplayName("cookie");
        descriptor2.setExpert(false);
        descriptor2.setHidden(false);
        descriptor2.setPreferred(true);
        descriptor2.setValue("type", Map.class);
        descriptor2.setValue("resolvableAtDesignTime", Boolean.TRUE);
        list.add(descriptor2);
        descriptor2 = new FeatureDescriptor();
        descriptor2.setName("initParam");
        descriptor2.setDisplayName("initParam");
        descriptor2.setExpert(false);
        descriptor2.setHidden(false);
        descriptor2.setPreferred(true);
        descriptor2.setValue("type", Map.class);
        descriptor2.setValue("resolvableAtDesignTime", Boolean.TRUE);
        list.add(descriptor2);
        return list.iterator();
    }

    public Class<String> getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            return String.class;
        }
        return null;
    }

    private static abstract class EnumeratedMap
    implements Map {
        Map mMap;

        private EnumeratedMap() {
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean containsKey(Object pKey) {
            return this.getValue(pKey) != null;
        }

        public boolean containsValue(Object pValue) {
            return this.getAsMap().containsValue(pValue);
        }

        public Set entrySet() {
            return this.getAsMap().entrySet();
        }

        public Object get(Object pKey) {
            return this.getValue(pKey);
        }

        public boolean isEmpty() {
            return !this.enumerateKeys().hasMoreElements();
        }

        public Set keySet() {
            return this.getAsMap().keySet();
        }

        public Object put(Object pKey, Object pValue) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map pMap) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object pKey) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.getAsMap().size();
        }

        public Collection values() {
            return this.getAsMap().values();
        }

        public abstract Enumeration enumerateKeys();

        public abstract boolean isMutable();

        public abstract Object getValue(Object var1);

        public Map getAsMap() {
            if (this.mMap != null) {
                return this.mMap;
            }
            Map m = this.convertToMap();
            if (!this.isMutable()) {
                this.mMap = m;
            }
            return m;
        }

        Map convertToMap() {
            HashMap ret = new HashMap();
            Enumeration e2 = this.enumerateKeys();
            while (e2.hasMoreElements()) {
                Object key2 = e2.nextElement();
                Object value = this.getValue(key2);
                ret.put(key2, value);
            }
            return ret;
        }
    }

    private static class ImplicitObjects {
        static final String sAttributeName = "org.apache.taglibs.standard.ImplicitObjects";
        PageContext mContext;
        Map mPage;
        Map mRequest;
        Map mSession;
        Map mApplication;
        Map mParam;
        Map mParams;
        Map mHeader;
        Map mHeaders;
        Map mInitParam;
        Map mCookie;

        public ImplicitObjects(PageContext pContext) {
            this.mContext = pContext;
        }

        public static ImplicitObjects getImplicitObjects(PageContext pContext) {
            ImplicitObjects objs = (ImplicitObjects)pContext.getAttribute(sAttributeName, 1);
            if (objs == null) {
                objs = new ImplicitObjects(pContext);
                pContext.setAttribute(sAttributeName, objs, 1);
            }
            return objs;
        }

        public Map getPageScopeMap() {
            if (this.mPage == null) {
                this.mPage = ImplicitObjects.createPageScopeMap(this.mContext);
            }
            return this.mPage;
        }

        public Map getRequestScopeMap() {
            if (this.mRequest == null) {
                this.mRequest = ImplicitObjects.createRequestScopeMap(this.mContext);
            }
            return this.mRequest;
        }

        public Map getSessionScopeMap() {
            if (this.mSession == null) {
                this.mSession = ImplicitObjects.createSessionScopeMap(this.mContext);
            }
            return this.mSession;
        }

        public Map getApplicationScopeMap() {
            if (this.mApplication == null) {
                this.mApplication = ImplicitObjects.createApplicationScopeMap(this.mContext);
            }
            return this.mApplication;
        }

        public Map getParamMap() {
            if (this.mParam == null) {
                this.mParam = ImplicitObjects.createParamMap(this.mContext);
            }
            return this.mParam;
        }

        public Map getParamsMap() {
            if (this.mParams == null) {
                this.mParams = ImplicitObjects.createParamsMap(this.mContext);
            }
            return this.mParams;
        }

        public Map getHeaderMap() {
            if (this.mHeader == null) {
                this.mHeader = ImplicitObjects.createHeaderMap(this.mContext);
            }
            return this.mHeader;
        }

        public Map getHeadersMap() {
            if (this.mHeaders == null) {
                this.mHeaders = ImplicitObjects.createHeadersMap(this.mContext);
            }
            return this.mHeaders;
        }

        public Map getInitParamMap() {
            if (this.mInitParam == null) {
                this.mInitParam = ImplicitObjects.createInitParamMap(this.mContext);
            }
            return this.mInitParam;
        }

        public Map getCookieMap() {
            if (this.mCookie == null) {
                this.mCookie = ImplicitObjects.createCookieMap(this.mContext);
            }
            return this.mCookie;
        }

        public static Map createPageScopeMap(PageContext pContext) {
            final PageContext context = pContext;
            return new EnumeratedMap(){

                public Enumeration enumerateKeys() {
                    return context.getAttributeNamesInScope(1);
                }

                public Object getValue(Object pKey) {
                    if (pKey instanceof String) {
                        return context.getAttribute((String)pKey, 1);
                    }
                    return null;
                }

                public boolean isMutable() {
                    return true;
                }
            };
        }

        public static Map createRequestScopeMap(PageContext pContext) {
            final PageContext context = pContext;
            return new EnumeratedMap(){

                public Enumeration enumerateKeys() {
                    return context.getAttributeNamesInScope(2);
                }

                public Object getValue(Object pKey) {
                    if (pKey instanceof String) {
                        return context.getAttribute((String)pKey, 2);
                    }
                    return null;
                }

                public boolean isMutable() {
                    return true;
                }
            };
        }

        public static Map createSessionScopeMap(PageContext pContext) {
            final PageContext context = pContext;
            return new EnumeratedMap(){

                public Enumeration enumerateKeys() {
                    return context.getAttributeNamesInScope(3);
                }

                public Object getValue(Object pKey) {
                    if (pKey instanceof String) {
                        return context.getAttribute((String)pKey, 3);
                    }
                    return null;
                }

                public boolean isMutable() {
                    return true;
                }
            };
        }

        public static Map createApplicationScopeMap(PageContext pContext) {
            final PageContext context = pContext;
            return new EnumeratedMap(){

                public Enumeration enumerateKeys() {
                    return context.getAttributeNamesInScope(4);
                }

                public Object getValue(Object pKey) {
                    if (pKey instanceof String) {
                        return context.getAttribute((String)pKey, 4);
                    }
                    return null;
                }

                public boolean isMutable() {
                    return true;
                }
            };
        }

        public static Map createParamMap(PageContext pContext) {
            final HttpServletRequest request = (HttpServletRequest)pContext.getRequest();
            return new EnumeratedMap(){

                public Enumeration enumerateKeys() {
                    return request.getParameterNames();
                }

                public Object getValue(Object pKey) {
                    if (pKey instanceof String) {
                        return request.getParameter((String)pKey);
                    }
                    return null;
                }

                public boolean isMutable() {
                    return false;
                }
            };
        }

        public static Map createParamsMap(PageContext pContext) {
            final HttpServletRequest request = (HttpServletRequest)pContext.getRequest();
            return new EnumeratedMap(){

                public Enumeration enumerateKeys() {
                    return request.getParameterNames();
                }

                public Object getValue(Object pKey) {
                    if (pKey instanceof String) {
                        return request.getParameterValues((String)pKey);
                    }
                    return null;
                }

                public boolean isMutable() {
                    return false;
                }
            };
        }

        public static Map createHeaderMap(PageContext pContext) {
            final HttpServletRequest request = (HttpServletRequest)pContext.getRequest();
            return new EnumeratedMap(){

                public Enumeration enumerateKeys() {
                    return request.getHeaderNames();
                }

                public Object getValue(Object pKey) {
                    if (pKey instanceof String) {
                        return request.getHeader((String)pKey);
                    }
                    return null;
                }

                public boolean isMutable() {
                    return false;
                }
            };
        }

        public static Map createHeadersMap(PageContext pContext) {
            final HttpServletRequest request = (HttpServletRequest)pContext.getRequest();
            return new EnumeratedMap(){

                public Enumeration enumerateKeys() {
                    return request.getHeaderNames();
                }

                public Object getValue(Object pKey) {
                    if (pKey instanceof String) {
                        ArrayList<String> l = new ArrayList<String>();
                        Enumeration<String> e2 = request.getHeaders((String)pKey);
                        if (e2 != null) {
                            while (e2.hasMoreElements()) {
                                l.add(e2.nextElement());
                            }
                        }
                        String[] ret = l.toArray(new String[l.size()]);
                        return ret;
                    }
                    return null;
                }

                public boolean isMutable() {
                    return false;
                }
            };
        }

        public static Map createInitParamMap(PageContext pContext) {
            final ServletContext context = pContext.getServletContext();
            return new EnumeratedMap(){

                public Enumeration enumerateKeys() {
                    return context.getInitParameterNames();
                }

                public Object getValue(Object pKey) {
                    if (pKey instanceof String) {
                        return context.getInitParameter((String)pKey);
                    }
                    return null;
                }

                public boolean isMutable() {
                    return false;
                }
            };
        }

        public static Map createCookieMap(PageContext pContext) {
            HttpServletRequest request = (HttpServletRequest)pContext.getRequest();
            Cookie[] cookies = request.getCookies();
            HashMap<String, Cookie> ret = new HashMap<String, Cookie>();
            for (int i = 0; cookies != null && i < cookies.length; ++i) {
                String name2;
                Cookie cookie = cookies[i];
                if (cookie == null || ret.containsKey(name2 = cookie.getName())) continue;
                ret.put(name2, cookie);
            }
            return ret;
        }
    }
}

