/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.manager;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerServlet;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Manager;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.Session;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.ExpandWar;
import org.apache.catalina.util.ContextName;
import org.apache.catalina.util.IOTools;
import org.apache.catalina.util.ServerInfo;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.apache.tomcat.util.Diagnostics;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.net.SSLContext;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.security.Escape;

public class ManagerServlet
extends HttpServlet
implements ContainerServlet {
    private static final long serialVersionUID = 1L;
    protected File configBase = null;
    protected transient Context context = null;
    protected int debug = 1;
    protected File versioned = null;
    protected transient Host host = null;
    protected transient MBeanServer mBeanServer = null;
    protected ObjectName oname = null;
    protected transient javax.naming.Context global = null;
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.manager");
    protected transient Wrapper wrapper = null;

    @Override
    public Wrapper getWrapper() {
        return this.wrapper;
    }

    @Override
    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
        if (wrapper == null) {
            this.context = null;
            this.host = null;
            this.oname = null;
        } else {
            this.context = (Context)wrapper.getParent();
            this.host = (Host)this.context.getParent();
            Engine engine = (Engine)this.host.getParent();
            String name2 = engine.getName() + ":type=Deployer,host=" + this.host.getName();
            try {
                this.oname = new ObjectName(name2);
            }
            catch (Exception e2) {
                this.log(sm.getString("managerServlet.objectNameFail", name2), e2);
            }
        }
        this.mBeanServer = Registry.getRegistry(null, null).getMBeanServer();
    }

    @Override
    public void destroy() {
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        StringManager smClient = StringManager.getManager("org.apache.catalina.manager", request.getLocales());
        String command = request.getPathInfo();
        if (command == null) {
            command = request.getServletPath();
        }
        String path2 = request.getParameter("path");
        String war = request.getParameter("war");
        String config = request.getParameter("config");
        ContextName cn = null;
        if (path2 != null) {
            cn = new ContextName(path2, request.getParameter("version"));
        } else if (config != null) {
            cn = ContextName.extractFromPath(config);
        } else if (war != null) {
            cn = ContextName.extractFromPath(war);
        }
        String type2 = request.getParameter("type");
        String tag = request.getParameter("tag");
        boolean update2 = false;
        if (request.getParameter("update") != null && request.getParameter("update").equals("true")) {
            update2 = true;
        }
        String tlsHostName = request.getParameter("tlsHostName");
        boolean statusLine = false;
        if ("true".equals(request.getParameter("statusLine"))) {
            statusLine = true;
        }
        response.setContentType("text/plain; charset=utf-8");
        response.setHeader("X-Content-Type-Options", "nosniff");
        PrintWriter writer2 = response.getWriter();
        if (command == null) {
            writer2.println(smClient.getString("managerServlet.noCommand"));
        } else if (command.equals("/deploy")) {
            if (war != null || config != null) {
                this.deploy(writer2, config, cn, war, update2, smClient);
            } else if (tag != null) {
                this.deploy(writer2, cn, tag, smClient);
            } else {
                writer2.println(smClient.getString("managerServlet.invalidCommand", command));
            }
        } else if (command.equals("/list")) {
            this.list(writer2, smClient);
        } else if (command.equals("/reload")) {
            this.reload(writer2, cn, smClient);
        } else if (command.equals("/resources")) {
            this.resources(writer2, type2, smClient);
        } else if (command.equals("/save")) {
            this.save(writer2, path2, smClient);
        } else if (command.equals("/serverinfo")) {
            this.serverinfo(writer2, smClient);
        } else if (command.equals("/sessions")) {
            this.expireSessions(writer2, cn, request, smClient);
        } else if (command.equals("/expire")) {
            this.expireSessions(writer2, cn, request, smClient);
        } else if (command.equals("/start")) {
            this.start(writer2, cn, smClient);
        } else if (command.equals("/stop")) {
            this.stop(writer2, cn, smClient);
        } else if (command.equals("/undeploy")) {
            this.undeploy(writer2, cn, smClient);
        } else if (command.equals("/findleaks")) {
            this.findleaks(statusLine, writer2, smClient);
        } else if (command.equals("/vminfo")) {
            this.vmInfo(writer2, smClient, request.getLocales());
        } else if (command.equals("/threaddump")) {
            this.threadDump(writer2, smClient, request.getLocales());
        } else if (command.equals("/sslConnectorCiphers")) {
            this.sslConnectorCiphers(writer2, smClient);
        } else if (command.equals("/sslConnectorCerts")) {
            this.sslConnectorCerts(writer2, smClient);
        } else if (command.equals("/sslConnectorTrustedCerts")) {
            this.sslConnectorTrustedCerts(writer2, smClient);
        } else if (command.equals("/sslReload")) {
            this.sslReload(writer2, tlsHostName, smClient);
        } else {
            writer2.println(smClient.getString("managerServlet.unknownCommand", command));
        }
        writer2.flush();
        writer2.close();
    }

    @Override
    public void doPut(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        StringManager smClient = StringManager.getManager("org.apache.catalina.manager", request.getLocales());
        String command = request.getPathInfo();
        if (command == null) {
            command = request.getServletPath();
        }
        String path2 = request.getParameter("path");
        ContextName cn = null;
        if (path2 != null) {
            cn = new ContextName(path2, request.getParameter("version"));
        }
        String config = request.getParameter("config");
        String tag = request.getParameter("tag");
        boolean update2 = false;
        if (request.getParameter("update") != null && request.getParameter("update").equals("true")) {
            update2 = true;
        }
        response.setContentType("text/plain;charset=utf-8");
        response.setHeader("X-Content-Type-Options", "nosniff");
        PrintWriter writer2 = response.getWriter();
        if (command == null) {
            writer2.println(smClient.getString("managerServlet.noCommand"));
        } else if (command.equals("/deploy")) {
            this.deploy(writer2, config, cn, tag, update2, request, smClient);
        } else {
            writer2.println(smClient.getString("managerServlet.unknownCommand", command));
        }
        writer2.flush();
        writer2.close();
    }

    @Override
    public void init() throws ServletException {
        if (this.wrapper == null || this.context == null) {
            throw new UnavailableException(sm.getString("managerServlet.noWrapper"));
        }
        String value = null;
        try {
            value = this.getServletConfig().getInitParameter("debug");
            this.debug = Integer.parseInt(value);
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
        }
        Server server2 = ((Engine)this.host.getParent()).getService().getServer();
        if (server2 != null) {
            this.global = server2.getGlobalNamingContext();
        }
        this.versioned = (File)this.getServletContext().getAttribute("javax.servlet.context.tempdir");
        this.configBase = new File(this.context.getCatalinaBase(), "conf");
        Context host = null;
        Context engine = null;
        for (Container container = this.context; container != null; container = container.getParent()) {
            if (container instanceof Host) {
                host = container;
            }
            if (!(container instanceof Engine)) continue;
            engine = container;
        }
        if (engine != null) {
            this.configBase = new File(this.configBase, engine.getName());
        }
        if (host != null) {
            this.configBase = new File(this.configBase, host.getName());
        }
        if (this.debug >= 1) {
            this.log("init: Associated with Deployer '" + this.oname + "'");
            if (this.global != null) {
                this.log("init: Global resources are available");
            }
        }
    }

    protected void findleaks(boolean statusLine, PrintWriter writer2, StringManager smClient) {
        if (!(this.host instanceof StandardHost)) {
            writer2.println(smClient.getString("managerServlet.findleaksFail"));
            return;
        }
        String[] results = ((StandardHost)this.host).findReloadedContextMemoryLeaks();
        if (results.length > 0) {
            if (statusLine) {
                writer2.println(smClient.getString("managerServlet.findleaksList"));
            }
            for (String result : results) {
                if ("".equals(result)) {
                    result = "/";
                }
                writer2.println(result);
            }
        } else if (statusLine) {
            writer2.println(smClient.getString("managerServlet.findleaksNone"));
        }
    }

    protected void sslReload(PrintWriter writer2, String tlsHostName, StringManager smClient) {
        Connector[] connectors = this.getConnectors();
        boolean found = false;
        for (Connector connector : connectors) {
            SSLHostConfig[] sslHostConfigs;
            ProtocolHandler protocol;
            if (!Boolean.TRUE.equals(connector.getProperty("SSLEnabled")) || !((protocol = connector.getProtocolHandler()) instanceof AbstractHttp11Protocol)) continue;
            AbstractHttp11Protocol http11Protoocol = (AbstractHttp11Protocol)protocol;
            if (tlsHostName == null || tlsHostName.length() == 0) {
                found = true;
                http11Protoocol.reloadSslHostConfigs();
                continue;
            }
            for (SSLHostConfig sslHostConfig : sslHostConfigs = http11Protoocol.findSslHostConfigs()) {
                if (!sslHostConfig.getHostName().equalsIgnoreCase(tlsHostName)) continue;
                found = true;
                http11Protoocol.reloadSslHostConfig(tlsHostName);
            }
        }
        if (found) {
            if (tlsHostName == null || tlsHostName.length() == 0) {
                writer2.println(smClient.getString("managerServlet.sslReloadAll"));
            } else {
                writer2.println(smClient.getString("managerServlet.sslReload", tlsHostName));
            }
        } else {
            writer2.println(smClient.getString("managerServlet.sslReloadFail"));
        }
    }

    protected void vmInfo(PrintWriter writer2, StringManager smClient, Enumeration<Locale> requestedLocales) {
        writer2.println(smClient.getString("managerServlet.vminfo"));
        writer2.print(Diagnostics.getVMInfo(requestedLocales));
    }

    protected void threadDump(PrintWriter writer2, StringManager smClient, Enumeration<Locale> requestedLocales) {
        writer2.println(smClient.getString("managerServlet.threaddump"));
        writer2.print(Diagnostics.getThreadDump(requestedLocales));
    }

    protected void sslConnectorCiphers(PrintWriter writer2, StringManager smClient) {
        writer2.println(smClient.getString("managerServlet.sslConnectorCiphers"));
        Map<String, List<String>> connectorCiphers = this.getConnectorCiphers(smClient);
        for (Map.Entry<String, List<String>> entry : connectorCiphers.entrySet()) {
            writer2.println(entry.getKey());
            for (String cipher : entry.getValue()) {
                writer2.print("  ");
                writer2.println(cipher);
            }
        }
    }

    private void sslConnectorCerts(PrintWriter writer2, StringManager smClient) {
        writer2.println(smClient.getString("managerServlet.sslConnectorCerts"));
        Map<String, List<String>> connectorCerts = this.getConnectorCerts(smClient);
        for (Map.Entry<String, List<String>> entry : connectorCerts.entrySet()) {
            writer2.println(entry.getKey());
            for (String cert : entry.getValue()) {
                writer2.println(cert);
            }
        }
    }

    private void sslConnectorTrustedCerts(PrintWriter writer2, StringManager smClient) {
        writer2.println(smClient.getString("managerServlet.sslConnectorTrustedCerts"));
        Map<String, List<String>> connectorTrustedCerts = this.getConnectorTrustedCerts(smClient);
        for (Map.Entry<String, List<String>> entry : connectorTrustedCerts.entrySet()) {
            writer2.println(entry.getKey());
            for (String cert : entry.getValue()) {
                writer2.println(cert);
            }
        }
    }

    protected synchronized void save(PrintWriter writer2, String path2, StringManager smClient) {
        ObjectName storeConfigOname;
        try {
            storeConfigOname = new ObjectName("Catalina:type=StoreConfig");
        }
        catch (MalformedObjectNameException e2) {
            this.log(sm.getString("managerServlet.exception"), e2);
            writer2.println(smClient.getString("managerServlet.exception", e2.toString()));
            return;
        }
        if (!this.mBeanServer.isRegistered(storeConfigOname)) {
            writer2.println(smClient.getString("managerServlet.storeConfig.noMBean", storeConfigOname));
            return;
        }
        if (path2 == null || path2.length() == 0 || !path2.startsWith("/")) {
            try {
                this.mBeanServer.invoke(storeConfigOname, "storeConfig", null, null);
                writer2.println(smClient.getString("managerServlet.saved"));
            }
            catch (Exception e3) {
                this.log(sm.getString("managerServlet.error.storeConfig"), e3);
                writer2.println(smClient.getString("managerServlet.exception", e3.toString()));
            }
        } else {
            Context context;
            String contextPath = path2;
            if (path2.equals("/")) {
                contextPath = "";
            }
            if ((context = (Context)this.host.findChild(contextPath)) == null) {
                writer2.println(smClient.getString("managerServlet.noContext", path2));
                return;
            }
            try {
                Boolean result = (Boolean)this.mBeanServer.invoke(storeConfigOname, "store", new Object[]{context}, new String[]{"org.apache.catalina.Context"});
                if (result.booleanValue()) {
                    writer2.println(smClient.getString("managerServlet.savedContext", path2));
                } else {
                    writer2.println(smClient.getString("managerServlet.savedContextFail", path2));
                }
            }
            catch (Exception e4) {
                this.log(sm.getString("managerServlet.error.storeContextConfig", path2), e4);
                writer2.println(smClient.getString("managerServlet.exception", e4.toString()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void deploy(PrintWriter writer2, String config, ContextName cn, String tag, boolean update2, HttpServletRequest request, StringManager smClient) {
        String displayPath;
        String name2;
        block30: {
            File uploadedWar;
            if (config != null && config.length() == 0) {
                config = null;
            }
            if (this.debug >= 1) {
                if (config == null) {
                    this.log("deploy: Deploying web application '" + cn + "'");
                } else {
                    this.log("deploy: Deploying web application '" + cn + "' with context configuration at '" + config + "'");
                }
            }
            if (!ManagerServlet.validateContextName(cn, writer2, smClient)) {
                return;
            }
            name2 = cn.getName();
            String baseName = cn.getBaseName();
            displayPath = cn.getDisplayName();
            Context context = (Context)this.host.findChild(name2);
            if (context != null && !update2) {
                writer2.println(smClient.getString("managerServlet.alreadyContext", displayPath));
                return;
            }
            if (config != null && config.startsWith("file:")) {
                config = config.substring("file:".length());
            }
            File deployedWar = new File(this.host.getAppBaseFile(), baseName + ".war");
            if (tag == null) {
                if (update2) {
                    uploadedWar = new File(deployedWar.getAbsolutePath() + ".tmp");
                    if (uploadedWar.exists() && !uploadedWar.delete()) {
                        writer2.println(smClient.getString("managerServlet.deleteFail", uploadedWar));
                    }
                } else {
                    uploadedWar = deployedWar;
                }
            } else {
                File uploadPath = new File(this.versioned, tag);
                if (!uploadPath.mkdirs() && !uploadPath.isDirectory()) {
                    writer2.println(smClient.getString("managerServlet.mkdirFail", uploadPath));
                    return;
                }
                uploadedWar = new File(uploadPath, baseName + ".war");
            }
            if (this.debug >= 2) {
                this.log("Uploading WAR file to " + uploadedWar);
            }
            try {
                if (this.isServiced(name2)) {
                    writer2.println(smClient.getString("managerServlet.inService", displayPath));
                    break block30;
                }
                this.addServiced(name2);
                try {
                    if (config != null) {
                        if (!this.configBase.mkdirs() && !this.configBase.isDirectory()) {
                            writer2.println(smClient.getString("managerServlet.mkdirFail", this.configBase));
                            return;
                        }
                        if (!ExpandWar.copy(new File(config), new File(this.configBase, baseName + ".xml"))) {
                            throw new Exception(sm.getString("managerServlet.copyError", config));
                        }
                    }
                    this.uploadWar(writer2, request, uploadedWar, smClient);
                    if (update2 && tag == null) {
                        if (deployedWar.exists() && !deployedWar.delete()) {
                            writer2.println(smClient.getString("managerServlet.deleteFail", deployedWar));
                            return;
                        }
                        if (!uploadedWar.renameTo(deployedWar)) {
                            writer2.println(smClient.getString("managerServlet.renameFail", uploadedWar, deployedWar));
                            return;
                        }
                    }
                    if (tag != null) {
                        ExpandWar.copy(uploadedWar, deployedWar);
                    }
                    this.check(name2);
                }
                finally {
                    this.removeServiced(name2);
                }
            }
            catch (Exception e2) {
                this.log(sm.getString("managerServlet.error.deploy", displayPath), e2);
                writer2.println(smClient.getString("managerServlet.exception", e2.toString()));
                return;
            }
        }
        this.writeDeployResult(writer2, smClient, name2, displayPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deploy(PrintWriter writer2, ContextName cn, String tag, StringManager smClient) {
        String displayPath;
        String name2;
        block9: {
            if (!ManagerServlet.validateContextName(cn, writer2, smClient)) {
                return;
            }
            String baseName = cn.getBaseName();
            name2 = cn.getName();
            displayPath = cn.getDisplayName();
            File localWar = new File(new File(this.versioned, tag), baseName + ".war");
            File deployedWar = new File(this.host.getAppBaseFile(), baseName + ".war");
            try {
                if (this.isServiced(name2)) {
                    writer2.println(smClient.getString("managerServlet.inService", displayPath));
                    break block9;
                }
                this.addServiced(name2);
                try {
                    if (!deployedWar.delete()) {
                        writer2.println(smClient.getString("managerServlet.deleteFail", deployedWar));
                        return;
                    }
                    ExpandWar.copy(localWar, deployedWar);
                    this.check(name2);
                }
                finally {
                    this.removeServiced(name2);
                }
            }
            catch (Exception e2) {
                this.log(sm.getString("managerServlet.error.deploy", displayPath), e2);
                writer2.println(smClient.getString("managerServlet.exception", e2.toString()));
                return;
            }
        }
        this.writeDeployResult(writer2, smClient, name2, displayPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deploy(PrintWriter writer2, String config, ContextName cn, String war, boolean update2, StringManager smClient) {
        if (config != null && config.length() == 0) {
            config = null;
        }
        if (war != null && war.length() == 0) {
            war = null;
        }
        if (this.debug >= 1) {
            if (config != null) {
                if (war != null) {
                    this.log("install: Installing context configuration at '" + config + "' from '" + war + "'");
                } else {
                    this.log("install: Installing context configuration at '" + config + "'");
                }
            } else if (cn != null) {
                this.log("install: Installing web application '" + cn + "' from '" + war + "'");
            } else {
                this.log("install: Installing web application from '" + war + "'");
            }
        }
        if (!ManagerServlet.validateContextName(cn, writer2, smClient)) {
            return;
        }
        String name2 = cn.getName();
        String baseName = cn.getBaseName();
        String displayPath = cn.getDisplayName();
        Context context = (Context)this.host.findChild(name2);
        if (context != null && !update2) {
            writer2.println(smClient.getString("managerServlet.alreadyContext", displayPath));
            return;
        }
        if (config != null && config.startsWith("file:")) {
            config = config.substring("file:".length());
        }
        if (war != null && war.startsWith("file:")) {
            war = war.substring("file:".length());
        }
        try {
            if (this.isServiced(name2)) {
                writer2.println(smClient.getString("managerServlet.inService", displayPath));
            } else {
                this.addServiced(name2);
                try {
                    if (config != null) {
                        if (!this.configBase.mkdirs() && !this.configBase.isDirectory()) {
                            writer2.println(smClient.getString("managerServlet.mkdirFail", this.configBase));
                            return;
                        }
                        File localConfig = new File(this.configBase, baseName + ".xml");
                        if (localConfig.isFile() && !localConfig.delete()) {
                            writer2.println(smClient.getString("managerServlet.deleteFail", localConfig));
                            return;
                        }
                        ExpandWar.copy(new File(config), localConfig);
                    }
                    if (war != null) {
                        File localWar = war.endsWith(".war") ? new File(this.host.getAppBaseFile(), baseName + ".war") : new File(this.host.getAppBaseFile(), baseName);
                        if (localWar.exists() && !ExpandWar.delete(localWar)) {
                            writer2.println(smClient.getString("managerServlet.deleteFail", localWar));
                            return;
                        }
                        ExpandWar.copy(new File(war), localWar);
                    }
                    this.check(name2);
                }
                finally {
                    this.removeServiced(name2);
                }
            }
            this.writeDeployResult(writer2, smClient, name2, displayPath);
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            this.log(sm.getString("managerServlet.error.deploy", displayPath), t);
            writer2.println(smClient.getString("managerServlet.exception", t.toString()));
        }
    }

    private void writeDeployResult(PrintWriter writer2, StringManager smClient, String name2, String displayPath) {
        Context deployed = (Context)this.host.findChild(name2);
        if (deployed != null && deployed.getConfigured() && deployed.getState().isAvailable()) {
            writer2.println(smClient.getString("managerServlet.deployed", displayPath));
        } else if (deployed != null && !deployed.getState().isAvailable()) {
            writer2.println(smClient.getString("managerServlet.deployedButNotStarted", displayPath));
        } else {
            writer2.println(smClient.getString("managerServlet.deployFailed", displayPath));
        }
    }

    protected void list(PrintWriter writer2, StringManager smClient) {
        Container[] contexts;
        if (this.debug >= 1) {
            this.log("list: Listing contexts for virtual host '" + this.host.getName() + "'");
        }
        writer2.println(smClient.getString("managerServlet.listed", this.host.getName()));
        for (Container container : contexts = this.host.findChildren()) {
            Context context = (Context)container;
            if (context == null) continue;
            String displayPath = context.getPath();
            if (displayPath.equals("")) {
                displayPath = "/";
            }
            if (context.getState().isAvailable()) {
                writer2.println(smClient.getString("managerServlet.listitem", displayPath, "running", "" + context.getManager().findSessions().length, context.getDocBase()));
                continue;
            }
            writer2.println(smClient.getString("managerServlet.listitem", displayPath, "stopped", "0", context.getDocBase()));
        }
    }

    protected void reload(PrintWriter writer2, ContextName cn, StringManager smClient) {
        if (this.debug >= 1) {
            this.log("restart: Reloading web application '" + cn + "'");
        }
        if (!ManagerServlet.validateContextName(cn, writer2, smClient)) {
            return;
        }
        try {
            Context context = (Context)this.host.findChild(cn.getName());
            if (context == null) {
                writer2.println(smClient.getString("managerServlet.noContext", Escape.htmlElementContent(cn.getDisplayName())));
                return;
            }
            if (context.getName().equals(this.context.getName())) {
                writer2.println(smClient.getString("managerServlet.noSelf"));
                return;
            }
            context.reload();
            writer2.println(smClient.getString("managerServlet.reloaded", cn.getDisplayName()));
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            this.log(sm.getString("managerServlet.error.reload", cn.getDisplayName()), t);
            writer2.println(smClient.getString("managerServlet.exception", t.toString()));
        }
    }

    protected void resources(PrintWriter writer2, String type2, StringManager smClient) {
        if (this.debug >= 1) {
            if (type2 != null) {
                this.log("resources:  Listing resources of type " + type2);
            } else {
                this.log("resources:  Listing resources of all types");
            }
        }
        if (this.global == null) {
            writer2.println(smClient.getString("managerServlet.noGlobal"));
            return;
        }
        if (type2 != null) {
            writer2.println(smClient.getString("managerServlet.resourcesType", type2));
        } else {
            writer2.println(smClient.getString("managerServlet.resourcesAll"));
        }
        this.printResources(writer2, "", this.global, type2, smClient);
    }

    @Deprecated
    protected void printResources(PrintWriter writer2, String prefix, javax.naming.Context namingContext, String type2, Class<?> clazz, StringManager smClient) {
        this.printResources(writer2, prefix, namingContext, type2, smClient);
    }

    protected void printResources(PrintWriter writer2, String prefix, javax.naming.Context namingContext, String type2, StringManager smClient) {
        try {
            NamingEnumeration<Binding> items = namingContext.listBindings("");
            while (items.hasMore()) {
                Binding item = items.next();
                Object obj = item.getObject();
                if (obj instanceof javax.naming.Context) {
                    this.printResources(writer2, prefix + item.getName() + "/", (javax.naming.Context)obj, type2, smClient);
                    continue;
                }
                if (type2 != null && (obj == null || !IntrospectionUtils.isInstance(obj.getClass(), type2))) continue;
                writer2.print(prefix + item.getName());
                writer2.print(':');
                writer2.print(item.getClassName());
                writer2.println();
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            this.log(sm.getString("managerServlet.error.resources", type2), t);
            writer2.println(smClient.getString("managerServlet.exception", t.toString()));
        }
    }

    protected void serverinfo(PrintWriter writer2, StringManager smClient) {
        if (this.debug >= 1) {
            this.log("serverinfo");
        }
        try {
            writer2.println(smClient.getString("managerServlet.serverInfo", ServerInfo.getServerInfo(), System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), System.getProperty("java.runtime.version"), System.getProperty("java.vm.vendor")));
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            this.log(sm.getString("managerServlet.error.serverInfo"), t);
            writer2.println(smClient.getString("managerServlet.exception", t.toString()));
        }
    }

    protected void sessions(PrintWriter writer2, ContextName cn, int idle, StringManager smClient) {
        if (this.debug >= 1) {
            this.log("sessions: Session information for web application '" + cn + "'");
            if (idle >= 0) {
                this.log("sessions: Session expiration for " + idle + " minutes '" + cn + "'");
            }
        }
        if (!ManagerServlet.validateContextName(cn, writer2, smClient)) {
            return;
        }
        String displayPath = cn.getDisplayName();
        try {
            Context context = (Context)this.host.findChild(cn.getName());
            if (context == null) {
                writer2.println(smClient.getString("managerServlet.noContext", Escape.htmlElementContent(displayPath)));
                return;
            }
            Manager manager = context.getManager();
            if (manager == null) {
                writer2.println(smClient.getString("managerServlet.noManager", Escape.htmlElementContent(displayPath)));
                return;
            }
            int maxCount = 60;
            int histoInterval = 1;
            int maxInactiveInterval = context.getSessionTimeout();
            if (maxInactiveInterval > 0) {
                histoInterval = maxInactiveInterval / maxCount;
                if (histoInterval * maxCount < maxInactiveInterval) {
                    ++histoInterval;
                }
                if (0 == histoInterval) {
                    histoInterval = 1;
                }
                if (histoInterval * (maxCount = maxInactiveInterval / histoInterval) < maxInactiveInterval) {
                    ++maxCount;
                }
            }
            writer2.println(smClient.getString("managerServlet.sessions", displayPath));
            writer2.println(smClient.getString("managerServlet.sessiondefaultmax", "" + maxInactiveInterval));
            Session[] sessions = manager.findSessions();
            int[] timeout = new int[maxCount + 1];
            int notimeout = 0;
            int expired = 0;
            for (Session session : sessions) {
                int time2 = (int)(session.getIdleTimeInternal() / 1000L);
                if (idle >= 0 && time2 >= idle * 60) {
                    session.expire();
                    ++expired;
                }
                if ((time2 = time2 / 60 / histoInterval) < 0) {
                    ++notimeout;
                    continue;
                }
                if (time2 >= maxCount) {
                    int n = maxCount;
                    timeout[n] = timeout[n] + 1;
                    continue;
                }
                int n = time2;
                timeout[n] = timeout[n] + 1;
            }
            if (timeout[0] > 0) {
                writer2.println(smClient.getString("managerServlet.sessiontimeout", "<" + histoInterval, "" + timeout[0]));
            }
            for (int i = 1; i < maxCount; ++i) {
                if (timeout[i] <= 0) continue;
                writer2.println(smClient.getString("managerServlet.sessiontimeout", "" + i * histoInterval + " - <" + (i + 1) * histoInterval, "" + timeout[i]));
            }
            if (timeout[maxCount] > 0) {
                writer2.println(smClient.getString("managerServlet.sessiontimeout", ">=" + maxCount * histoInterval, "" + timeout[maxCount]));
            }
            if (notimeout > 0) {
                writer2.println(smClient.getString("managerServlet.sessiontimeout.unlimited", "" + notimeout));
            }
            if (idle >= 0) {
                writer2.println(smClient.getString("managerServlet.sessiontimeout.expired", ">" + idle, "" + expired));
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            this.log(sm.getString("managerServlet.error.sessions", displayPath), t);
            writer2.println(smClient.getString("managerServlet.exception", t.toString()));
        }
    }

    protected void expireSessions(PrintWriter writer2, ContextName cn, HttpServletRequest req, StringManager smClient) {
        int idle = -1;
        String idleParam = req.getParameter("idle");
        if (idleParam != null) {
            try {
                idle = Integer.parseInt(idleParam);
            }
            catch (NumberFormatException e2) {
                this.log(sm.getString("managerServlet.error.idleParam", idleParam));
            }
        }
        this.sessions(writer2, cn, idle, smClient);
    }

    protected void start(PrintWriter writer2, ContextName cn, StringManager smClient) {
        if (this.debug >= 1) {
            this.log("start: Starting web application '" + cn + "'");
        }
        if (!ManagerServlet.validateContextName(cn, writer2, smClient)) {
            return;
        }
        String displayPath = cn.getDisplayName();
        try {
            Context context = (Context)this.host.findChild(cn.getName());
            if (context == null) {
                writer2.println(smClient.getString("managerServlet.noContext", Escape.htmlElementContent(displayPath)));
                return;
            }
            context.start();
            if (context.getState().isAvailable()) {
                writer2.println(smClient.getString("managerServlet.started", displayPath));
            } else {
                writer2.println(smClient.getString("managerServlet.startFailed", displayPath));
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            this.log(sm.getString("managerServlet.error.start", displayPath), t);
            writer2.println(smClient.getString("managerServlet.startFailed", displayPath));
            writer2.println(smClient.getString("managerServlet.exception", t.toString()));
        }
    }

    protected void stop(PrintWriter writer2, ContextName cn, StringManager smClient) {
        if (this.debug >= 1) {
            this.log("stop: Stopping web application '" + cn + "'");
        }
        if (!ManagerServlet.validateContextName(cn, writer2, smClient)) {
            return;
        }
        String displayPath = cn.getDisplayName();
        try {
            Context context = (Context)this.host.findChild(cn.getName());
            if (context == null) {
                writer2.println(smClient.getString("managerServlet.noContext", Escape.htmlElementContent(displayPath)));
                return;
            }
            if (context.getName().equals(this.context.getName())) {
                writer2.println(smClient.getString("managerServlet.noSelf"));
                return;
            }
            context.stop();
            writer2.println(smClient.getString("managerServlet.stopped", displayPath));
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            this.log(sm.getString("managerServlet.error.stop", displayPath), t);
            writer2.println(smClient.getString("managerServlet.exception", t.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void undeploy(PrintWriter writer2, ContextName cn, StringManager smClient) {
        if (this.debug >= 1) {
            this.log("undeploy: Undeploying web application at '" + cn + "'");
        }
        if (!ManagerServlet.validateContextName(cn, writer2, smClient)) {
            return;
        }
        String name2 = cn.getName();
        String baseName = cn.getBaseName();
        String displayPath = cn.getDisplayName();
        try {
            Context context = (Context)this.host.findChild(name2);
            if (context == null) {
                writer2.println(smClient.getString("managerServlet.noContext", Escape.htmlElementContent(displayPath)));
                return;
            }
            if (!this.isDeployed(name2)) {
                writer2.println(smClient.getString("managerServlet.notDeployed", Escape.htmlElementContent(displayPath)));
                return;
            }
            if (this.isServiced(name2)) {
                writer2.println(smClient.getString("managerServlet.inService", displayPath));
            } else {
                this.addServiced(name2);
                try {
                    context.stop();
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                }
                try {
                    File war = new File(this.host.getAppBaseFile(), baseName + ".war");
                    File dir2 = new File(this.host.getAppBaseFile(), baseName);
                    File xml2 = new File(this.configBase, baseName + ".xml");
                    if (war.exists() && !war.delete()) {
                        writer2.println(smClient.getString("managerServlet.deleteFail", war));
                        return;
                    }
                    if (dir2.exists() && !ExpandWar.delete(dir2, false)) {
                        writer2.println(smClient.getString("managerServlet.deleteFail", dir2));
                        return;
                    }
                    if (xml2.exists() && !xml2.delete()) {
                        writer2.println(smClient.getString("managerServlet.deleteFail", xml2));
                        return;
                    }
                    this.check(name2);
                }
                finally {
                    this.removeServiced(name2);
                }
            }
            writer2.println(smClient.getString("managerServlet.undeployed", displayPath));
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            this.log(sm.getString("managerServlet.error.undeploy", displayPath), t);
            writer2.println(smClient.getString("managerServlet.exception", t.toString()));
        }
    }

    protected boolean isDeployed(String name2) throws Exception {
        Object[] params = new String[]{name2};
        String[] signature = new String[]{"java.lang.String"};
        Boolean result = (Boolean)this.mBeanServer.invoke(this.oname, "isDeployed", params, signature);
        return result;
    }

    protected void check(String name2) throws Exception {
        Object[] params = new String[]{name2};
        String[] signature = new String[]{"java.lang.String"};
        this.mBeanServer.invoke(this.oname, "check", params, signature);
    }

    protected boolean isServiced(String name2) throws Exception {
        Object[] params = new String[]{name2};
        String[] signature = new String[]{"java.lang.String"};
        Boolean result = (Boolean)this.mBeanServer.invoke(this.oname, "isServiced", params, signature);
        return result;
    }

    protected void addServiced(String name2) throws Exception {
        Object[] params = new String[]{name2};
        String[] signature = new String[]{"java.lang.String"};
        this.mBeanServer.invoke(this.oname, "addServiced", params, signature);
    }

    protected void removeServiced(String name2) throws Exception {
        Object[] params = new String[]{name2};
        String[] signature = new String[]{"java.lang.String"};
        this.mBeanServer.invoke(this.oname, "removeServiced", params, signature);
    }

    protected void uploadWar(PrintWriter writer2, HttpServletRequest request, File war, StringManager smClient) throws IOException {
        if (war.exists() && !war.delete()) {
            String msg = smClient.getString("managerServlet.deleteFail", war);
            throw new IOException(msg);
        }
        try (ServletInputStream istream = request.getInputStream();
             FileOutputStream ostream = new FileOutputStream(war);){
            IOTools.flow(istream, ostream);
        }
        catch (IOException e2) {
            if (war.exists() && !war.delete()) {
                writer2.println(smClient.getString("managerServlet.deleteFail", war));
            }
            throw e2;
        }
    }

    protected static boolean validateContextName(ContextName cn, PrintWriter writer2, StringManager smClient) {
        if (cn != null && (cn.getPath().startsWith("/") || cn.getPath().equals(""))) {
            return true;
        }
        String path2 = null;
        if (cn != null) {
            path2 = Escape.htmlElementContent(cn.getPath());
        }
        writer2.println(smClient.getString("managerServlet.invalidPath", path2));
        return false;
    }

    protected Map<String, List<String>> getConnectorCiphers(StringManager smClient) {
        Connector[] connectors;
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (Connector connector : connectors = this.getConnectors()) {
            if (Boolean.TRUE.equals(connector.getProperty("SSLEnabled"))) {
                SSLHostConfig[] sslHostConfigs;
                for (SSLHostConfig sslHostConfig : sslHostConfigs = connector.getProtocolHandler().findSslHostConfigs()) {
                    String name2 = connector.toString() + "-" + sslHostConfig.getHostName();
                    result.put(name2, new ArrayList<String>(new LinkedHashSet<String>(Arrays.asList(sslHostConfig.getEnabledCiphers()))));
                }
                continue;
            }
            ArrayList<String> cipherList = new ArrayList<String>(1);
            cipherList.add(smClient.getString("managerServlet.notSslConnector"));
            result.put(connector.toString(), cipherList);
        }
        return result;
    }

    protected Map<String, List<String>> getConnectorCerts(StringManager smClient) {
        Connector[] connectors;
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (Connector connector : connectors = this.getConnectors()) {
            if (Boolean.TRUE.equals(connector.getProperty("SSLEnabled"))) {
                SSLHostConfig[] sslHostConfigs;
                for (SSLHostConfig sslHostConfig : sslHostConfigs = connector.getProtocolHandler().findSslHostConfigs()) {
                    if (sslHostConfig.getOpenSslContext() == 0L) {
                        Set<SSLHostConfigCertificate> sslHostConfigCerts = sslHostConfig.getCertificates();
                        for (SSLHostConfigCertificate sslHostConfigCert : sslHostConfigCerts) {
                            X509Certificate[] certs;
                            String name2 = connector.toString() + "-" + sslHostConfig.getHostName() + "-" + (Object)((Object)sslHostConfigCert.getType());
                            ArrayList<String> certList = new ArrayList<String>();
                            SSLContext sslContext = sslHostConfigCert.getSslContext();
                            String alias2 = sslHostConfigCert.getCertificateKeyAlias();
                            if (alias2 == null) {
                                alias2 = "tomcat";
                            }
                            if ((certs = sslContext.getCertificateChain(alias2)) == null) {
                                certList.add(smClient.getString("managerServlet.certsNotAvailable"));
                            } else {
                                for (X509Certificate cert : certs) {
                                    certList.add(cert.toString());
                                }
                            }
                            result.put(name2, certList);
                        }
                        continue;
                    }
                    ArrayList<String> certList = new ArrayList<String>();
                    certList.add(smClient.getString("managerServlet.certsNotAvailable"));
                    String name3 = connector.toString() + "-" + sslHostConfig.getHostName();
                    result.put(name3, certList);
                }
                continue;
            }
            ArrayList<String> certList = new ArrayList<String>(1);
            certList.add(smClient.getString("managerServlet.notSslConnector"));
            result.put(connector.toString(), certList);
        }
        return result;
    }

    protected Map<String, List<String>> getConnectorTrustedCerts(StringManager smClient) {
        Connector[] connectors;
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (Connector connector : connectors = this.getConnectors()) {
            if (Boolean.TRUE.equals(connector.getProperty("SSLEnabled"))) {
                SSLHostConfig[] sslHostConfigs;
                for (SSLHostConfig sslHostConfig : sslHostConfigs = connector.getProtocolHandler().findSslHostConfigs()) {
                    String name2 = connector.toString() + "-" + sslHostConfig.getHostName();
                    ArrayList<String> certList = new ArrayList<String>();
                    if (sslHostConfig.getOpenSslContext() == 0L) {
                        SSLContext sslContext = sslHostConfig.getCertificates().iterator().next().getSslContext();
                        X509Certificate[] certs = sslContext.getAcceptedIssuers();
                        if (certs == null) {
                            certList.add(smClient.getString("managerServlet.certsNotAvailable"));
                        } else if (certs.length == 0) {
                            certList.add(smClient.getString("managerServlet.trustedCertsNotConfigured"));
                        } else {
                            for (X509Certificate cert : certs) {
                                certList.add(cert.toString());
                            }
                        }
                    } else {
                        certList.add(smClient.getString("managerServlet.certsNotAvailable"));
                    }
                    result.put(name2, certList);
                }
                continue;
            }
            ArrayList<String> certList = new ArrayList<String>(1);
            certList.add(smClient.getString("managerServlet.notSslConnector"));
            result.put(connector.toString(), certList);
        }
        return result;
    }

    private Connector[] getConnectors() {
        Engine e2 = (Engine)this.host.getParent();
        Service s = e2.getService();
        return s.findConnectors();
    }
}

