/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.manager.host;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.StringTokenizer;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerServlet;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.HostConfig;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.StringUtils;
import org.apache.tomcat.util.res.StringManager;

public class HostManagerServlet
extends HttpServlet
implements ContainerServlet {
    private static final long serialVersionUID = 1L;
    protected transient Context context = null;
    protected int debug = 1;
    protected transient Host installedHost = null;
    protected transient Engine engine = null;
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.manager.host");
    protected transient Wrapper wrapper = null;

    @Override
    public Wrapper getWrapper() {
        return this.wrapper;
    }

    @Override
    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
        if (wrapper == null) {
            this.context = null;
            this.installedHost = null;
            this.engine = null;
        } else {
            this.context = (Context)wrapper.getParent();
            this.installedHost = (Host)this.context.getParent();
            this.engine = (Engine)this.installedHost.getParent();
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        StringManager smClient = StringManager.getManager("org.apache.catalina.manager.host", request.getLocales());
        String command = request.getPathInfo();
        if (command == null) {
            command = request.getServletPath();
        }
        String name2 = request.getParameter("name");
        response.setContentType("text/plain; charset=utf-8");
        response.setHeader("X-Content-Type-Options", "nosniff");
        PrintWriter writer2 = response.getWriter();
        if (command == null) {
            writer2.println(smClient.getString("hostManagerServlet.noCommand"));
        } else if (command.equals("/add")) {
            this.add(request, writer2, name2, false, smClient);
        } else if (command.equals("/remove")) {
            this.remove(writer2, name2, smClient);
        } else if (command.equals("/list")) {
            this.list(writer2, smClient);
        } else if (command.equals("/start")) {
            this.start(writer2, name2, smClient);
        } else if (command.equals("/stop")) {
            this.stop(writer2, name2, smClient);
        } else if (command.equals("/persist")) {
            this.persist(writer2, smClient);
        } else {
            writer2.println(smClient.getString("hostManagerServlet.unknownCommand", command));
        }
        writer2.flush();
        writer2.close();
    }

    protected void add(HttpServletRequest request, PrintWriter writer2, String name2, boolean htmlMode, StringManager smClient) {
        String aliases = request.getParameter("aliases");
        String appBase = request.getParameter("appBase");
        boolean manager = this.booleanParameter(request, "manager", false, htmlMode);
        boolean autoDeploy = this.booleanParameter(request, "autoDeploy", true, htmlMode);
        boolean deployOnStartup = this.booleanParameter(request, "deployOnStartup", true, htmlMode);
        boolean deployXML = this.booleanParameter(request, "deployXML", true, htmlMode);
        boolean unpackWARs = this.booleanParameter(request, "unpackWARs", true, htmlMode);
        boolean copyXML = this.booleanParameter(request, "copyXML", false, htmlMode);
        this.add(writer2, name2, aliases, appBase, manager, autoDeploy, deployOnStartup, deployXML, unpackWARs, copyXML, smClient);
    }

    protected boolean booleanParameter(HttpServletRequest request, String parameter, boolean theDefault, boolean htmlMode) {
        String value = request.getParameter(parameter);
        boolean booleanValue = theDefault;
        if (value != null) {
            if (htmlMode) {
                if (value.equals("on")) {
                    booleanValue = true;
                }
            } else if (theDefault) {
                if (value.equals("false")) {
                    booleanValue = false;
                }
            } else if (value.equals("true")) {
                booleanValue = true;
            }
        } else if (htmlMode) {
            booleanValue = false;
        }
        return booleanValue;
    }

    @Override
    public void init() throws ServletException {
        if (this.wrapper == null || this.context == null) {
            throw new UnavailableException(sm.getString("hostManagerServlet.noWrapper"));
        }
        String value = null;
        try {
            value = this.getServletConfig().getInitParameter("debug");
            this.debug = Integer.parseInt(value);
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
        }
    }

    protected synchronized void add(PrintWriter writer2, String name2, String aliases, String appBase, boolean manager, boolean autoDeploy, boolean deployOnStartup, boolean deployXML, boolean unpackWARs, boolean copyXML, StringManager smClient) {
        if (this.debug >= 1) {
            this.log(sm.getString("hostManagerServlet.add", name2));
        }
        if (name2 == null || name2.length() == 0) {
            writer2.println(smClient.getString("hostManagerServlet.invalidHostName", name2));
            return;
        }
        if (this.engine.findChild(name2) != null) {
            writer2.println(smClient.getString("hostManagerServlet.alreadyHost", name2));
            return;
        }
        File appBaseFile = null;
        File file2 = null;
        String applicationBase = appBase;
        if (applicationBase == null || applicationBase.length() == 0) {
            applicationBase = name2;
        }
        if (!(file2 = new File(applicationBase)).isAbsolute()) {
            file2 = new File(this.engine.getCatalinaBase(), file2.getPath());
        }
        try {
            appBaseFile = file2.getCanonicalFile();
        }
        catch (IOException e2) {
            appBaseFile = file2;
        }
        if (!appBaseFile.mkdirs() && !appBaseFile.isDirectory()) {
            writer2.println(smClient.getString("hostManagerServlet.appBaseCreateFail", appBaseFile.toString(), name2));
            return;
        }
        File configBaseFile = this.getConfigBase(name2);
        if (manager) {
            if (configBaseFile == null) {
                writer2.println(smClient.getString("hostManagerServlet.configBaseCreateFail", name2));
                return;
            }
            try (InputStream is2 = this.getServletContext().getResourceAsStream("/manager.xml");){
                Path dest = new File(configBaseFile, "manager.xml").toPath();
                Files.copy(is2, dest, new CopyOption[0]);
            }
            catch (IOException e3) {
                writer2.println(smClient.getString("hostManagerServlet.managerXml"));
                return;
            }
        }
        StandardHost host = new StandardHost();
        host.setAppBase(applicationBase);
        host.setName(name2);
        host.addLifecycleListener(new HostConfig());
        if (aliases != null && !"".equals(aliases)) {
            StringTokenizer tok = new StringTokenizer(aliases, ", ");
            while (tok.hasMoreTokens()) {
                host.addAlias(tok.nextToken());
            }
        }
        host.setAutoDeploy(autoDeploy);
        host.setDeployOnStartup(deployOnStartup);
        host.setDeployXML(deployXML);
        host.setUnpackWARs(unpackWARs);
        host.setCopyXML(copyXML);
        try {
            this.engine.addChild(host);
        }
        catch (Exception e4) {
            writer2.println(smClient.getString("hostManagerServlet.exception", e4.toString()));
            return;
        }
        host = (StandardHost)this.engine.findChild(name2);
        if (host != null) {
            writer2.println(smClient.getString("hostManagerServlet.addSuccess", name2));
        } else {
            writer2.println(smClient.getString("hostManagerServlet.addFailed", name2));
        }
    }

    protected synchronized void remove(PrintWriter writer2, String name2, StringManager smClient) {
        if (this.debug >= 1) {
            this.log(sm.getString("hostManagerServlet.remove", name2));
        }
        if (name2 == null || name2.length() == 0) {
            writer2.println(smClient.getString("hostManagerServlet.invalidHostName", name2));
            return;
        }
        if (this.engine.findChild(name2) == null) {
            writer2.println(smClient.getString("hostManagerServlet.noHost", name2));
            return;
        }
        if (this.engine.findChild(name2) == this.installedHost) {
            writer2.println(smClient.getString("hostManagerServlet.cannotRemoveOwnHost", name2));
            return;
        }
        try {
            Container child = this.engine.findChild(name2);
            this.engine.removeChild(child);
            if (child instanceof ContainerBase) {
                child.destroy();
            }
        }
        catch (Exception e2) {
            writer2.println(smClient.getString("hostManagerServlet.exception", e2.toString()));
            return;
        }
        StandardHost host = (StandardHost)this.engine.findChild(name2);
        if (host == null) {
            writer2.println(smClient.getString("hostManagerServlet.removeSuccess", name2));
        } else {
            writer2.println(smClient.getString("hostManagerServlet.removeFailed", name2));
        }
    }

    protected void list(PrintWriter writer2, StringManager smClient) {
        Container[] hosts;
        if (this.debug >= 1) {
            this.log(sm.getString("hostManagerServlet.list", this.engine.getName()));
        }
        writer2.println(smClient.getString("hostManagerServlet.listed", this.engine.getName()));
        for (Container container : hosts = this.engine.findChildren()) {
            Host host = (Host)container;
            String name2 = host.getName();
            String[] aliases = host.findAliases();
            writer2.println(smClient.getString("hostManagerServlet.listitem", name2, StringUtils.join(aliases)));
        }
    }

    protected void start(PrintWriter writer2, String name2, StringManager smClient) {
        if (this.debug >= 1) {
            this.log(sm.getString("hostManagerServlet.start", name2));
        }
        if (name2 == null || name2.length() == 0) {
            writer2.println(smClient.getString("hostManagerServlet.invalidHostName", name2));
            return;
        }
        Container host = this.engine.findChild(name2);
        if (host == null) {
            writer2.println(smClient.getString("hostManagerServlet.noHost", name2));
            return;
        }
        if (host == this.installedHost) {
            writer2.println(smClient.getString("hostManagerServlet.cannotStartOwnHost", name2));
            return;
        }
        if (host.getState().isAvailable()) {
            writer2.println(smClient.getString("hostManagerServlet.alreadyStarted", name2));
            return;
        }
        try {
            host.start();
            writer2.println(smClient.getString("hostManagerServlet.started", name2));
        }
        catch (Exception e2) {
            this.getServletContext().log(sm.getString("hostManagerServlet.startFailed", name2), e2);
            writer2.println(smClient.getString("hostManagerServlet.startFailed", name2));
            writer2.println(smClient.getString("hostManagerServlet.exception", e2.toString()));
        }
    }

    protected void stop(PrintWriter writer2, String name2, StringManager smClient) {
        if (this.debug >= 1) {
            this.log(sm.getString("hostManagerServlet.stop", name2));
        }
        if (name2 == null || name2.length() == 0) {
            writer2.println(smClient.getString("hostManagerServlet.invalidHostName", name2));
            return;
        }
        Container host = this.engine.findChild(name2);
        if (host == null) {
            writer2.println(smClient.getString("hostManagerServlet.noHost", name2));
            return;
        }
        if (host == this.installedHost) {
            writer2.println(smClient.getString("hostManagerServlet.cannotStopOwnHost", name2));
            return;
        }
        if (!host.getState().isAvailable()) {
            writer2.println(smClient.getString("hostManagerServlet.alreadyStopped", name2));
            return;
        }
        try {
            host.stop();
            writer2.println(smClient.getString("hostManagerServlet.stopped", name2));
        }
        catch (Exception e2) {
            this.getServletContext().log(sm.getString("hostManagerServlet.stopFailed", name2), e2);
            writer2.println(smClient.getString("hostManagerServlet.stopFailed", name2));
            writer2.println(smClient.getString("hostManagerServlet.exception", e2.toString()));
        }
    }

    protected void persist(PrintWriter writer2, StringManager smClient) {
        if (this.debug >= 1) {
            this.log(sm.getString("hostManagerServlet.persist"));
        }
        try {
            MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName oname = new ObjectName(this.engine.getDomain() + ":type=StoreConfig");
            platformMBeanServer.invoke(oname, "storeConfig", null, null);
            writer2.println(smClient.getString("hostManagerServlet.persisted"));
        }
        catch (Exception e2) {
            this.getServletContext().log(sm.getString("hostManagerServlet.persistFailed"), e2);
            writer2.println(smClient.getString("hostManagerServlet.persistFailed"));
            if (e2 instanceof InstanceNotFoundException) {
                writer2.println("Please enable StoreConfig to use this feature.");
            }
            writer2.println(smClient.getString("hostManagerServlet.exception", e2.toString()));
        }
    }

    protected File getConfigBase(String hostName) {
        File configBase = new File(this.context.getCatalinaBase(), "conf");
        if (!configBase.exists()) {
            return null;
        }
        if (this.engine != null) {
            configBase = new File(configBase, this.engine.getName());
        }
        if (this.installedHost != null) {
            configBase = new File(configBase, hostName);
        }
        if (!configBase.mkdirs() && !configBase.isDirectory()) {
            return null;
        }
        return configBase;
    }
}

