/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import org.apache.tomcat.util.file.ConfigurationSource;
import org.apache.tomcat.util.res.StringManager;

public class CatalinaBaseConfigurationSource
implements ConfigurationSource {
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");
    private final String serverXmlPath;
    private final File catalinaBaseFile;
    private final URI catalinaBaseUri;

    public CatalinaBaseConfigurationSource(File catalinaBaseFile, String serverXmlPath) {
        this.catalinaBaseFile = catalinaBaseFile;
        this.catalinaBaseUri = catalinaBaseFile.toURI();
        this.serverXmlPath = serverXmlPath;
    }

    @Override
    public ConfigurationSource.Resource getServerXml() throws IOException {
        InputStream stream;
        IOException ioe = null;
        ConfigurationSource.Resource result = null;
        try {
            result = this.serverXmlPath == null || this.serverXmlPath.equals("conf/server.xml") ? ConfigurationSource.super.getServerXml() : this.getResource(this.serverXmlPath);
        }
        catch (IOException e2) {
            ioe = e2;
        }
        if (result == null && (stream = this.getClass().getClassLoader().getResourceAsStream("server-embed.xml")) != null) {
            try {
                result = new ConfigurationSource.Resource(stream, this.getClass().getClassLoader().getResource("server-embed.xml").toURI());
            }
            catch (URISyntaxException e3) {
                stream.close();
            }
        }
        if (result == null && ioe != null) {
            throw ioe;
        }
        return result;
    }

    @Override
    public ConfigurationSource.Resource getResource(String name2) throws IOException {
        File f = new File(name2);
        if (!f.isAbsolute()) {
            f = new File(this.catalinaBaseFile, name2);
        }
        if (f.isFile()) {
            FileInputStream fis = new FileInputStream(f);
            return new ConfigurationSource.Resource(fis, f.toURI());
        }
        InputStream stream = null;
        try {
            stream = this.getClass().getClassLoader().getResourceAsStream(name2);
            if (stream != null) {
                return new ConfigurationSource.Resource(stream, this.getClass().getClassLoader().getResource(name2).toURI());
            }
        }
        catch (InvalidPathException e2) {
            if (stream != null) {
                stream.close();
            }
        }
        catch (URISyntaxException e3) {
            stream.close();
            throw new IOException(sm.getString("catalinaConfigurationSource.cannotObtainURL", name2), e3);
        }
        URI uri = null;
        try {
            uri = this.getURI(name2);
        }
        catch (IllegalArgumentException e4) {
            throw new IOException(sm.getString("catalinaConfigurationSource.cannotObtainURL", name2), e4);
        }
        try {
            URL url = uri.toURL();
            return new ConfigurationSource.Resource(url.openConnection().getInputStream(), uri);
        }
        catch (MalformedURLException e5) {
            throw new IOException(sm.getString("catalinaConfigurationSource.cannotObtainURL", name2), e5);
        }
    }

    @Override
    public URI getURI(String name2) {
        File f = new File(name2);
        if (!f.isAbsolute()) {
            f = new File(this.catalinaBaseFile, name2);
        }
        if (f.isFile()) {
            return f.toURI();
        }
        try {
            URL resource2 = this.getClass().getClassLoader().getResource(name2);
            if (resource2 != null) {
                return resource2.toURI();
            }
        }
        catch (Exception resource2) {
            // empty catch block
        }
        URI uri = this.catalinaBaseUri != null ? this.catalinaBaseUri.resolve(name2) : URI.create(name2);
        return uri;
    }
}

